/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class LocalizationTest {
    static final int LOC_PACKET_SIZE = 32;
    static final int NOT_A_MARKER = 10;
    static final float fieldLength = 4500.0f;
    static final float fieldWidth = 3000.0f;
    static final float[] MWX = new float[]{-1500.0f, 1500.0f, -1500.0f, 1500.0f, -1500.0f, 1500.0f};
    static final float[] MWY = new float[]{-2250.0f, -2250.0f, 0.0f, 0.0f, 2250.0f, 2250.0f};
    static double rWX;
    static double rWY;
    static double rWTH;
    static double rDX;
    static double rDY;
    static double rDTH;
    static double[] PX;
    static double[] PY;
    static final double MSp = 0.15;
    static final double MSpMin = 100.0;
    static final double MSo = 1.1;
    static final double MSoMin = 733.3333333333335;
    static final double MSa = 0.17453292519943295;
    static final double OSp = 0.8;
    static final double OSo = 0.5;
    static final double OSa = 0.8;
    static final double MInit = 0.2;
    static final double MInitA = 0.7853981633974483;
    static double PTH;
    static double PTHm;
    static double XTHm;
    static double XTH;
    static double QTH;
    static double RTH;
    static double KTH;
    static double ZTH;
    static Matrix P;
    static Matrix Pm;
    static Matrix Q;
    static Matrix R;
    static Matrix K;
    static Matrix I;
    static Matrix L;
    static Matrix T;
    static Matrix B;
    static Matrix U;
    static Matrix Xm;
    static Matrix X;
    static Matrix Z;
    static final int PREDICT = 0;
    static final int CORRECT = 1;
    static final int UNINITIALIZED = 100;
    static int MID;
    static int oldMID;

    private static void localization(Vector vector, Vector vector2) {
        int n = 0;
        int n2 = vector2.size();
        int n3 = 0;
        while (n3 < n2 && !LocalizationTest.absoluteLocalization((LogObject)vector2.elementAt(n3), vector)) {
            ++n3;
        }
        int n4 = n3 + 1;
        while (n4 < n2) {
            try {
                n4 = LocalizationTest.relativeLocalization(n4, vector2, vector, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (++n <= 1) continue;
            n = 0;
        }
    }

    private static int relativeLocalization(int n, Vector vector, Vector vector2, int n2) throws Exception {
        LogObject logObject = (LogObject)vector.elementAt(n);
        if (n2 == 0) {
            if (logObject.type.equals("Odom")) {
                rDTH = (double)logObject.par3 / 1000.0;
                rDX = logObject.par1;
                rDY = logObject.par2;
                double d = rDX * rDX + rDY * rDY;
                double d2 = Math.atan2(rDY, rDX);
                XTHm = XTH + rDTH;
                QTH = rDTH * rDTH * 0.8 * 0.8;
                PTHm = PTH + QTH;
                B.setElement(0, 0, Math.cos(XTHm));
                B.setElement(0, 1, -Math.sin(XTHm));
                B.setElement(1, 0, Math.sin(XTHm));
                B.setElement(1, 1, Math.cos(XTHm));
                U.setElement(0, 0, logObject.par1);
                U.setElement(1, 0, logObject.par2);
                Xm = X.add(B.mul(U));
                rWX = Xm.getElement(0, 0);
                rWY = Xm.getElement(1, 0);
                rWTH = XTHm;
                T.setElement(0, 0, Math.cos(d2 + XTHm));
                T.setElement(0, 1, -Math.sin(d2 + XTHm));
                T.setElement(1, 0, Math.sin(d2 + XTHm));
                T.setElement(1, 1, Math.cos(d2 + XTHm));
                L.setElement(0, 0, 0.6400000000000001 * d);
                L.setElement(0, 1, 0.0);
                L.setElement(1, 0, 0.0);
                L.setElement(1, 1, 0.25 * d);
                Q = T.mul(L).mul(T.trans());
                Pm = P.add(Q);
                LocalizationShot localizationShot = new LocalizationShot();
                localizationShot.X = Xm;
                localizationShot.P = Pm;
                localizationShot.TH = XTHm;
                localizationShot.PTH = PTHm;
                localizationShot.Mrange = 0.0;
                localizationShot.localized = true;
                vector2.add(localizationShot);
                return ++n;
            }
            Pm = P;
            Xm = X;
            XTHm = XTH;
            PTHm = PTH;
            rWX = Xm.getElement(0, 0);
            rWY = Xm.getElement(1, 0);
            rWTH = XTHm;
            return n;
        }
        if (!logObject.type.equals("Odom")) {
            float f;
            MID = logObject.par3;
            double d = logObject.par1;
            float f2 = (float)(d * 0.15);
            if ((double)f2 < 100.0) {
                f2 = 100.0f;
            }
            if ((double)(f = (float)(d * 1.1)) < 733.3333333333335) {
                f = 733.3333f;
            }
            double d3 = Xm.getElement(0, 0) - (double)MWX[MID];
            double d4 = Xm.getElement(1, 0) - (double)MWY[MID];
            double d5 = Math.atan2(d4, d3);
            Z.setElement(0, 0, (double)MWX[MID] + d * Math.cos(d5));
            Z.setElement(1, 0, (double)MWY[MID] + d * Math.sin(d5));
            T.setElement(0, 0, Math.cos(d5));
            T.setElement(0, 1, -Math.sin(d5));
            T.setElement(1, 0, Math.sin(d5));
            T.setElement(1, 1, Math.cos(d5));
            L.setElement(0, 0, f2 * f2);
            L.setElement(0, 1, 0.0);
            L.setElement(1, 0, 0.0);
            L.setElement(1, 1, f * f);
            R = T.mul(L).mul(T.trans());
            K = Pm.mul(Pm.add(R).inv());
            X = Xm.add(K.mul(Z.sub(Xm)));
            P = I.sub(K).mul(Pm);
            rWX = X.getElement(0, 0);
            rWY = X.getElement(1, 0);
            double d6 = X.getElement(0, 0) - (double)MWX[MID];
            double d7 = X.getElement(1, 0) - (double)MWY[MID];
            double d8 = 1.5707963267948966 + Math.atan2(d7, d6);
            ZTH = d8 - (double)logObject.par2 / 1000.0;
            RTH = 0.030461741978670857;
            KTH = PTHm / (PTHm + RTH);
            PTH = (1.0 - KTH) * PTHm;
            if (ZTH - XTHm > Math.PI) {
                ZTH -= Math.PI * 2;
            } else if (XTHm - ZTH > Math.PI) {
                XTHm -= Math.PI * 2;
            }
            rWTH = XTH = XTHm + KTH * (ZTH - XTHm);
            LocalizationShot localizationShot = new LocalizationShot();
            localizationShot.X = X;
            localizationShot.P = P;
            localizationShot.R = R;
            localizationShot.TH = XTH;
            localizationShot.PTH = PTH;
            localizationShot.measuredPos = new Matrix(Z);
            localizationShot.MID = MID;
            localizationShot.Mrange = logObject.par1;
            double d9 = (double)logObject.par1 * 0.15;
            if (d9 < 100.0) {
                d9 = 100.0;
            }
            localizationShot.Mvar = d9 * d9;
            localizationShot.localized = true;
            vector2.add(localizationShot);
            return ++n;
        }
        P = Pm;
        X = Xm;
        XTH = XTHm;
        PTH = PTHm;
        rWX = X.getElement(0, 0);
        rWY = X.getElement(1, 0);
        rWTH = XTH;
        return n;
    }

    private static boolean absoluteLocalization(LogObject logObject, Vector vector) {
        if (logObject.type != "Odom") {
            if (oldMID != 100) {
                if (oldMID == logObject.par3) {
                    LocalizationTest.PX[0] = (double)(-logObject.par1) * Math.sin((double)logObject.par2 / 1000.0);
                    LocalizationTest.PY[0] = (double)logObject.par1 * Math.cos((double)logObject.par2 / 1000.0);
                    rDTH = 0.0;
                    rDY = 0.0;
                    rDX = 0.0;
                    LocalizationShot localizationShot = new LocalizationShot();
                    localizationShot.localized = false;
                    localizationShot.MID = oldMID;
                    localizationShot.Mrange = logObject.par1;
                    double d = (double)logObject.par1 * 0.15;
                    if (d < 100.0) {
                        d = 100.0;
                    }
                    localizationShot.Mvar = d * d;
                    vector.add(localizationShot);
                    return false;
                }
                if (Math.sqrt(rDX * rDX + rDY + rDY) < 100.0 && Math.abs(rDTH) < 0.3490658503988659) {
                    LocalizationTest.PX[1] = (double)(-logObject.par1) * Math.sin((double)logObject.par2 / 1000.0);
                    LocalizationTest.PY[1] = (double)logObject.par1 * Math.cos((double)logObject.par2 / 1000.0);
                    int n = logObject.par3;
                    double d = PX[0];
                    double d2 = PY[0];
                    double d3 = PX[1];
                    double d4 = PY[1];
                    double d5 = MWX[n];
                    double d6 = MWY[n];
                    double d7 = MWX[oldMID];
                    double d8 = MWY[oldMID];
                    double d9 = d3 - d;
                    double d10 = d4 - d2;
                    double d11 = d5 - d7;
                    double d12 = d6 - d8;
                    Matrix matrix = new Matrix(0);
                    matrix.setElement(0, 0, d9);
                    matrix.setElement(0, 1, -d10);
                    matrix.setElement(1, 0, d10);
                    matrix.setElement(1, 1, d9);
                    Matrix matrix2 = new Matrix(2);
                    matrix2.setElement(0, 0, d11);
                    matrix2.setElement(1, 0, d12);
                    Matrix matrix3 = null;
                    try {
                        matrix3 = matrix.inv().mul(matrix2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    double d13 = matrix3.getElement(0, 0);
                    double d14 = matrix3.getElement(1, 0);
                    rWX = d5 - d13 * d3 + d14 * d4;
                    rWY = d6 - d14 * d3 - d13 * d4;
                    double d15 = rWX - (double)MWX[n];
                    double d16 = rWY - (double)MWY[n];
                    double d17 = d15 * d15 + d16 * d16;
                    rWTH = Math.atan2(d14, d13);
                    P.setElement(0, 0, 0.04000000000000001 * d17);
                    P.setElement(1, 0, 0.0);
                    P.setElement(0, 1, 0.0);
                    P.setElement(1, 1, 0.04000000000000001 * d17);
                    X.setElement(0, 0, rWX);
                    X.setElement(1, 0, rWY);
                    PTH = 0.6168502750680849;
                    XTH = rWTH;
                    LocalizationShot localizationShot = new LocalizationShot();
                    localizationShot.X = X;
                    localizationShot.P = P;
                    localizationShot.measuredPos = new Matrix(2);
                    localizationShot.R = new Matrix(0);
                    localizationShot.TH = XTH;
                    localizationShot.PTH = PTH;
                    localizationShot.MID = n;
                    localizationShot.Mrange = logObject.par1;
                    double d18 = (double)logObject.par1 * 0.15;
                    if (d18 < 100.0) {
                        d18 = 100.0;
                    }
                    localizationShot.Mvar = d18 * d18;
                    localizationShot.localized = true;
                    vector.add(localizationShot);
                    return true;
                }
                LocalizationTest.PX[0] = (double)(-logObject.par1) * Math.sin((double)logObject.par2 / 1000.0);
                LocalizationTest.PY[0] = (double)logObject.par1 * Math.cos((double)logObject.par2 / 1000.0);
                oldMID = logObject.par3;
                rDTH = 0.0;
                rDY = 0.0;
                rDX = 0.0;
                LocalizationShot localizationShot = new LocalizationShot();
                localizationShot.localized = false;
                localizationShot.MID = oldMID;
                localizationShot.Mrange = logObject.par1;
                double d = (double)logObject.par1 * 0.15;
                if (d < 100.0) {
                    d = 100.0;
                }
                localizationShot.Mvar = d * d;
                vector.add(localizationShot);
                return false;
            }
            LocalizationTest.PX[0] = (double)(-logObject.par1) * Math.sin((double)logObject.par2 / 1000.0);
            LocalizationTest.PY[0] = (double)logObject.par1 * Math.cos((double)logObject.par2 / 1000.0);
            oldMID = logObject.par3;
            rDTH = 0.0;
            rDY = 0.0;
            rDX = 0.0;
            LocalizationShot localizationShot = new LocalizationShot();
            localizationShot.localized = false;
            localizationShot.MID = oldMID;
            localizationShot.Mrange = logObject.par1;
            double d = (double)logObject.par1 * 0.15;
            if (d < 100.0) {
                d = 100.0;
            }
            localizationShot.Mvar = d * d;
            vector.add(localizationShot);
            return false;
        }
        rDX += (double)Math.abs(logObject.par1);
        rDY += (double)Math.abs(logObject.par2);
        rDTH += (double)logObject.par3;
        return false;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 5000;
        String string = null;
        if (stringArray.length == 2) {
            string = stringArray[0];
            n = Integer.parseInt(stringArray[1]);
        } else if (stringArray.length == 1) {
            string = stringArray[0];
            System.out.println("Sintax: LocalizationTest <file path> [<port>]");
            System.out.println("Resorting to default port: 5000");
        } else {
            System.out.println("Error - Must specify a file path!");
            System.out.println("Sintax: LocalizationTest <file path> [<port>]");
            System.exit(0);
        }
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Socket socket = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        LogParser logParser = new LogParser(fileInputStream);
        Vector vector = logParser.parse();
        Vector vector2 = new Vector();
        LocalizationTest.localization(vector2, vector);
        fileInputStream.close();
        socket = serverSocket.accept();
        int n2 = 0;
        while (n2 < vector2.size()) {
            LocalizationShot localizationShot = (LocalizationShot)vector2.elementAt(n2);
            LogObject logObject = (LogObject)vector.elementAt(n2);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            inputStream = socket.getInputStream();
            outputStream = socket.getOutputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            if (localizationShot.localized) {
                dataOutputStream.writeInt(1);
                dataOutputStream.writeInt((int)localizationShot.P.getElement(0, 0));
                dataOutputStream.writeInt((int)localizationShot.P.getElement(0, 1));
                dataOutputStream.writeInt((int)localizationShot.P.getElement(1, 0));
                dataOutputStream.writeInt((int)localizationShot.P.getElement(1, 1));
                dataOutputStream.writeInt((int)localizationShot.X.getElement(0, 0));
                dataOutputStream.writeInt((int)localizationShot.X.getElement(1, 0));
                dataOutputStream.writeInt((int)(localizationShot.TH * 1000.0));
                dataOutputStream.writeInt((int)(localizationShot.PTH * 1000.0));
                if (!logObject.type.equals("Odom")) {
                    dataOutputStream.writeInt(localizationShot.MID);
                    dataOutputStream.writeInt((int)localizationShot.Mrange);
                    dataOutputStream.writeInt(logObject.par2);
                    dataOutputStream.writeInt((int)localizationShot.Mvar);
                    dataOutputStream.writeInt((int)localizationShot.R.getElement(0, 0));
                    dataOutputStream.writeInt((int)localizationShot.R.getElement(0, 1));
                    dataOutputStream.writeInt((int)localizationShot.R.getElement(1, 0));
                    dataOutputStream.writeInt((int)localizationShot.R.getElement(1, 1));
                    dataOutputStream.writeInt((int)localizationShot.measuredPos.getElement(0, 0));
                    dataOutputStream.writeInt((int)localizationShot.measuredPos.getElement(1, 0));
                } else {
                    dataOutputStream.writeInt(10);
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(0);
                }
                dataOutputStream.writeInt(10);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                if (logObject.type.equals("Odom")) {
                    dataOutputStream.writeInt(logObject.par1);
                    dataOutputStream.writeInt(logObject.par2);
                    dataOutputStream.writeInt(logObject.par3);
                } else {
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(0);
                }
            } else {
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                if (!logObject.type.equals("Odom")) {
                    dataOutputStream.writeInt(localizationShot.MID);
                    dataOutputStream.writeInt((int)localizationShot.Mrange);
                    dataOutputStream.writeInt(logObject.par2);
                    dataOutputStream.writeInt((int)localizationShot.Mvar);
                } else {
                    dataOutputStream.writeInt(10);
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(0);
                }
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(10);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                if (logObject.type.equals("Odom")) {
                    dataOutputStream.writeInt(logObject.par1);
                    dataOutputStream.writeInt(logObject.par2);
                    dataOutputStream.writeInt(logObject.par3);
                } else {
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(0);
                }
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byte by = 0;
            byte by2 = 0;
            byte by3 = 0;
            byte by4 = 0;
            int n3 = 0;
            while (n3 < 128) {
                by = byArray[n3];
                by2 = byArray[n3 + 1];
                by3 = byArray[n3 + 2];
                byArray[n3] = by4 = byArray[n3 + 3];
                byArray[n3 + 1] = by3;
                byArray[n3 + 2] = by2;
                byArray[n3 + 3] = by;
                n3 += 4;
            }
            outputStream.write(byArray, 0, byArray.length);
            try {
                dataInputStream.readInt();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n2;
        }
    }

    static {
        PX = new double[2];
        PY = new double[2];
        P = new Matrix(0);
        Pm = new Matrix(0);
        Q = new Matrix(0);
        R = new Matrix(0);
        K = new Matrix(0);
        I = new Matrix(1);
        L = new Matrix(0);
        T = new Matrix(0);
        B = new Matrix(0);
        U = new Matrix(2);
        Xm = new Matrix(2);
        X = new Matrix(2);
        Z = new Matrix(2);
        oldMID = 100;
    }
}

