#!bash
export PATH=/lib:/bin:/WINNT:/WINNT/System32:$PATH

GT_DIR=`pwd |sed 's@\(.*\)/Make.*@\1@' |sed 's@/cygdrive/\(.\)\(.*\)@\1:\2@'`
#GT_DIR is for example c:/GT2004
subst v: "$GT_DIR"
export REAL_GT_DIR="$GT_DIR"
export GT_DIR=v:

export MSDIR=$GT_DIR/Build/MS

export MAKE_MODE=UNIX
export DEBUG_MODE=nomemprot

if test $1x = x; then
  echo "! Usage: GT.bash <ProcessSet> [Debug/DebugNoDebugDrawing/Release [clean]], e.g. GT.bash CMD Release"
else
  if test ! -d $GT_DIR/Src/Processes/$1; then
    echo "! ERROR: unknown ProcessSet Src/Processes/$1"
  else
    
    cd $GT_DIR/Src
    rm `find . | grep '#' | sed 's/\.\///g'` >& /dev/null
    export PROCSET=$1
    CONF=$2

    if ! test x`ls $GT_DIR/Build/GT2004/$1 2>/dev/null | grep ERS7` = x; then
      echo "ERS-7 configurations not required anymore. Removing everything to force a rebuild..."
      rm -rf $GT_DIR/Build/GT2004/$1
    fi

    if test ! -d /usr/local/OPEN_R_SDK; then # dual installation?
      ln -s /usr/local/OPEN_R_SDK_ERS7 /usr/local/OPEN_R_SDK
    fi

    if test x$CONF = xRelease; then export OPTIMIZATION="true"; export DEBUG_DEFINITIONS="-DNDEBUG"; fi
    if test x$CONF = xDebug; then export OPTIMIZATION="false";  export DEBUG_DEFINITIONS="-DWLAN -Wno-deprecated"; fi
    if test x$CONF = xDebugNoDebugDrawing; then CONF="DND"; export OPTIMIZATION="true"; export DEBUG_DEFINITIONS="-DWLAN -DNO_DEBUG_DRAWING -Wno-deprecated"; fi
    if test x$CONF = xDebugNoWLAN; then export OPTIMIZATION="false"; export DEBUG_DEFINITIONS="-Wno-deprecated"; fi

    export PDIR=$GT_DIR/Build/GT2004/$1/$CONF

    if test $3x = cleanx; then echo "! remove $PDIR completely" && rm -rf $PDIR && echo "! remove Xabsl2-Stuff completely (is that really useful?)" && ../Make/Xabsl2.bash $3; fi

    mkdir -p $PDIR/bin
    echo "#this file is generated by GT.bash, always included by makefile" > $PDIR/depends.incl
    echo "#and than generated by makefile with Depend.exe" >> $PDIR/depends.incl
    #(make -r -f $GT_DIR/Make/makefile || exit) 2>&1 |grep -v "^make"
    make -r -f $GT_DIR/Make/makefile

    cd $GT_DIR/Make
    echo "! `date +%T` ...copy (gzipped) files to $MSDIR"

    if test -d $MSDIR; then rm -rf $MSDIR; fi
    mkdir -p $MSDIR/open-r/app/conf
    mkdir -p $MSDIR/open-r/app/objs
    for i in $(cd $PDIR/bin && ls *.bin); do gzip -c $PDIR/bin/$i >$MSDIR/open-r/app/objs/$i; done

    cp $GT_DIR/Src/Processes/$1/object.cfg $MSDIR/open-r/app/conf/object.cfg
    cp $GT_DIR/Src/Processes/$1/connect.cfg $MSDIR/open-r/app/conf/connect.cfg
    echo Layout $1 >$MSDIR/open-r/app/conf/config.cfg
    echo Configuration $CONF >>$MSDIR/open-r/app/conf/config.cfg
    echo DebugMode $DEBUG_MODE >>$MSDIR/open-r/app/conf/config.cfg

    #copy wlan configfile from ProcesssSet, if it doesnt exist in Config
    if test ! -f $GT_DIR/Config/wlanconf.txt; then
      if test -f $GT_DIR/Src/Processes/$1/wlanconf.txt; then
        cp -u $GT_DIR/Src/Processes/$1/wlanconf.txt $GT_DIR/Config/
      fi
    fi
  fi
fi

subst v: /D

#
# Change Log:
#
# $Log: GT.bash,v $
# Revision 1.16  2004/04/23 20:43:38  roefer
# DebugNoDebugDrawings now uses the directory DND to fix the linker error
#
# Revision 1.15  2004/02/15 22:56:20  dueffert
# REAL_GT_DIR introduced to allow debugging and v:-subst
#
# Revision 1.14  2004/02/14 20:13:03  dueffert
# subst-on-the-fly GT_DIR=v:
#
# Revision 1.13  2004/01/29 02:31:36  dueffert
# GTDir detection improved
#
# Revision 1.12  2004/01/12 16:01:34  roefer
# ERS7 configurations are not required anymore
#
# Revision 1.11  2004/01/12 15:19:05  richert
# rm of OPEN_R_SDK needed again
# the idea of just manipulating the symlink does not work
# this would have been nice for nonadmin users
#
# Revision 1.10  2004/01/12 12:25:22  richert
# no rm of OPEN_R_SDK needed anymore
# so nonadmins can run this script correctly
#
# Revision 1.9  2004/01/11 13:40:40  roefer
# copyfiles distinguishes between ERS210 and ERS7
#
# Revision 1.8  2004/01/10 19:58:10  roefer
# No special ERS-7 versions anymore in Build directory
#
# Revision 1.7  2004/01/04 17:27:56  roefer
# Adaptation to new communication scheme
#
# Revision 1.6  2003/12/30 21:34:59  roefer
# Ports 1043/1044 for ERS-7 added
#
# Revision 1.5  2003/12/27 17:57:32  roefer
# Simpler emon.log handling
#
# Revision 1.4  2003/12/16 18:12:07  juengel
# Added ERS7 Open-R
#
# Revision 1.3  2003/12/16 17:29:05  juengel
# Added ERS7 Open-R
#
# Revision 1.2  2003/12/05 21:51:52  roefer
# More projects in VC2003.NET
#
# Revision 1.1  2003/10/06 12:56:17  cvsadm
# Created GT2004 (M.J.)
#
# Revision 1.2  2003/09/23 16:32:08  juengel
# GT_DIR is set to working directory.
#
# Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
# created new repository for the competitions in Padova from the
# tamara CVS (Tuesday 2:00 pm)
#
# removed unused solutions
#
# Revision 1.18  2003/06/24 15:11:30  dueffert
# "DebugNoDebugDrawing" uses compiler flags for optimization now.
# This allows for stopping the times used in release version (eg ImageProcessor 20% faster).
# Unfortunately that does not work with emonlogparser. Use configuration "Debug" for that.
#
# Revision 1.17  2003/05/05 15:00:23  dueffert
# dependencies between projects are done in VS only
#
# Revision 1.16  2003/05/05 12:23:19  dueffert
# dependencies are now completely generated in c each time
#
# Revision 1.15  2003/04/14 15:55:45  loetzsch
# ATH German Open CVS remerge:
# bug fix
#
# Revision 1.2  2003/04/10 09:28:29  juengel
# no message
#
# Revision 1.1.1.1  2003/04/09 14:22:14  loetzsch
# started Aibo Team Humboldt's GermanOpen CVS
#
# Revision 1.14  2003/03/28 19:16:06  loetzsch
# new configurations
#
# Revision 1.13  2003/03/24 00:01:31  tim
# Added support for Potentialfields Makefile
#
# Revision 1.12  2003/03/11 16:16:17  dueffert
# Xabsl2 rebuild bug fixed
#
# Revision 1.11  2003/03/10 14:17:04  dueffert
# output time
#
# Revision 1.10  2003/02/20 16:14:48  dueffert
# warnings removed
#
# Revision 1.9  2003/02/13 16:00:37  goehring
# IMPORTANT: now uses correct (=NO) priviledges for cp
#
# Revision 1.8  2003/01/20 09:33:19  loetzsch
# no message
#
# Revision 1.7  2003/01/19 22:55:08  loetzsch
# cloned Humboldt2003BehaviorControl to
# DarmstadtDribblingDackelsBehaviorControl
#
# Revision 1.6  2002/12/22 12:31:38  roefer
# Line by line printing of messages in Developer Studio
#
# Revision 1.5  2002/12/12 11:49:59  loetzsch
# changed path
#
# Revision 1.4  2002/12/09 13:06:09  loetzsch
# Included Xabsl2 file generation into the make files
#
# Revision 1.3  2002/10/15 15:56:59  roefer
# SDK-addons no longer required
#
# Revision 1.2  2002/10/10 16:18:28  dueffert
# changes for RemoteProcessingSDK
#
# Revision 1.1  2002/09/10 15:11:38  cvsadm
# Created new project GT2003 (M.L.)
#
# Revision 1.8  2002/08/14 17:06:51  dueffert
# both bashs now use SDK-System-Binaries. These work with binaries build with SDK and Greenhills, but Greenhills-System-Binaries crash
#
# Revision 1.7  2002/08/13 12:07:04  dueffert
# gcc-builds now use another build directory to avoid conflicts
#
# Revision 1.6  2002/07/25 14:30:55  roefer
# Improved switching between gcc and gh
#
# Revision 1.5  2002/07/15 12:43:31  dueffert
# gcc with -g now, *.o debuggable, FormatedOutput integrated in makefile, mkbin seems to strip debug info
#
# Revision 1.4  2002/07/14 16:06:47  roefer
# Prepare for multiple SDK-addons
#
# Revision 1.3  2002/07/14 15:05:35  roefer
# Support for debug mode switching improved
#
# Revision 1.2  2002/07/14 14:03:06  roefer
# First working gcc-version
#
# Revision 1.1  2002/07/12 21:38:14  roefer
# Uniform naming conventions for gcc-relevant files
#
# Revision 1.4  2002/07/09 14:46:23  dueffert
# something for gcc port
#
# Revision 1.3  2002/07/08 10:20:18  dueffert
# further steps towards gcc
#
# Revision 1.2  2002/07/04 16:36:34  dueffert
# started to port to gcc
#
# Revision 1.1  2002/07/04 16:23:43  dueffert
# started to port to gcc
#
