#!/bin/bash

if [ $OSTYPE != cygwin ]; then
    export GT_DIR=$HOME/cvssources/GT2004
else
    export GT_DIR=`pwd |sed 's@\(.*\)/Make.*@\1@' |sed 's@/cygdrive/\(.\)\(.*\)@\1:\2@'`
    #GT_DIR is for example c:/GT2004
fi

# add path (important: if path is missing, no command will be found) and remove doubles
export PATH=/usr/local/bin:/usr/bin:/bin:/lib:`echo "$PATH" | /bin/sed "s=/usr/local/bin:/usr/bin:/bin:/lib:==g"`

if test $1x = x; then
  echo "! Usage: Router.bash [Debug/Release [clean]], e.g. Router.bash Debug"
else
  export ODIR=$GT_DIR/Build/Router/$1
  mkdir -p $ODIR
  if test $1x = Releasex; then export DEBUG_DEFINITIONS="-DNDEBUG -O2"; fi
  if test $1x = Debugx; then export DEBUG_DEFINITIONS="-g"; fi
  if test $2x = cleanx; then make -f Router.mak rebuild ; else make -f Router.mak ; fi
fi

#
# Change Log:
#
# $Log: Router.bash,v $
# Revision 1.5  2004/01/29 02:24:19  dueffert
# GTDir detection improved
#
# Revision 1.4  2004/01/12 16:01:34  roefer
# ERS7 configurations are not required anymore
#
# Revision 1.3  2003/12/31 00:08:44  roefer
# Path reset to OPEN_R_SDK_ERS210 before executing
#
# Revision 1.2  2003/12/05 21:51:52  roefer
# More projects in VC2003.NET
#
# Revision 1.1  2003/10/06 12:56:17  cvsadm
# Created GT2004 (M.J.)
#
# Revision 1.3  2003/09/24 16:10:42  juengel
# removed absolute paths
#
# Revision 1.2  2003/09/23 16:32:08  juengel
# GT_DIR is set to working directory.
#
# Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
# created new repository for the competitions in Padova from the
# tamara CVS (Tuesday 2:00 pm)
#
# removed unused solutions
#
# Revision 1.4  2003/04/28 10:44:12  roefer
# Using $OSTYPE instead of uname
#
# Revision 1.3  2003/04/07 22:03:12  timrie
# Added support for Linux
#
# Revision 1.2  2002/10/07 16:37:31  dueffert
# nearly works with SDK
#
# Revision 1.1  2002/09/10 15:11:38  cvsadm
# Created new project GT2003 (M.L.)
#
# Revision 1.7  2002/07/23 16:40:11  roefer
# Router and SimGT2002 adapted to new message queue and streams
#
# Revision 1.6  2002/07/10 08:35:08  roefer
# PATH fixed
#
# Revision 1.5  2002/06/28 10:26:18  roefer
# OUTPUT is possible in constructors
#
# Revision 1.4  2002/06/18 11:25:39  dueffert
# new GameManager
#
# Revision 1.3  2002/05/30 15:52:35  dueffert
# RobocupGameManager dependencies added
#
# Revision 1.2  2002/05/29 14:28:03  dueffert
# changelog added
#
#