MYARCH    := $(shell uname -s | tr [a-z] [A-Z] | sed s/_.*//g)

DEFINE  = \
	-D`uname -s | tr [a-z] [A-Z] | sed s/_.*//g` \


ifeq ($(MYARCH),LINUX)
    EXEEXT  := 
    TARGET  := ${ODIR}/Router-bin
    TEMP    := /tmp
    ARCH    := linux-i386
else
    EXEEXT  := .exe
    TARGET  := ${ODIR}/Router$(EXEEXT)
    ARCH    := cygwin
endif

SDIR    = $(GT_DIR)/Src
SHELL   = /bin/sh
CC      = g++
CFLAGS  = ${INCLUDE} ${DEFINE} ${OPTIONS}
LD      = ${CC}
OBJ     = ${SOURCE:$(SDIR)%.cpp=$(ODIR)%.o}
SYSEXE11= /usr/local/OPEN_R_SDK/RP_OPEN_R/lib/$(ARCH)/OObjectManager/oobjectManager$(EXEEXT)
SYSEXE12= /usr/local/OPEN_R_SDK/RP_OPEN_R/lib/$(ARCH)/OServiceManager/oserviceManager$(EXEEXT)
SYSEXE13= /usr/local/OPEN_R_SDK/RP_OPEN_R/lib/$(ARCH)/TCPGateway/tcpGateway$(EXEEXT)
SYSEXE14= /usr/local/OPEN_R_SDK/RP_OPEN_R/lib/$(ARCH)/RegistryManager/registryManager$(EXEEXT)
SYSEXE2 = $(GT_DIR)/Util/RoboCup-GameController-2004-r1/RoboCupGameController/RP/host/MS/OPEN-R/MW/OBJS/RGC.BIN

SOURCE  = \
	$(SDIR)/Router/Router.cpp \
	$(SDIR)/Tools/Debugging/QueueFillRequest.cpp \
	$(SDIR)/Platform/Linux/SystemCall.cpp \
	$(SDIR)/Platform/Linux/ProcessFramework.cpp \
	$(SDIR)/Platform/Linux/Sender.cpp \
	$(SDIR)/Platform/Linux/Receiver.cpp \
	$(SDIR)/Platform/Win32Linux/MessageQueueBase.cpp \
	$(SDIR)/Platform/Win32Linux/TcpConnection.cpp \
	$(SDIR)/Tools/MessageQueue/InMessage.cpp \
	$(SDIR)/Tools/MessageQueue/OutMessage.cpp \
	$(SDIR)/Tools/MessageQueue/MessageQueue.cpp \
	$(SDIR)/Tools/Streams/InStreams.cpp \
	$(SDIR)/Tools/Streams/OutStreams.cpp

RTMP     = $(SDIR)/Router/error.tmp

INCLUDE = \
	-I. \
	-I/usr/local/OPEN_R_SDK/RP_OPEN_R/include \
	-I$(GT_DIR)/Src


OPTIONS = \
	$(DEBUG_DEFINITIONS)

LIBRARY = \
	/usr/local/OPEN_R_SDK/RP_OPEN_R/lib/$(ARCH)/libObjectComm.a \
	/usr/local/OPEN_R_SDK/RP_OPEN_R/lib/$(ARCH)/libOPENR.a \

LDFLAGS = \
	`/usr/local/OPEN_R_SDK/RP_OPEN_R/bin/rp-openr-config --libs`

DEPENDENCIES = $(ODIR)/_dependencies

.SILENT:
.SUFFIXES :
.SUFFIXES : .o .cpp


all: ${DEPENDENCIES}
	${MAKE} -f Router.mak ${TARGET}
	${MAKE} -f Router.mak install

${TARGET} : ${OBJ} ${SYSEXE11} ${SYSEXE12} ${SYSEXE13} ${SYSEXE14} ${SYSEXE2}
	echo "! linking $@"
	${LD} -o $@ ${OBJ} ${LIBRARY} ${LDFLAGS}
	strip $@

${SYSEXE11}:
	echo "! creating $@"
	cd /usr/local/OPEN_R_SDK/RP_OPEN_R/lib/$(ARCH)/OObjectManager && ${MAKE}

${SYSEXE12}:
	echo "! creating $@"
	cd /usr/local/OPEN_R_SDK/RP_OPEN_R/lib/$(ARCH)/OServiceManager && ${MAKE}

${SYSEXE13}:
	echo "! creating $@"
	cd /usr/local/OPEN_R_SDK/RP_OPEN_R/lib/$(ARCH)/TCPGateway && ${MAKE}

${SYSEXE14}:
	echo "! creating $@"
	cd /usr/local/OPEN_R_SDK/RP_OPEN_R/lib/$(ARCH)/RegistryManager && ${MAKE}

${SYSEXE2}:
	echo "! creating $@"
	cd $(GT_DIR)/Util/RoboCup-GameController-2004-r1/RoboCupGameController/RP/host && ${MAKE} && ${MAKE} install

touch:
	touch ${SOURCE}

clean: 
	rm -f ${TARGET}
	rm -f ${OBJ}
	rm -f ${DEPENDENCIES}
	rm -f ${SYSEXE11}
	rm -f ${SYSEXE12}
	rm -f ${SYSEXE13}
	rm -f ${SYSEXE14}
	cd $(GT_DIR)/Util/RoboCup-GameController-2004-r1/RoboCupGameController/RP/host && ${MAKE} clean
	rm -f ${SYSLIB}

rebuild: clean all

install: ${TARGET} ${SYSEXE11} ${SYSEXE12} ${SYSEXE13} ${SYSEXE14} ${SYSEXE2}
	mkdir -p ${GT_DIR}/Bin/MS/OPEN-R/MW/OBJS
	cp ${TARGET} ${SYSEXE2} ${GT_DIR}/Bin/MS/OPEN-R/MW/OBJS
	cp ${TARGET} ${GT_DIR}/Bin/MS/OPEN-R/MW/OBJS


${DEPENDENCIES}: ${SOURCE} Router.mak
	echo "! creating dependencies"
	${CC} -M ${SOURCE} ${CFLAGS} 2>${RTMP}\
	| tr "\012" "%" | sed "s=: *\\\\%=:=g" | tr "%" "\012" \
	| sed "s=\(.*\): $(SDIR)\(.*/\)\([^/]*\.cpp\)=$(ODIR)\2\1: $(SDIR)\2\3=g" \
	| sed "s%\([^\\]\)$$%\1`echo -e '\\\\\\n\\\\\\techo \"! compiling $$<\" \&\& mkdir -p \`echo $$@ | sed \"s=/[^/]*\\\\\\.o==g\"\` \&\& $${CC} -c $$< -o $$@ $${CFLAGS} 2>$$(TEMP)/tmp ||(sed "s=:\\\\\\\\([0-9]*\\\\\\\\):=(\\\\\\\\1) : error:=g" <$$(TEMP)/tmp | sed "s=/=\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\=g" >\&2 \&\& false)'`%g" >${DEPENDENCIES}
	if test -f ${RTMP}; then \
		cat ${RTMP} \
		| sed 's%from \(.*[hp]\):\([0-9]*\)[,:]%from\1(\2):%g' |tr '' '\n' \
		| sed 's%:\([0-9]*\):\([0-9]*\):%(\1): line \2, %'; \
		rm ${RTMP}; \
	fi

depend:
	${MAKE} -f Router.mak ${DEPENDENCIES}

include ${DEPENDENCIES}

#
# Change Log:
#
# $Log: Router.mak,v $
# Revision 1.3  2004/03/15 12:18:47  tim
# using new RoboCup GameController
#
# Revision 1.2  2004/03/09 08:06:19  dueffert
# rebuilding includes GameController now
#
# Revision 1.1  2003/10/06 12:56:17  cvsadm
# Created GT2004 (M.J.)
#
# Revision 1.6  2003/09/26 12:53:50  dueffert
# GameController added 4 code release
#
# Revision 1.5  2003/09/26 11:42:02  juengel
# - sorted tools
# - clean-up in DataTypes
#
# Revision 1.4  2003/09/24 18:18:59  roefer
# t: and u: removed
#
# Revision 1.3  2003/08/17 18:35:37  roefer
# Communication with router standardized and synchronized
#
# Revision 1.2  2003/07/14 12:44:26  dueffert
# new GameManager added
#
# Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
# created new repository for the competitions in Padova from the 
# tamara CVS (Tuesday 2:00 pm)
#
# removed unused solutions
#
# Revision 1.7  2003/05/14 20:35:39  dueffert
# new GameController
#
# Revision 1.6  2003/04/07 22:03:38  timrie
# Added support for Linux
#
# Revision 1.5  2003/03/21 23:26:20  dueffert
# GameManager2003 added
#
# Revision 1.4  2002/10/11 11:37:24  roefer
# Router is working now
#
# Revision 1.3  2002/10/07 16:37:31  dueffert
# nearly works with SDK
#
# Revision 1.2  2002/10/07 11:22:59  dueffert
# dependencies with VS error output
#
# Revision 1.1  2002/09/10 15:11:38  cvsadm
# Created new project GT2003 (M.L.)
#
# Revision 1.12  2002/08/01 12:52:26  roefer
# RouterCtrl and TcpConnection added
#
# Revision 1.11  2002/07/23 16:40:11  roefer
# Router and SimGT2002 adapted to new message queue and streams
#
# Revision 1.10  2002/06/28 10:26:18  roefer
# OUTPUT is possible in constructors
#
# Revision 1.9  2002/06/14 14:53:12  dueffert
# new gameManager
#
# Revision 1.8  2002/05/31 14:17:09  dueffert
# libTeamInfo dependencies added
#
# Revision 1.7  2002/05/30 15:52:35  dueffert
# RobocupGameManager dependencies added
#
# Revision 1.6  2002/05/29 14:28:03  dueffert
# changelog added
#
#
