#!bash
# add path (important: if path is missing, no command will be found) and remove doubles
export PATH=/usr/local/bin:/usr/bin:/bin:/lib:`echo "$PATH" | /bin/sed "s=/usr/local/bin:/usr/bin:/bin:/lib:==g"`

export GT_DIR=`echo $0 |sed 's@\(.*\)/Make.*@\1@' |sed 's@/cygdrive/\(.\)\(.*\)@\1:\2@'`
#GT_DIR is for example c:/GT2004

echo "! copyfiles.bash $*"
echo "!"

# defaults
HELP=0
FORCE=0
UPD=""
PAUSE=0
NOPLAYER=0
ERS7=0
RM=0
EJECT=0
WLAN=WLAN
UNSAFE=0

# parse options
CONT=1
while test $CONT = 1; do
  case $1x in
    --helpx)
      shift
      HELP=1
      ;;
    --forcex)
      shift
      FORCE=1
      ;;
    --updatex)
      shift
      UPD="-u"
      ;;
    --pausex)
      shift
      PAUSE=1
      ;;
    --noplayerx)
      shift
      NOPLAYER=1
      ;;
    --rmx)
      shift
      RM=1
      ;;
    --wconsolex)
      shift
      WLAN=WCONSOLE
      ;;
    --unsafex)
      shift
      UNSAFE=1
      ;;
    --ejectx)
      shift
      EJECT=1
      ;;
    -dx)
      shift
      export GT_DIR=$1
      shift
      ;;
    -mx)
      shift
      export MSD=$1
      shift
      ;;
    ERS210x)
      shift
      ERS7=0
      ;;
    ERS7x)
      shift
      ERS7=1
      ;;
    x)
      CONT=0
      ;;
    *)
      HELP=1
      CONT=0
      ;;
  esac
done

if test $HELP = 1; then
  echo "usage:"
  echo "  copyfiles [--help | [-d <GTDIR>] [-m <MS>] [--force | --rm | --noplayer]"
  echo "            [--pause] [--eject] [ERS210 | ERS7 | --update] ]"
  echo "examples:"
  echo "  copyfiles.bash             update unchangeable files (wav), copy changeable ones (bin, conf, system), use system from GT.bash"
  echo "  copyfiles.bash ERS210      the same, use system for ERS210"
  echo "  copyfiles.bash ERS7        the same, use system for ERS7"
  echo "  copyfiles.bash --update    only copies newer files, do not copy system"
  echo "  copyfiles.bash --help      shows this help"
  echo "  copyfiles.bash -m H:       use H: as memorystick drive"
  echo "  copyfiles.bash -d T:/GT04  use T:/GT04 as GT_DIR"
  echo "  copyfiles.bash --force     formats the stick and copies everything, ensure right drive!"
  echo "  copyfiles.bash --noplayer  never touch player stuff"
  echo "  copyfiles.bash --pause     wait for key press after copying"
  echo "  copyfiles.bash --rm        rm -rf $MSD:/open-r before copying"
  echo "  copyfiles.bash --eject     call ct's deveject at the end"
else
  if test x$MSD = x; then
    case $HOSTNAME in
      SAM|PIGFINN)
        export MSD=d:
        ;;
      ANNE|calvin|clara)
        export MSD=e:
        ;;
      reinhold|komet|baudrillard|saviour|SAVIOUR|LAP59|ds43|WalterMobile)
        export MSD=f:
        ;;
      max3|Vernon|vaio|sparky|homie-m)
        export MSD=g:
        ;;
      ute|ltroefer|louis|knut|soda|leo)
        export MSD=h:
        ;;
      TINA)
        export MSD=o:
        ;;
      pluto|max)
        export MSD=i:
        ;;
      harry|jayjay)
        export MSD=j:
        ;;
      KILRATH|deepmo)
        export MSD=k:
        ;;
      BLUTWURST)
	export MSD=l:
	;;
      calculon|farnsworth)
        export MSD=c:/tmp/MemoryStick
        ;;
      sokmob)
        export MSD=t:/memstick
        ;;
      *)
        export MSD=e:
        ;;
    esac
  fi

  MSOPENR=$GT_DIR/Build/MS/open-r

  if test -d $MSD; then
    if test $FORCE = 1; then
      echo "! format $MSD and copy $MSOPENR directory to $MSD ..."
      echo "" | cmd /C format $MSD /V: /X /Q >/dev/null
    else
      if test $RM = 1; then
        echo "! rm -rf $MSD/open-r and copy $MSOPENR there ..."
        rm -rf $MSD/open-r
      else
        echo "! copy $MSOPENR directory to $MSD ..."
      fi
    fi

    if test x$UPD = x; then
      DEBUG_MODE=`grep DebugMode $MSOPENR/APP/CONF/CONFIG.CFG | sed "s%DebugMode %%"`
      if test $ERS7 = 0; then
        if test -d /usr/local/OPEN_R_SDK_ERS7; then # 1.1.4 / 1.1.5 dual installation?
          MSTREE=/usr/local/OPEN_R_SDK_ERS210/OPEN_R/MS/$WLAN/$DEBUG_MODE/
        else
          if test -d /usr/local/OPEN_R_SDK/OPEN_R/MS_ERS200; then # 1.1.5 installation?
            MSTREE=/usr/local/OPEN_R_SDK/OPEN_R/MS_ERS200/$WLAN/$DEBUG_MODE/
          else # 1.1.4 installation
            MSTREE=/usr/local/OPEN_R_SDK/OPEN_R/MS/$WLAN/$DEBUG_MODE/
          fi
        fi
      else
        if test -d /usr/local/OPEN_R_SDK_ERS7; then # 1.1.4 / 1.1.5 dual installation?
          MSTREE=/usr/local/OPEN_R_SDK_ERS7/OPEN_R/MS_ERS7/$WLAN/$DEBUG_MODE/
        else # 1.1.5 installation
          MSTREE=/usr/local/OPEN_R_SDK/OPEN_R/MS_ERS7/$WLAN/$DEBUG_MODE/
        fi
      fi
      cp -r $MSTREE/open-r $MSD
      if test $UNSAFE = 1; then
        chmod u+w $MSD/OPEN-R/SYSTEM/CONF/EXTOBJ.CFG
        grep -v EMGCYMON $MSTREE/OPEN-R/SYSTEM/CONF/EXTOBJ.CFG >$MSD/OPEN-R/SYSTEM/CONF/EXTOBJ.CFG
        chmod u-w $MSD/OPEN-R/SYSTEM/CONF/EXTOBJ.CFG
      fi
    fi
    

    #needed to avoid entering "start":
    mkdir -p $MSD/open-r/OTHERS/PSH
    echo "start" > $MSD/open-r/OTHERS/PSH/PSH.RC
    echo " " > $MSD/open-r/system/conf/MAV.CFG ;
    echo " " > $MSD/open-r/system/conf/OBJECT2.CFG ;
    if test $ERS7 = 1; then
      echo "JamDetectionHighThreshold" > $MSD/open-r/system/conf/VRCOMM.CFG
    fi
    
    #own binary stuff has to be copied always if --update is not given
    cp $UPD -r -f $MSOPENR/APP $MSD/open-r

    # copy tinyftpd server
    cp -u $GT_DIR/Util/TinyFTPD/bin/TINYFTPD.BIN $MSD/open-r/app/objs/tinyftpd.bin
   
    #sound files only have to be updated
    mkdir -p $MSD/open-r/app/conf/Sounds
    cp -u $GT_DIR/Config/Sounds/*.wav $MSD/open-r/app/conf/Sounds

    cp $UPD $GT_DIR/Config/empty_debug_request.dat $MSD/open-r/app/conf/requests.dat
    cp $UPD $GT_DIR/Config/spec_act.dat $MSD/open-r/app/conf/spec_act.dat
    cp $UPD $GT_DIR/Config/*.kst $MSD/open-r/app/conf/
    cp $UPD $GT_DIR/Config/nc_pop1.dat $MSD/open-r/app/conf/nc_pop1.dat
    rm -f $MSD/open-r/app/conf/udset7.dat
    cp $UPD $GT_DIR/Config/udset7.dat $MSD/open-r/app/conf/udset7.dat
    cp $UPD `ls $GT_DIR/Config/*.cfg | grep -v player |grep -v obotgw` $MSD/open-r/app/conf

    cp -u $GT_DIR/Config/robotgw.cfg $MSD/open-r/mw/conf

    mkdir -p $MSD/open-r/app/conf/Xabsl2
    cp $UPD $GT_DIR/Config/Xabsl2/* $MSD/open-r/app/conf/Xabsl2

    mkdir -p $MSD/open-r/app/conf/Pfield/Bremen
    cp $UPD $GT_DIR/Config/Pfield/Bremen/*.pfc $MSD/open-r/app/conf/Pfield/Bremen

    LOCATION=`grep -v "\*" $GT_DIR/Config/location.cfg | grep "[A-Za-z0-9]"`
    if test x$LOCATION != x; then
      mkdir -p $MSD/open-r/app/conf/$LOCATION
      cp $GT_DIR/Config/$LOCATION/*.* $MSD/open-r/app/conf/$LOCATION
    fi
    cp $UPD $GT_DIR/Config/*.tab $MSD/open-r/app/conf

    if test $NOPLAYER = 0; then
      cp $UPD  $GT_DIR/Config/player.cfg $MSD/open-r/app/conf
      if test -f $GT_DIR/Config/wlanconf.txt; then
        cp $UPD $GT_DIR/Config/wlanconf.txt $MSD/open-r/system/conf
      else
        echo "$GT_DIR/Config/wlanconf.txt not found, create it, e.g. with PlayersToolbar:Save"
      fi
    fi

    echo "! ... done:"

    # give some post-copy info
    #
    if test -f $MSD/open-r/app/conf/player.cfg; then
      echo "player.cfg:"
      sed 's/^/  /' $MSD/open-r/app/conf/player.cfg
    else
      echo "warning: no player.cfg found on stick!"
    fi

    if test -f $MSD/open-r/system/conf/wlanconf.txt; then
      echo "wlanconf.txt:"
      sed 's/^/  /' $MSD/open-r/system/conf/wlanconf.txt
    else
      echo "warning: no wlanconf.txt found on stick!"
    fi

    if test $PAUSE = 1; then
      cmd /C pause
    fi

    if test $EJECT = 1; then
      $GT_DIR/Make/deveject.exe -EjectDrive:$MSD
      sleep 2
      $GT_DIR/Make/deveject.exe -EjectDrive:$MSD
    fi

  else
    echo ERROR: $MSD does not exist. Insert MemoryStick!
    cmd /C pause
  fi
fi

#
# Change Log:
#
# $Log: copyfiles.bash,v $
# Revision 1.60  2004/05/25 13:27:34  schmidtb
# modified version of rip for open-challenge
#
# Revision 1.59  2004/04/21 06:00:38  dueffert
# UD parameterset for ERS7 with calibrated forward speeds
#
# Revision 1.58  2004/04/08 15:32:59  wachter
# GT04 checkin of Microsoft-Hellounds
#
# Revision 1.57  2004/03/26 16:19:58  park
# added host sparky
#
# Revision 1.56  2004/03/25 12:09:36  kindler
# - unsafe option should work now
#   (removed write protection of extobj.cfg)
#
# Revision 1.55  2004/03/23 10:28:04  roefer
# Minor bug fixed
#
# Revision 1.54  2004/03/22 21:55:40  roefer
# New options
#
# Revision 1.53  2004/03/19 21:17:10  altmeyer
# added host deepmo
#
# Revision 1.52  2004/03/16 14:00:15  juengel
# Integrated Improvments from "Gnne"
# -ATH2004ERS7Behavior
# -ATHHeadControl
# -KickSelectionTable
# -KickEditor
#
# Revision 1.51  2004/03/15 23:51:13  kindler
# - TinyFTPd should work again on the ERS-7
#    (object is now loaded as an app instead of mw, new ftppwd.cfg added)
#

