/**
* @file ATHAiboControlDlg.cpp
*
* Implementation of the ATHAiboControl dialogs
*
* @author Martin Ltzsch
*/


#include "stdafx.h"
#include "ATHAiboControl.h"
#include "ATHAiboControlDlg.h"
#include "RobotControl/Visualization/ImageMethods.h"


CATHAiboControlDlg1::CATHAiboControlDlg1(CWnd* pParent /*=NULL*/)
	: CDialog(CATHAiboControlDlg1::IDD, pParent)
{
	//{{AFX_DATA_INIT(CATHAiboControlDlg1)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CATHAiboControlDlg1::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CATHAiboControlDlg1)
	DDX_Control(pDX, IDC_CONFIGURATION_COMBO, m_configurationCombo);
	DDX_Control(pDX, IDC_JOYSTICK_BITMAP2, m_JoystickBitmap2);
	DDX_Control(pDX, IDC_CONNECT_BITMAP2, m_ConnectBitmap2);
	DDX_Control(pDX, IDC_CONNECT_BITMAP, m_ConnectBitmap);
	DDX_Control(pDX, IDC_JOYSTICK_BITMAP, m_JoystickBitmap);
	DDX_Control(pDX, IDC_IPADDRESS, m_IpControl);
	DDX_Control(pDX, IDC_CONNECT_BUTTON, m_ConnectButton);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CATHAiboControlDlg1, CDialog)
	//{{AFX_MSG_MAP(CATHAiboControlDlg1)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_CONNECT_BUTTON, OnConnectButton)
	ON_NOTIFY(IPN_FIELDCHANGED, IDC_IPADDRESS, OnFieldchangedIpaddress)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_CBN_SELCHANGE(IDC_CONFIGURATION_COMBO, OnSelchangeConfigurationCombo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CATHAiboControlDlg1::update()
{
  if (getATHAiboControlApp()->joystickIsConnected)
  {
    m_JoystickBitmap.ShowWindow(SW_HIDE);
    m_JoystickBitmap2.ShowWindow(SW_NORMAL);
  }
  else
  {
    m_JoystickBitmap.ShowWindow(SW_NORMAL);
    m_JoystickBitmap2.ShowWindow(SW_HIDE);
  }

  if (getATHAiboControlApp()->wlanIsConnected)
  {
    m_ConnectBitmap.ShowWindow(SW_HIDE);
    m_ConnectBitmap2.ShowWindow(SW_NORMAL);
    m_IpControl.EnableWindow(false);
    m_ConnectButton.EnableWindow(false);
  }
  else
  {
    m_ConnectBitmap.ShowWindow(SW_NORMAL);
    m_ConnectBitmap2.ShowWindow(SW_HIDE);
    m_IpControl.EnableWindow(true);
    m_ConnectButton.EnableWindow(true);
  }

}

BOOL CATHAiboControlDlg1::OnInitDialog()
{
	CDialog::OnInitDialog();

  SetIcon(m_hIcon, TRUE);			// Groes Symbol verwenden
	SetIcon(m_hIcon, FALSE);		// Kleines Symbol verwenden

  SetTimer(0,50,NULL);
	
  m_IpControl.SetAddress(getATHAiboControlApp()->ip);
  m_configurationCombo.AddString("ERS7 all images");
  m_configurationCombo.AddString("ERS7 some images");
  m_configurationCombo.AddString("ERS210 all images");
  m_configurationCombo.AddString("ERS210 some images");
  
  m_configurationCombo.SetCurSel(getATHAiboControlApp()->configuration);
  update();
  
	return TRUE;  
}

void CATHAiboControlDlg1::OnSysCommand(UINT nID, LPARAM lParam)
{
  CDialog::OnSysCommand(nID, lParam);
}


void CATHAiboControlDlg1::OnPaint() 
{
  CDialog::OnPaint();
}

void CATHAiboControlDlg1::OnConnectButton() 
{
  getATHAiboControlApp()->wlanThread.wlanConnect(getATHAiboControlApp()->ip,0xA1BD);
}

void CATHAiboControlDlg1::OnFieldchangedIpaddress(NMHDR* pNMHDR, LRESULT* pResult) 
{
  m_IpControl.GetAddress(getATHAiboControlApp()->ip);
	
	*pResult = 0;
}

void CATHAiboControlDlg1::OnTimer(UINT nIDEvent) 
{
 	getATHAiboControlApp()->OnIdle();
	
	CDialog::OnTimer(nIDEvent);
}


void CATHAiboControlDlg1::OnDestroy() 
{
  KillTimer(0);

	CDialog::OnDestroy();
	
}




CATHAiboControlDlg2::CATHAiboControlDlg2(CWnd* pParent /*=NULL*/)
	: CDialog(CATHAiboControlDlg2::IDD, pParent)
{
	//{{AFX_DATA_INIT(CATHAiboControlDlg2)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CATHAiboControlDlg2::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CATHAiboControlDlg2)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CATHAiboControlDlg2, CDialog)
	//{{AFX_MSG_MAP(CATHAiboControlDlg2)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_TIMER()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CATHAiboControlDlg2::update()
{
  RedrawWindow(NULL, NULL, RDW_INVALIDATE);
}

BOOL CATHAiboControlDlg2::OnInitDialog()
{
	CDialog::OnInitDialog();

  SetIcon(m_hIcon, TRUE);			// Groes Symbol verwenden
	SetIcon(m_hIcon, FALSE);		// Kleines Symbol verwenden

  SetTimer(0,50,NULL);
	
  update();
  
	return TRUE;  // Geben Sie TRUE zurck, auer ein Steuerelement soll den Fokus erhalten
}

void CATHAiboControlDlg2::OnSysCommand(UINT nID, LPARAM lParam)
{
  CDialog::OnSysCommand(nID, lParam);
}


void CATHAiboControlDlg2::OnPaint() 
{
  CPaintDC dc(this); // device context for painting

  ImageMethods::paintImage2CDCAsYUV(
    dc, getATHAiboControlApp()->image,
    CRect(416, 0, 
    416 + 416, // 416 = 2 * 208
     320) ); // 320 = 2 * 160

  CDialog::OnPaint();
}

void CATHAiboControlDlg2::OnTimer(UINT nIDEvent) 
{
  KillTimer(0);
	CDialog::OnTimer(nIDEvent);
 	getATHAiboControlApp()->OnIdle();
	SetTimer(0,200,NULL);
}

void CATHAiboControlDlg2::OnDestroy() 
{
	CDialog::OnDestroy();
}


void CATHAiboControlDlg1::OnSelchangeConfigurationCombo() 
{
  getATHAiboControlApp()->configuration = 
    (CATHAiboControlApp::Configuration)m_configurationCombo.GetCurSel();
  getATHAiboControlApp()->onChangeConfiguration();
}

/** 
* Change Log:
*
* $Log: ATHAiboControlDlg.cpp,v $
* Revision 1.3  2004/01/26 13:35:02  loetzsch
* improved
*
* Revision 1.2  2004/01/24 20:18:40  loetzsch
* improved ATH AiboControl
*
* Revision 1.1  2004/01/24 14:55:28  loetzsch
* created ATH AiboControl
*
*/


