/**
* @file MakeStickDialog.h
* The dialog for the MakeStick tool. Includes all program code.
*
* @author Tim Riemenschneider
* @author Thomas Roefer
* @author Tim Laue
*/

#if !defined(AFX_MAKESTICKDLG_H__A020D7C7_06AB_45C9_A280_2CD789C8FC75__INCLUDED_)
#define AFX_MAKESTICKDLG_H__A020D7C7_06AB_45C9_A280_2CD789C8FC75__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


/** The possible configurations to be written on a stick*/
enum ConfigType {
    GERMAN_TEAM_2003_CONFIGURE,
    GERMAN_TEAM_2004_CONFIGURE,
    GERMAN_TEAM_COPY_ERS210,
    GERMAN_TEAM_COPY_ERS7,
    GERMAN_TEAM_2003_ZIP,
    GERMAN_TEAM_2004_ZIP,
    CMU,
    CMU_ZIP,
    NumberOfConfigTypes
};


/**
* @class CMakeStickDlg
* The main class of the dialog
*/
class CMakeStickDlg : public CDialog
{
public:
  /** Standard-Constructor*/
  CMakeStickDlg(CWnd* pParent = NULL);

  /** Destructor*/
	~CMakeStickDlg();

protected:
  /** The icon*/
	HICON m_hIcon;
  /** The current configuration*/
  ConfigType m_configType;

  /** Write CMU stick*/
	bool WriteConfigCMU();

  /** Write GermanTeam stick*/
	bool WriteConfigGT();

  /** Unzip data to a stick*/
  bool UnzipStick();
  
  /** Dialog data*/
	//{{AFX_DATA(CMakeStickDlg)
	enum { IDD = IDD_MAKESTICK_DIALOG };
	CComboBox	m_configtype;
	int		m_role;
	int		m_color;
	int		m_ip1;
	int		m_ip2;
	int		m_ip3;
	int		m_ip4;
  CString	m_name;
	CString	m_netmask;
	CString	m_essid;
	int		m_ip4base;
	CString	m_stickdrive;
	BOOL	m_sndhalf;
	CString	m_wepkey;
	short	m_apmode;
	short	m_channel;
	int	m_force;
	BOOL	m_close;
  CString	m_teamName;
	CComboBox	m_location;
  CString m_sLocation;
  CString m_zipFileName;
	BOOL	m_console;
	BOOL	m_unsafe;
	//}}AFX_DATA
  
  /** Generated virtual functions */
	//{{AFX_VIRTUAL(CMakeStickDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV-Untersttzung
	//}}AFX_VIRTUAL
  
  /** Generated Message-Map-Functions*/
	//{{AFX_MSG(CMakeStickDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnWriteStick();
	afx_msg void OnBrowse();
	afx_msg void OnError();
	afx_msg void OnRoleChange();
	afx_msg void OnSelchangeConfigtype();
  afx_msg void OnLoadButton();
	//}}AFX_MSG

  DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ adds additional declarations here

#endif // !defined(AFX_MAKESTICKDLG_H__A020D7C7_06AB_45C9_A280_2CD789C8FC75__INCLUDED_)


/*
 * Changelog:
 *
 * $Log: MakeStickDlg.h,v $
 * Revision 1.6  2004/03/22 21:55:41  roefer
 * New options
 *
 * Revision 1.5  2004/02/20 13:59:15  tim
 * Compatibility for GT2003 roles
 *
 * Revision 1.4  2004/02/19 17:16:14  tim
 * Added support for zipped sticks (GT as well as CMU)
 *
 * Revision 1.3  2004/01/30 20:56:04  roefer
 * Added writing of location.cfg
 *
 * Revision 1.2  2004/01/27 10:23:20  roefer
 * Support for team name
 *
 * Revision 1.1  2004/01/17 14:13:12  roefer
 * MakeStick inserted into project
 *
 * Revision 1.3  2003/06/10 10:58:12  timrie
 * added ConfigType (GT, GT-copyfiles, CMU)
 * added support for CMU-config files
 * added WEP-Settings
 * added AP-Mode + Channel
 *
 * Revision 1.2  2003/06/02 09:54:41  timrie
 * added letter of memorystick-drive
 *
 * Revision 1.1  2003/05/30 13:10:20  timrie
 * new file
 *
 */
