/**
 * @file ATH2004BallLocator.h
 * 
 * This file contains default class for ball-localization.
 *
 * @author <a href="mailto:goehring@informatik.hu-berlin.de">Daniel Goehring</a>
 * @author <a href="mailto:jhoffman@informatik.hu-berlin.de">Jan Hoffmann</a>
 */

#ifndef __ATH2004BallLocator_h_
#define __ATH2004BallLocator_h_

#include "BallLocator.h"
#include "Tools/Debugging/GenericDebugData.h"
#include "Tools/Math/Common.h"
#include "Tools/Math/Matrix2x2.h"


/**
* @class SingleBallHypothesis
*
* Used in the ball locator.
*/
class SingleBallHypothesis
{
public:
  /** 
  * Constructor.
  */
  SingleBallHypothesis();
	

  void set(double distance, double angle, double speed, double direction);
  void reset();
  void propagatePosition();
  void setDistance(double distance);
  void setAngle(double angle);
  void setSpeed(double speed);
  void setDirection(double direction);
  void compensateOdometry(Pose2D odometry);

  double getDistance();
  double getAngle();
  double getSpeed();
  double getDirection();
	
  int getID() {return id;}
  int getDOB() {return dob;}

private:
  double distance, angle, speed, direction, evaluation, accumulation;
  double MUTATE, g_Roll, t_Call;
  int id, dob;
};


/**
* @class BallHypothesis
*
* Used in the ball locator.
*/

class BallHypothesis
{
public:
  BallHypothesis();

  enum {maxNumOfHypos = 100};
  
  SingleBallHypothesis hypos[maxNumOfHypos] ;

  void reset();
  void compensateOdometry(Pose2D odometry);
  void propagatePosition();
};


/**
* @class ATH2004BallLocator
*
* A solution of the BallLocator module.
*
* @author <a href="mailto:goehring@informatik.hu-berlin.de">Daniel Goehring</a>
*/
class ATH2004BallLocator : public BallLocator
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the BallLocator module.
  */
  ATH2004BallLocator(const BallLocatorInterfaces& interfaces);

  /** Executes the module */
  virtual void execute();

private:
  
  int numOfHypos;
  Vector2<double> lastBallSeen;
  Pose2D lastBallPercept,
         lastRobotOdometry; 
  long consecutiveFramesBallSeen;
  long consecutiveFramesBallNotSeen;
  unsigned long lastTimeBallSeen;

  void compensateOdometry();
  bool handleMessage(InMessage& message);
  //KALMAN BEGINS

   
  
//   double sx, sx_, px, px_, qx, kx, rx, zx;
//   double sy, sy_, py, py_, qy, ky, ry, zy;

   double oldSeenPosX, oldSeenPosY;
   double oldModPosX, oldModPosY;
   double oldModSpeedX, oldModSpeedY;
  
   Vector2<double>    Sx, Sx_, Zx, Sy, Sy_, Zy;
   Matrix2x2<double>  Px, Px_, Qx, Kx, Rx, Py, Py_, Qy, Ky, Ry, I;
  
    

  //KALMAN ENDS
};


#endif// __ATH2004BallLocator_h_

/*
 * Change log :
 * $Log: ATH2004BallLocator.h,v $
 * Revision 1.26  2004/05/18 21:18:00  goehring
 * Kalman component improved
 *
 * Revision 1.25  2004/05/17 21:14:57  goehring
 * ATH-Kalman implementation
 *
 * Revision 1.24  2004/04/21 20:11:40  goehring
 * BallLocators added
 *
 * Revision 1.14  2003/12/28 17:52:33  goehring
 * BallStates added, BallPositionPropagation by speed implemented
 *
 * Revision 1.13  2003/12/28 13:54:36  goehring
 * Particle Propagation and Mutation implemented
 *
 * Revision 1.12  2003/12/28 12:22:10  goehring
 * Probability Accumulation added
 *
 * Revision 1.11  2003/12/28 11:44:56  goehring
 * Evaluation and Normalization beta added
 *
 * Revision 1.10  2003/12/20 14:50:11  goehring
 * BallHypotheses odometry compensated, set-Value methods implemented
 *
 * Revision 1.9  2003/12/19 11:04:48  goehring
 * Hypothesis particles randomly generated and displayed on field -
 * not yet transformed relatively to the robot's position.
 *
 * Revision 1.8  2003/12/17 15:35:06  goehring
 * Ballhypothesis
 *
 * Revision 1.7  2003/12/16 16:55:05  goehring
 * Ballhypthesis moved to ATH2004BallLocator
 *
 * Revision 1.6  2003/12/15 17:27:46  goehring
 * Ballhypotheses extended
 *
 * Revision 1.5  2003/12/09 16:33:54  jhoffman
 * added class ballhypothesis
 *
 * Revision 1.4  2003/12/04 13:28:40  goehring
 * Concept change
 *
 * Revision 1.1  2003/12/02 13:51:01  goehring
 * no message
 *
 * 
 *
 */
