/**
 * @file DDD2004BallLocator.h
 * 
 * This file contains default class for ball-localization.
 *
 * @author <a href="mailto:brunn@sim.tu-darmstadt.de">Ronnie Brunn</a>
 * @author <a href="mailto:mkunz@sim.tu-darmstadt.de">Michael Kunz</a>
 */

#ifndef __DDD2004BallLocator_h_
#define __DDD2004BallLocator_h_

#include "BallLocator.h"
#include "Tools/Debugging/GenericDebugData.h"
#include "Tools/Math/PIDsmoothedValue.h"
#include "BallSideDetector.h"

/**
* @class DDD2004BallLocator
*
* A solution of the BallLocator module.
*
*
* @author <a href="mailto:brunn@sim.tu-darmstadt.de">Ronnie Brunn</a>
* @author <a href="mailto:mkunz@sim.tu-darmstadt.de">Michael Kunz</a>
*/
class DDD2004BallLocator : public BallLocator
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the BallLocator module.
  */
  DDD2004BallLocator(const BallLocatorInterfaces& interfaces);

  /** Executes the module */
  virtual void execute();

private:
  

    PIDsmoothedValue ballPosX, ballPosY, ballSpeedX, ballSpeedY;
		PIDsmoothedValue ballAngle, ballDistance; 
    Vector2<double> lastBallSeen;
    Pose2D lastBallPercept,
           lastRobotOdometry; 
    long consecutiveFramesBallSeen;
    long consecutiveFramesBallNotSeen;
    unsigned long lastTimeBallSeen;

    Vector2<double> relative2FieldCoord(RobotPose rp, double x, double y);
    void compensateOdometry();

    bool handleMessage(InMessage& message);

     /** used for detecting whether the ball is fast and close */
    BallSideDetector ballSideDetector;
  
};

#endif// __DDD2004BallLocator_h_

/*
 * Change log :
 * $Log: DDD2004BallLocator.h,v $
 * Revision 1.1  2004/04/07 12:28:56  risler
 * ddd checkin after go04 - first part
 *
 * Revision 1.2  2004/03/30 14:21:30  Papa Schlumpf
 * only use size-based offsets, angles and distances
 *
 * Revision 1.1  2004/03/30 14:00:34  Papa Schlumpf
 * added DDD2004BallLocator
 *
 *
 */
