/**
 * @file MSH2004BallLocatorElement.h
 * 
 * This file contains a container  class for ball-localization.
 *
 * @author <a href="mailto:grypho@tempus-vivit.net">Carsten Schumann</a>
 */

#ifndef __MSH2004BallLocatorElement_h_
#define __MSH2004BallLocatorElement_h_

#include "BallLocator.h"
#include "Tools/Math/Matrix2x2.h"


class MSH2004BallLocatorElement
{
public:
  MSH2004BallLocatorElement(const BallPercept& ballPercept, const RobotPose& robotPose, const OdometryData& odometryPose, const long currentFrame);
  Vector2<double> getBallpositionOnField();
  Pose2D getCorrectedPose();
  Pose2D getPose();
  OdometryData getOdometry();
  void clearTempData();
  double getRotationShiftoff();
  Vector2<double> getBallMovement();
  Vector2<double> getBallMovementPerMS();
  bool entryRecent(int currentFrame);
  bool movementInvertedTo(MSH2004BallLocatorElement* other);
  double getMovementValidity();
  void setMovementValidity(double value);

  long getAge(int currentFrame); //currentFrame is used for the simulator to determine age of entry
  void recalculatePose(MSH2004BallLocatorElement* futuralElement, Matrix2x2<double>& shiftoffMatrix);
  void recalculateBallOnField();
  void recalculateBallMovement(MSH2004BallLocatorElement* futuralElement, int currentFrame);

  RobotPose pose;
  RobotPose correctedPose;
  BallPercept ballPercept;
  Vector2<double> ballOnField;
  Vector2<double> ballMovement;
  Vector2<double> ballMovementPerMS;
  long systemTime;
  long systemFrame;
  bool jumpDetected;
  OdometryData odometry;
  long maxAgeMS;
  double movementValidity;



};




#endif


/*
 * Change log : 
 * $Log: MSH2004BallLocatorElement.h,v $
 * Revision 1.2  2004/01/22 20:08:00  schumann
 * added validity for movement
 * added elemination of jumping ball
 * improved calculation of ball movement
 *
 * Revision 1.1  2004/01/21 11:48:52  schumann
 * Added motion extrapolation and cleaned up balllocator
 *
*/
