/**
* @file PerceptBallLocator.cpp
* 
* This file contains the default class for ball-localization.
*
* @author <a href="mailto:goehring@informatik.hu-berlin.de">Daniel Goehring</a>
*/


//NORMALIZE CHANGES BY Frame!!!

#include "PerceptBallLocator.h"
#include "Tools/Debugging/Debugging.h"

#include "Tools/FieldDimensions.h"
#include "Platform/SystemCall.h"
#include "Tools/Debugging/DebugDrawings.h"
#include <math.h>
#include "Tools/Math/Matrix2x2.h"
#include "Platform/GTAssert.h"



PerceptBallLocator::PerceptBallLocator(const BallLocatorInterfaces& interfaces)
: BallLocator(interfaces)
{
  lastTimeBallSeen = 0;
  lastFrameNumber = 0;
  frameNumber = 0;
}

void PerceptBallLocator::execute()
{
  double timeDiff = (double )(timeOfImageProcessing - lastTimeBallSeen)/1000; // 1/msec -> 1/sec
  lastTimeBallSeen = timeOfImageProcessing;

  if(!ballPercept.ballWasSeen)
  {
    consecutiveFramesBallSeen = 0;
    consecutiveFramesBallNotSeen++;
  }
  else // ball was seen
  {
    // if there is a gap of n frames during which the ball was not seen
    // reset the "timeWhenLastSeenConsecutively"
    if (consecutiveFramesBallNotSeen > 5)
    {
      ballPosition.seen.timeWhenFirstSeenConsecutively = timeOfImageProcessing;
    }
    
    // if ball has not been seen for a while but 
    // is seen now, directly (re-)set to percept...
    if (consecutiveFramesBallNotSeen > 10) 
    {
    }
    // ball was seen recently
    else  
    {
       // calc ball speed:
      if ((consecutiveFramesBallSeen > 1) && (timeDiff > 0))
      {
      }
    }

    Vector2<double> ballOffset;
    ballPercept.getOffset(ballOffset);
    consecutiveFramesBallSeen++;
    consecutiveFramesBallNotSeen = 0;
    frameNumber = ballPercept.frameNumber;


    ballPosition.seen.timeWhenLastSeen = timeOfImageProcessing;

    ballPosition.seen = 
        Geometry::relative2FieldCoord(robotPose, ballOffset.x, ballOffset.y); 
      
        ballPosition.propagated.x  = ballPosition.seen.x;
        ballPosition.propagated.y  = ballPosition.seen.y;

        if (consecutiveFramesBallSeen >= 2)
        {
          ballPosition.seen.speed.x = (ballPosition.seen.x - lastBallSeen.x)/(frameNumber - lastFrameNumber)*125;
          ballPosition.seen.speed.y = (ballPosition.seen.y - lastBallSeen.y)/(frameNumber - lastFrameNumber)*125;
        }
        else
        {
          ballPosition.seen.speed.x = 0;
          ballPosition.seen.speed.y = 0;        
        }


    lastBallSeen.x = ballPosition.seen.x;
    lastBallSeen.y = ballPosition.seen.y;

    lastFrameNumber = frameNumber;
    
    if (SystemCall::getTimeSince(ballPosition.seen.timeWhenFirstSeenConsecutively) > 350)
    {
      ballPosition.seen.timeUntilSeenConsecutively = timeOfImageProcessing; 
    }
  }
}

bool PerceptBallLocator::handleMessage(InMessage& message)
{

  
  return false;
}






	

/*
* Change log :
* 
* $Log: PerceptBallLocator.cpp,v $
* Revision 1.10  2004/05/22 16:28:45  goehring
* no message
*
* Revision 1.9  2004/03/08 00:58:37  roefer
* Interfaces should be const
*
* Revision 1.8  2004/02/06 18:45:39  goehring
* Concept Change
*
* Revision 1.4  2004/01/20 16:45:52  loetzsch
* The BallLocator has access to the complete BallPosition again
*
* Revision 1.3  2003/12/31 23:50:35  roefer
* Removed inclusion of RobotDimensions.h because it is not used
*
* Revision 1.2  2003/12/02 15:12:16  goehring
* BallPosition algorithm added
*
* Revision 1.1  2003/12/02 13:51:01  goehring
* no message
*
*
*/
