/**
 * @file VoteBasedBallLocator.h
 * 
 * This file contains default class for ball-localization.
 *
 * @author <a href="mailto:jhoffman@informatik.hu-berlin.de">Jan Hoffmann</a>
 */

#ifndef __VoteBasedBallLocator_h_
#define __VoteBasedBallLocator_h_

#include "BallLocator.h"
#include "Tools/Debugging/GenericDebugData.h"
#include "Tools/RingBuffer.h"
#include "Tools/Math/PIDsmoothedValue.h"

/**
* @class VoteBasedBallLocator
*
* A solution of the BallLocator module.
*
*
 * @author <a href="mailto:jhoffman@informatik.hu-berlin.de">Jan Hoffmann</a>
*/
class VoteBasedBallLocator : public BallLocator
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the BallLocator module.
  */
  VoteBasedBallLocator(const BallLocatorInterfaces& interfaces);
	double vote(Vector2<double> hypothesis, double angleMeasurement, double distMeasurement);

  /** Executes the module */
  virtual void execute();

private:
  
		RingBuffer<Vector2<double>, 10> measurements;
		RingBuffer<double, 10> angleMeasurements;
		RingBuffer<double, 10> distMeasurements;
		RingBuffer<double, 10> timeStamps;
		//int lastMeasurement;

    //Vector2<double> lastBallSeen;
    Pose2D lastBallPercept,
           lastRobotOdometry; 
    long consecutiveFramesBallSeen;
    long consecutiveFramesBallNotSeen;
    unsigned long lastTimeBallSeen;

    void compensateOdometry();
    bool handleMessage(InMessage& message);
};

#endif// __VoteBasedBallLocator_h_

/*
 * Change log :
 * $Log: VoteBasedBallLocator.h,v $
 * Revision 1.3  2004/03/08 00:58:37  roefer
 * Interfaces should be const
 *
 * Revision 1.2  2003/12/09 16:33:10  jhoffman
 * - some cleaning up
 *
 * Revision 1.1  2003/10/22 10:22:57  goehring
 * VoteBasedBallLocator
 *
 */
