/** 
* @file ATH2004ContinuousBasicBehaviors.h
*
* Declaration of basic behaviors defined in continuous-basic-behaviors.xml.
*
* @author Martin Kallnik
* @author Max Risler
*/

#ifndef __ATH2004ContinuousBasicBehaviors_h_
#define __ATH2004ContinuousBasicBehaviors_h_

#include "Tools/ContinuousBasicBehaviors/ContinuousBasicBehavior.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"
#include "../ATH2004BehaviorConfiguration.h"

/**
* @class ContinuousBasicBehaviors
*
* Creates and registers simple basic behaviors
*/
class ATH2004ContinuousBasicBehaviors : public BehaviorControlInterfaces
{
public:
  /**
  * Constructor
  */
  ATH2004ContinuousBasicBehaviors(
                       const BehaviorControlInterfaces& interfaces,
                       ATH2004BehaviorConfiguration& configuration,
                       Xabsl2ErrorHandler& errorHandler);

  /** Registers basic behaviors at the engine */
  void registerBasicBehaviors(Xabsl2Engine& engine);


  /** updates some variables */
  void update();

  //!@name Basic Behaviors parameters
  //!@{
  double goToPointX;
  double goToPointY;
  double goToPointAngle;
  double goToPointMaxSpeed;

  double goForwardToPointX;
  double goForwardToPointY;
  double goForwardToPointMaxSpeed;

  double goForwardToPointTurningX;
  double goForwardToPointTurningY;
  double goForwardToPointTurningMaxSpeed;
  double goForwardToPointTurningObstacleInfluenceLength;

  double dribbleX;
  double dribbleY;

  double turnWithBallAngle;
  double turnWithBallMaxRotationSpeed;
  double turnWithBallRotationCenter;
  double turnWithBallSpeedY;

  double walkAvoidingObstaclesType;
  double walkAvoidingObstaclesX;
  double walkAvoidingObstaclesY;
  double walkAvoidingObstaclesRot;

  double walkAroundAvoidingObstaclesX;
  double walkAroundAvoidingObstaclesY;

  double turnToBallMaxRotationSpeed;

  double turnRotationSpeed;

  double goalieClearMaxSpeed;
  double goalieGuardMaxSpeed;

  double goaliePositionX;
  double goaliePositionY;
  double goaliePositionMaxSpeed;
  double goaliePositionAngle;

  double supporterPositionX;
  double supporterPositionY;
  double supporterPositionMaxSpeed;
  //!@}

  /** known ball position used for some basic behaviors */
  Vector2<double> knownBallPos;

  /** known ball position in robot relative coordinates 
   * this is needed for basic behaviors that work with selflocator samples
   * as relative position has to be reconstructed first. */
  Vector2<double> knownBallPosRobotRelative;

private:
  /** Is invoked when errors occurs */
  Xabsl2ErrorHandler& errorHandler;

  /**
  * contains the current configuration parameters 
  */
  ATH2004BehaviorConfiguration& configuration;

  //!@name Basic Behaviors
  //!@{
  ContinuousBasicBehavior goToPoint;
  ContinuousBasicBehavior goForwardToPoint;
  ContinuousBasicBehavior goForwardToPointTurning;
  ContinuousBasicBehavior goToBall;
  ContinuousBasicBehavior dribble;
  ContinuousBasicBehavior turnWithBall;
  ContinuousBasicBehavior walkAvoidingObstacles;
  ContinuousBasicBehavior walkAroundAvoidingObstacles;
  ContinuousBasicBehavior turnToBall;
  ContinuousBasicBehavior turn;
  ContinuousBasicBehavior goalieClear;
  ContinuousBasicBehavior goalieGuard;
  ContinuousBasicBehavior goaliePosition;
  ContinuousBasicBehavior goalieReturn;
  ContinuousBasicBehavior supporterPosition;
  //!@}

};


#endif // __ATH2004ContinuousBasicBehaviors_h_

/*
* Change Log
* 
* $Log: ATH2004ContinuousBasicBehaviors.h,v $
* Revision 1.2  2004/03/08 00:58:38  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/26 22:49:34  loetzsch
* created ATH2004BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
*
*/

