/**
* @file ATH2004BehaviorControl.h
* 
* Implementation of class ATH2004BehaviorControl.
*
* @author Martin Ltzsch
*/

#ifndef __ATH2004BehaviorControl_h_
#define __ATH2004BehaviorControl_h_

#include "ATH2004BasicBehaviors/ATH2004SimpleBasicBehaviors.h"
#include "ATH2004BasicBehaviors/ATH2004ContinuousBasicBehaviors.h"
#include "../CommonXabsl2BasicBehaviors/CommonBasicBehaviors.h"

#include "../CommonXabsl2Symbols/BallSymbols.h"
#include "../CommonXabsl2Symbols/HeadAndTailSymbols.h"
#include "../CommonXabsl2Symbols/JoystickSymbols.h"
#include "../CommonXabsl2Symbols/LEDAndSoundSymbols.h"
#include "../CommonXabsl2Symbols/MathFunctions.h"
#include "../CommonXabsl2Symbols/MotionRequestSymbols.h"
#include "../CommonXabsl2Symbols/RoboCupGameManagerSymbols.h"
#include "../CommonXabsl2Symbols/RobotPoseSymbols.h"
#include "../CommonXabsl2Symbols/RobotStateSymbols.h"
#include "../CommonXabsl2Symbols/SpecialVisionSymbols.h"
#include "../CommonXabsl2Symbols/ChallengeSymbols.h"
#include "ATH2004Symbols/ATH2004StrategySymbols.h"
#include "ATH2004Symbols/ATH2004ConfigurationSymbols.h"

#include "../Xabsl2BehaviorControl.h"

#include "ATH2004BehaviorConfiguration.h"

/**
* @class ATH2004BehaviorControl
*
* A Behavior based on the Xabsl2Engine that is used by Aibo Team Humboldt
* for the RoboCup German Open 2004.
*
* @author Martin Ltzsch
*/ 
class ATH2004BehaviorControl : public Xabsl2BehaviorControl
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  ATH2004BehaviorControl(const BehaviorControlInterfaces& interfaces);

  /** destructor */
  ~ATH2004BehaviorControl();

  /** Registers symbols and basic behaviors at the engine */
  virtual void registerSymbolsAndBasicBehaviors();
  
  /** Executes the module */
  virtual void execute();

  /** 
  * Is called for every incoming debug message.
  * @param message An interface to read the message from the queue
  * @return if the messag was read
  */
  virtual bool handleMessage(InMessage& message);

  /**
  * contains the current configuration parameters 
  */
  ATH2004BehaviorConfiguration configuration;

private:
  //!@name Symbols
  //!@{
  BallSymbols ballSymbols;
  ATH2004ConfigurationSymbols configurationSymbols;
  HeadAndTailSymbols headAndTailSymbols;
  JoystickSymbols joystickSymbols;
  LEDAndSoundSymbols ledAndSoundSymbols;
  MathFunctions mathFunctions;
  MotionRequestSymbols motionRequestSymbols;
  RoboCupGameManagerSymbols roboCupGameManagerSymbols;
  RobotPoseSymbols robotPoseSymbols;
  RobotStateSymbols robotStateSymbols;
  SpecialVisionSymbols specialVisionSymbols;
  ATH2004StrategySymbols strategySymbols;
  ChallengeSymbols challengeSymbols;
  //!@}

  //!@name Basic Behaviors
  //!@{
  ATH2004SimpleBasicBehaviors simpleBasicBehaviors;
  ATH2004ContinuousBasicBehaviors continuousBasicBehaviors;
  CommonBasicBehaviors commonBasicBehaviors;
  //!@}


  SoundRequest::SoundID lastSound;
};

#endif// __ATH2004BehaviorControl_h_

/*
 * Change log :
 * 
 * $Log: ATH2004BehaviorControl.h,v $
 * Revision 1.4  2004/03/16 14:00:17  juengel
 * Integrated Improvments from "Gnne"
 * -ATH2004ERS7Behavior
 * -ATHHeadControl
 * -KickSelectionTable
 * -KickEditor
 *
 * Revision 1.3  2004/03/08 00:58:43  roefer
 * Interfaces should be const
 *
 * Revision 1.2  2004/03/11 11:45:16  loetzsch
 * removed shoot logger from ATH2004BehaviorControl
 *
 *
 * Revision 1.2  2004/01/28 21:16:56  loetzsch
 * added ATH2004ShootLogger
 *
 * Revision 1.1  2003/10/26 22:49:34  loetzsch
 * created ATH2004BehaviorControl from GT2003BehaviorControl
 *  - strongly simplified option graph
 *  - moved some symbols from GT2003 to CommonXabsl2Symbols
 *  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
 *
 * cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
 *
 */
