/**
* @file ATH2004ERS7ContinuousRules/TurnToAngle.h
*
* @author Max Risler
*/

#ifndef __ATH2004ERS7TurnToAngle_h_
#define __ATH2004ERS7TurnToAngle_h_

#include "Tools/ContinuousBasicBehaviors/ContinuousRule.h"

namespace ATH2004ERS7ContinuousRules
{

/**@class TurnToAngle
 */
class TurnToAngle: public ContinuousRule{
private:
  /** reference to the angle to turn to */
  const double &angle;
  /** the angle is relative */
  bool relative;

public:

  /** constructor
   */
  TurnToAngle(
    BehaviorControlInterfaces& interfaces,
    const double &angle,
    bool relative = false)
    :
    ContinuousRule(interfaces,"TurnToAngle"),
    angle(angle),
    relative(relative)
  {};

  /**
   * Returns whether this rule generates absolute or robot relative coordinates.
   */
  virtual bool isRelative() {return relative;}

 	/** executes the basic behavior rule
   * @param robotPose the current robots pose at which the rule is to be evaluated
   * @param walk the direction and speed of the suggested motion coded as an vector (output)
	 * @param ra the rotation angle, the direction the robot should be directed (output)
	 * @param rweight the rotation weight the weight of the suggested rotation (output)
	 */
  virtual void execute(const RobotPose& robotPose,
                       Vector2<double>& walk,
                       double& ra, double& rweight)
  {

    walk.x = walk.y = 0;

    ra = fromDegrees(angle);
    rweight=1.0;
  }
};

}


#endif //__ATH2004ERS7TurnToAngle_h_


/*
* Change log:
*
* $Log: TurnToAngle.h,v $
* Revision 1.1  2004/03/16 14:00:18  juengel
* Integrated Improvments from "Gnne"
* -ATH2004ERS7Behavior
* -ATHHeadControl
* -KickSelectionTable
* -KickEditor
*
* Revision 1.1  2004/03/06 12:52:12  loetzsch
* cloned ATH2004BehaviorControl into ATH2004ERS7BehaviorControl
*
* Revision 1.1.1.1  2004/03/05 10:10:11  loetzsch
* created local cvs for Gnne
*
* Revision 1.2  2003/10/31 08:32:48  dueffert
* doxygen bugs fixed
*
* Revision 1.1  2003/10/26 22:49:35  loetzsch
* created ATH2004ERS7BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004ERS7 three times (BB2004, DDD2004, MSH2004)
*
*/
