/**
* @file ATH2004ERS7BehaviorControl.h
* 
* Implementation of class ATH2004ERS7BehaviorControl.
*
* @author Martin Ltzsch
*/

#ifndef __ATH2004ERS7BehaviorControl_h_
#define __ATH2004ERS7BehaviorControl_h_

#include "ATH2004ERS7BasicBehaviors/ATH2004ERS7SimpleBasicBehaviors.h"
#include "ATH2004ERS7BasicBehaviors/ATH2004ERS7ContinuousBasicBehaviors.h"
#include "../CommonXabsl2BasicBehaviors/CommonBasicBehaviors.h"

#include "../CommonXabsl2Symbols/CalibrationSymbols.h"
#include "../CommonXabsl2Symbols/BallSymbols.h"
#include "../CommonXabsl2Symbols/HeadAndTailSymbols.h"
#include "../CommonXabsl2Symbols/JoystickSymbols.h"
#include "../CommonXabsl2Symbols/LEDAndSoundSymbols.h"
#include "../CommonXabsl2Symbols/MathFunctions.h"
#include "../CommonXabsl2Symbols/MotionRequestSymbols.h"
#include "../CommonXabsl2Symbols/RoboCupGameManagerSymbols.h"
#include "../CommonXabsl2Symbols/RobotPoseSymbols.h"
#include "../CommonXabsl2Symbols/RobotStateSymbols.h"
#include "../CommonXabsl2Symbols/SpecialVisionSymbols.h"
#include "../CommonXabsl2Symbols/ChallengeSymbols.h"
#include "ATH2004ERS7Symbols/ATH2004ERS7StrategySymbols.h"
#include "ATH2004ERS7Symbols/ATH2004ERS7ConfigurationSymbols.h"
#include "ATH2004ERS7Symbols/ATH2004ERS7KickSelectionSymbols.h"

#include "../Xabsl2BehaviorControl.h"

#include "ATH2004ERS7ShootLogger.h"
#include "ATH2004ERS7Xabsl2Profiler.h"
/**
* @class ATH2004ERS7BehaviorControl
*
* A Behavior based on the Xabsl2Engine that is used by Aibo Team Humboldt
* for the RoboCup German Open 2004.
*
* @author Martin Ltzsch
*/ 
class ATH2004ERS7BehaviorControl : public Xabsl2BehaviorControl
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  ATH2004ERS7BehaviorControl(BehaviorControlInterfaces& interfaces);

  /** destructor */
  ~ATH2004ERS7BehaviorControl();

  /** Registers symbols and basic behaviors at the engine */
  virtual void registerSymbolsAndBasicBehaviors();
  
  /** Executes the module */
  virtual void execute();

  /** 
  * Is called for every incoming debug message.
  * @param message An interface to read the message from the queue
  * @return if the messag was read
  */
  virtual bool handleMessage(InMessage& message);

private:
  //!@name Symbols
  //!@{
  CalibrationSymbols calibrationSymbols;
  BallSymbols ballSymbols;
  ATH2004ERS7ConfigurationSymbols configurationSymbols;
  HeadAndTailSymbols headAndTailSymbols;
  JoystickSymbols joystickSymbols;
  LEDAndSoundSymbols ledAndSoundSymbols;
  MathFunctions mathFunctions;
  MotionRequestSymbols motionRequestSymbols;
  RoboCupGameManagerSymbols roboCupGameManagerSymbols;
  RobotPoseSymbols robotPoseSymbols;
  RobotStateSymbols robotStateSymbols;
  SpecialVisionSymbols specialVisionSymbols;
  ATH2004ERS7StrategySymbols strategySymbols;
  ATH2004ERS7KickSelectionSymbols kickSelectionSymbols;
  ChallengeSymbols challengeSymbols;
  //!@}

  //!@name Basic Behaviors
  //!@{
  ATH2004ERS7SimpleBasicBehaviors simpleBasicBehaviors;
  ATH2004ERS7ContinuousBasicBehaviors continuousBasicBehaviors;
  CommonBasicBehaviors commonBasicBehaviors;
  //!@}


  /*
  * Runs in parallel to the ATH Xabsl engine and logs the preconditions
  * and results of each kick.
  */
  ATH2004ERS7ShootLogger shootLogger;

  /*
   *	Profiler
   */
  ATH2004ERS7Xabsl2Profiler profiler;
};

#endif// __ATH2004ERS7BehaviorControl_h_

/*
 * Change log :
 * 
 * $Log: ATH2004ERS7BehaviorControl.h,v $
 * Revision 1.6  2004/04/13 12:01:42  spranger
 * added rudimentary profiling
 *
 * Revision 1.5  2004/03/26 06:42:25  loetzsch
 * several improvements in the high level options
 *
 * Revision 1.4  2004/03/21 12:42:20  juengel
 * - Moved calibration symbols to common symbols.
 * - face LEDs are initialized with oooo
 * - lilac face LEDs show player role
 *
 * Revision 1.3  2004/03/20 00:20:18  kerdels
 * removed some errors
 *
 * Revision 1.1  2004/03/16 14:00:17  juengel
 * Integrated Improvments from "Gnne"
 * -ATH2004ERS7Behavior
 * -ATHHeadControl
 * -KickSelectionTable
 * -KickEditor
 *
 * Revision 1.2  2004/03/09 13:44:49  loetzsch
 * added class ATH2004ERS7KickSelectionSymbols
 *
 * Revision 1.1  2004/03/06 12:52:11  loetzsch
 * cloned ATH2004BehaviorControl into ATH2004ERS7BehaviorControl
 *
 * Revision 1.1.1.1  2004/03/05 10:10:11  loetzsch
 * created local cvs for Gnne
 *
 * Revision 1.2  2004/01/28 21:16:56  loetzsch
 * added ATH2004ShootLogger
 *
 * Revision 1.1  2003/10/26 22:49:34  loetzsch
 * created ATH2004BehaviorControl from GT2003BehaviorControl
 *  - strongly simplified option graph
 *  - moved some symbols from GT2003 to CommonXabsl2Symbols
 *  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
 *
 * cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
 *
 */
