#include "ATH2004ERS7Xabsl2Profiler.h"

ATH2004ERS7Xabsl2Profiler::ATH2004ERS7Xabsl2Profiler():outfilename("xabsl2.log"), maxdepth(0){}
ATH2004ERS7Xabsl2Profiler::ATH2004ERS7Xabsl2Profiler(char* outf):outfilename(outf), maxdepth(0){}

void ATH2004ERS7Xabsl2Profiler::init(Xabsl2Engine& pEngine,int length){
  OutTextFile out(outfilename.c_str(), false);
  log.clear();
  nameTable.init(length);
  registerEngine(pEngine);
  doDepthCount(pEngine.getRootOption(), 1);
  writeNameTableToStream(out);
}

void ATH2004ERS7Xabsl2Profiler::registerEngine(Xabsl2Engine& pEngine){
  registerOptions(pEngine.getRootOption(), 0);
}

void ATH2004ERS7Xabsl2Profiler::registerOptions(const Xabsl2Option* option, int depth){
  std::vector<std::string> states;
  
  int i;
  for(i = 0; i<option->states.getSize();++i){
    if(!nameTable.exists( option->n, option->states[i]->n))
      states.push_back(option->states.getName(i));
  }

  std::vector<std::string> params;
  for(i = 0; i<option->parameters.getSize();++i){
      params.push_back(option->parameters.getName(i));
  }
  

  nameTable.append(option->n, states, params, depth);

  for(int j=0; j<option->states.getSize();++j){
    if(option->states[j]->subsequentOption && !nameTable.existsOption(option->states[j]->subsequentOption->n)){
      registerOptions(option->states[j]->subsequentOption, depth+1);
    }
  }
}
void ATH2004ERS7Xabsl2Profiler::doDepthCount(const Xabsl2Option* option, int depth){
  if(depth > maxdepth)
    maxdepth = depth;
  for(int i=0; i< option->states.getSize();++i){
    if( nameTable[nameTable.getOptionPosition(option->n)].maxdepth < depth)
      nameTable[nameTable.getOptionPosition(option->n)].maxdepth = depth;
  }
  for(int j=0; j<option->states.getSize();++j){
    if(option->states[j]->subsequentOption)
      doDepthCount(option->states[j]->subsequentOption, depth+1);
  }
  
}

void ATH2004ERS7Xabsl2Profiler::doProfiling(Xabsl2Engine& pEngine, unsigned long framenumber){

  const Xabsl2Option* option;
  std::vector<ATH2004ERS7Xabsl2ActiveOption> activeStates;
    
  // number of active options is 0 when basic behaviors are tested separately
  option = pEngine.getRootOption();
  while (option!=0) 
  {
    if(nameTable.exists(option->n, option->activeState->n))
    {
      std::vector<double> params;

      for(int i = 0; i<option->parameters.getSize();++i)
      {
        params.push_back(option->parameters[i]);
      }

      ATH2004ERS7Xabsl2ActiveOption entry(nameTable.getOptionPosition(option->n), nameTable.getStatePosition(option->n, option->activeState->n), params);
      activeStates.push_back(entry);
    }
    option = option->activeState->subsequentOption;
  }
  if(!log.size() || log.back().activeOptions != activeStates)
    log.push_back(ATH2004ERS7Xabsl2LogEntry(framenumber, activeStates));
    
}

void ATH2004ERS7Xabsl2Profiler::recordCollectedLogs(){

  OutTextFile out(outfilename.c_str(), true);
  // debugLogToStream(out);
  writeLogToStream(out);

}
void ATH2004ERS7Xabsl2Profiler::recordCompleteLog(){

  OutTextFile test(outfilename.c_str(), true);
  debugLogToStream(test);
  // writeCompleteLogToStream(out);

}

/* deletes entries while writing out */
void ATH2004ERS7Xabsl2Profiler::writeLogToStream(Out& out)
{

  int upperBound = NROFELEMW < log.size() ? NROFELEMW : log.size()-1;
  for(int j = 0; j < upperBound; ++j){
    std::deque<ATH2004ERS7Xabsl2LogEntry>::iterator i = log.begin();
    
    out << i->framenumber <<  i->activeOptions.size();
    for(std::vector<ATH2004ERS7Xabsl2ActiveOption>::iterator k = (*i).activeOptions.begin(); k != (*i).activeOptions.end(); ++k)
    {
      out << k->optionNumber;
      out << k->stateNumber;
      out << k->parameters.size();
      for(int l = 0; l < (int) (*k).parameters.size(); ++l){
        out << k->parameters[l];
      }
    }
    log.pop_front();
  }

}

void ATH2004ERS7Xabsl2Profiler::debugLogToStream(Out& out)
{

  int upperBound = NROFELEMW < log.size() ? NROFELEMW : log.size()-1;
  for(int j = 0; j < upperBound; ++j){
    std::deque<ATH2004ERS7Xabsl2LogEntry>::iterator i = log.begin();
    
    out << i->framenumber <<  i->activeOptions.size();
    for(std::vector<ATH2004ERS7Xabsl2ActiveOption>::iterator k = (*i).activeOptions.begin(); k != (*i).activeOptions.end(); ++k)
    {
      out << nameTable[k->optionNumber].optionName.c_str();
      out << nameTable[k->optionNumber].states[k->stateNumber].c_str();
      out << k->parameters.size();
      for(int l = 0; l < (int) (*k).parameters.size(); ++l){
        out << nameTable[k->optionNumber].parameters[l].c_str();
        out << k->parameters[l];
      }
        
    }
    // log.pop_front();
  }

}
void ATH2004ERS7Xabsl2Profiler::writeCompleteLogToStream(Out& out){

  for(std::deque<ATH2004ERS7Xabsl2LogEntry>::iterator i = log.begin(); i != log.end(); ++i){
    out << i->framenumber <<  i->activeOptions.size();
    for(std::vector<ATH2004ERS7Xabsl2ActiveOption>::iterator j = i->activeOptions.begin(); j != i->activeOptions.end(); ++j)
    {
      out << j->optionNumber;
      out << j->stateNumber;
      out << j->parameters.size();
      for(std::vector<double>::iterator k = (*j).parameters.begin(); k != (*j).parameters.end(); ++k)
        out << (*k);
    }
  }
  log.clear();

}

void ATH2004ERS7Xabsl2Profiler::writeNameTableToStream(Out& out){
  if(nameTable.getSize()){
    out << nameTable.getSize();
    for(int i = 0; i < nameTable.getSize(); ++i){
      
      out << nameTable[i].optionName.c_str();
      out << nameTable[i].maxdepth;
      out << nameTable[i].states.size();
      
      int j;
      for(j = 0; j < (int)nameTable[i].states.size(); ++j){
        out << nameTable[i].states[j].c_str();
      }
      
      out << nameTable[i].parameters.size();
      for(j = 0; j < (int)nameTable[i].parameters.size(); ++j){
        out << nameTable[i].parameters[j].c_str();
      }
    }
  }
}

void ATH2004ERS7Xabsl2Profiler::exportXMLFile(const char* outf){
  OutTextFile outtt("test.test", false);
  debugLogToStream(outtt);

  OutTextRawFile out(outf?outf:outfilename.c_str(),false);
  writeXMLtoStream(out);
}
void ATH2004ERS7Xabsl2Profiler::writeXMLtoStream(Out& out){

  out << "<log>\n";
  for(std::deque<ATH2004ERS7Xabsl2LogEntry>::iterator i = log.begin(); i != log.end(); ++i)
  {
    out << "<logentry" << " framenumber=\"" << i->framenumber << "\">";  
    for(std::vector<ATH2004ERS7Xabsl2ActiveOption>::iterator j = i->activeOptions.begin(); j !=i->activeOptions.end(); ++j)
    {
      out << "<active";
      out << " option=\"" << nameTable[j->optionNumber].optionName.c_str() << "\"";  
      out << " state=\"" << nameTable[j->optionNumber].states[j->stateNumber].c_str() << "\"";  
      out << " maxdepth=\"" << nameTable[j->optionNumber].maxdepth << "\" >";
      for(int k = 0; k < (int) j->parameters.size(); ++j){
        out << "<parameter name\"";
        out << nameTable[j->optionNumber].parameters[k].c_str();
        out << "\" value=\"";
        out << j->parameters[k];
        out << "\"/>";
      }
      
      out << "</active>";
    }
    
      
   }
   out << "</logentry>" << endl;
  out << "</log>";
}

bool ATH2004ERS7Xabsl2Profiler::importLogFile(const char* filename){
  InTextFile in(filename);
  if(!in.exists())
    return false;
  if(in.eof())
    return true;
  
  nameTable.clear();
  log.clear();
  
  // nametable
  int nametablesize;
  char optionname[300];
  char name[300];
  int depth;
  in >> nametablesize;
  for(;nametablesize > 0; --nametablesize){
    std::vector<std::string> statenames;
    std::vector<std::string> paramnames;
    
    in >> optionname;
    in >> depth;
    
    int number;
    in >> number;
    for(;number > 0; --number){
      in >> name;
      statenames.push_back(name);
    }
    in >> number;
    for(;number > 0; --number){
      in >> name;
      paramnames.push_back(name);
    }
      
    nameTable.append(optionname, statenames, paramnames, depth);
    if(depth > maxdepth - 1)
      maxdepth = depth + 1;
  }

  // logs
  int framenmb;
  while(!in.getEof()){
    
    int nrofoptions;
    in >> framenmb;
    in >> nrofoptions;
    std::vector<ATH2004ERS7Xabsl2ActiveOption> activeOptions;
    for(;nrofoptions > 0; --nrofoptions){
      int optionnumber;
      int statenumber;
      in >> optionnumber;
      in >> statenumber;
      int nrofparams;
      in >> nrofparams;
      std::vector<double> params;

      for(;nrofparams > 0; -- nrofparams){
        double param;
        in >> param;
        params.push_back(param);
      }

      activeOptions.push_back(ATH2004ERS7Xabsl2ActiveOption(optionnumber, statenumber, params));
    }
    log.push_back(ATH2004ERS7Xabsl2LogEntry(framenmb, activeOptions));
  }

  OutTextFile out("test.in", false);
  debugLogToStream(out);

  return true;
  
}
std::vector<ATH2004ERS7Xabsl2ActiveOption> ATH2004ERS7Xabsl2Profiler::getActiveOptionsAtFrame(int time){

  std::deque<ATH2004ERS7Xabsl2LogEntry>::iterator i = log.begin();
  std::vector<ATH2004ERS7Xabsl2ActiveOption> t;
  while(i != log.end() && (int)(*i).framenumber <= time){
    t = (*i).activeOptions;
    ++i;
  }
  return t;

}
std::string ATH2004ERS7Xabsl2Profiler::getOptionName(int optionnumber){

  if(optionnumber && optionnumber < nameTable.getSize())
    return nameTable[optionnumber].optionName;
  else
    return std::string();

}
std::string ATH2004ERS7Xabsl2Profiler::getStateName(int optionnumber, int statenumber){

  if(statenumber < nameTable.getSize())
    return nameTable[optionnumber].states[statenumber];
  else
    return std::string();

}

int ATH2004ERS7Xabsl2Profiler::getDepth(char* optionname){

  return nameTable.existsOption(optionname)? nameTable[nameTable.getOptionPosition(optionname)].maxdepth : -1;

}

int ATH2004ERS7Xabsl2Profiler::getDepth(int optionnumber){
  return optionnumber < nameTable.getSize()? nameTable[optionnumber].maxdepth : -1;
}

int ATH2004ERS7Xabsl2Profiler::getFollowingFramenumber(int frame){

  std::deque<ATH2004ERS7Xabsl2LogEntry>::iterator i = log.begin();
  while(i != log.end()){
    if((int)(*i).framenumber <= frame)
      return (*i).framenumber;
    ++i;
  }
  return -1;

}

int ATH2004ERS7Xabsl2Profiler::getIndex(int framenumber){
  int temp = -1;
  std::deque<ATH2004ERS7Xabsl2LogEntry>::iterator i = log.begin();
  while(i != log.end() && (int)(*i).framenumber <= framenumber){
    ++temp;
     ++i;
  }
  return temp;
}

ATH2004ERS7Xabsl2LogEntry& ATH2004ERS7Xabsl2Profiler::operator[](int i){
  return log[i];
}
int ATH2004ERS7Xabsl2Profiler::size(){
  return log.size();
}
ATH2004ERS7Xabsl2ProfilerNameTableEntry& ATH2004ERS7Xabsl2Profiler::getNameTableEntry(int index){
  return nameTable[index];
}
bool ATH2004ERS7Xabsl2Profiler::getActiveOption(int index, int maxdepth, ATH2004ERS7Xabsl2ActiveOption& retour){
  if(index > -1 && index < (int) log.size()){
    for(int i = 0; i < (int) log[index].activeOptions.size(); ++i){
      if(nameTable[log[index].activeOptions[i].optionNumber].maxdepth == maxdepth){
        retour = log[index].activeOptions[i];
        return true;
      }
        
      
    }
  }
  return false;
}


/*
* Change Log:
*
* $Log: ATH2004ERS7Xabsl2Profiler.cpp,v $
* Revision 1.11  2004/05/22 16:58:04  spranger
* changed dialog appearance, added features (including extended profiler-interface)
*
* Revision 1.10  2004/05/04 15:35:02  spranger
* extended interface
*
* Revision 1.9  2004/05/03 13:21:57  spranger
* extended interface
*
* Revision 1.8  2004/04/30 09:26:23  spranger
* redone interface, added xml-export
*
* Revision 1.7  2004/04/28 17:31:40  spranger
* redesign of nametable, added import facilities
*
* Revision 1.6  2004/04/24 08:27:00  roefer
* Warning removed. The original code was somewhat nonsense. Was it really intended that way?
*
* Revision 1.5  2004/04/22 14:28:02  roefer
* .NET errors/warnings removed
*
* Revision 1.4  2004/04/22 11:33:19  spranger
* different log handling (queue), added writingoglogs which does not write out whole log
*
* Revision 1.3  2004/04/20 18:17:01  spranger
* added nametable-structure, added log functionality
*
* Revision 1.2  2004/04/14 13:33:54  loetzsch
* added change log
*
*/

