/**
* @file BB2004BehaviorControl.h
* 
* Implementation of class BB2004BehaviorControl.
*
* @author Martin Ltzsch
* @author Tim Laue
*/

#ifndef BB2004BehaviorControl_h_
#define BB2004BehaviorControl_h_

#include "BB2004BasicBehaviors/BB2004SimpleBasicBehaviors.h"
#include "../CommonXabsl2BasicBehaviors/CommonBasicBehaviors.h"

#include "../CommonXabsl2Symbols/BallSymbols.h"
#include "../CommonXabsl2Symbols/HeadAndTailSymbols.h"
#include "../CommonXabsl2Symbols/JoystickSymbols.h"
#include "../CommonXabsl2Symbols/LEDAndSoundSymbols.h"
#include "../CommonXabsl2Symbols/MathFunctions.h"
#include "../CommonXabsl2Symbols/MotionRequestSymbols.h"
#include "../CommonXabsl2Symbols/RoboCupGameManagerSymbols.h"
#include "../CommonXabsl2Symbols/RobotPoseSymbols.h"
#include "../CommonXabsl2Symbols/RobotStateSymbols.h"
#include "../CommonXabsl2Symbols/SpecialVisionSymbols.h"
#include "../CommonXabsl2Symbols/ChallengeSymbols.h"
#include "BB2004Symbols/BB2004StrategySymbols.h"
#include "BB2004Symbols/BB2004TaskSymbols.h"
#include "BB2004Symbols/BB2004ConfigurationSymbols.h"
#include "../Xabsl2BehaviorControl.h"
#include "BB2004BehaviorConfiguration.h"


/**
* @class BB2004BehaviorControl
*
* A Behavior based on the Xabsl2Engine that is used by the Bremen Byters
* for the RoboCup German Open 2004.
*
* @author Martin Ltzsch
* @author Tim Laue
*/ 
class BB2004BehaviorControl : public Xabsl2BehaviorControl
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  BB2004BehaviorControl(const BehaviorControlInterfaces& interfaces);

  /** destructor */
  ~BB2004BehaviorControl();

  /** Registers symbols and basic behaviors at the engine */
  virtual void registerSymbolsAndBasicBehaviors();
  
  /** Executes the module */
  virtual void execute();

  /** 
  * Is called for every incoming debug message.
  * @param message An interface to read the message from the queue
  * @return if the messag was read
  */
  virtual bool handleMessage(InMessage& message);

private:
  //!@name Symbols
  //!@{
  BallSymbols ballSymbols;
  HeadAndTailSymbols headAndTailSymbols;
  JoystickSymbols joystickSymbols;
  LEDAndSoundSymbols ledAndSoundSymbols;
  MathFunctions mathFunctions;
  MotionRequestSymbols motionRequestSymbols;
  RoboCupGameManagerSymbols roboCupGameManagerSymbols;
  RobotPoseSymbols robotPoseSymbols;
  RobotStateSymbols robotStateSymbols;
  SpecialVisionSymbols specialVisionSymbols;
  BB2004StrategySymbols strategySymbols;
  BB2004TaskSymbols taskSymbols;
  BB2004ConfigurationSymbols configurationSymbols;
  ChallengeSymbols challengeSymbols;
  //!@}

  //!@name Basic Behaviors
  //!@{
  BB2004SimpleBasicBehaviors simpleBasicBehaviors;
  CommonBasicBehaviors commonBasicBehaviors;
  //!@}

  BB2004BehaviorConfiguration behaviorConfiguration;
  SoundRequest::SoundID lastSound;

  unsigned long kickoffSwitchTime;
};

#endif   // BB2004BehaviorControl_h_


/*
 * Change log :
 * 
 * $Log: BB2004BehaviorControl.h,v $
 * Revision 1.3  2004/03/15 12:50:30  tim
 * Adaptions to new GameController
 *
 * Revision 1.2  2004/03/08 00:58:50  roefer
 * Interfaces should be const
 *
 * Revision 1.1  2003/10/26 22:49:36  loetzsch
 * created ATH2004BehaviorControl from GT2003BehaviorControl
 *  - strongly simplified option graph
 *  - moved some symbols from GT2003 to CommonXabsl2Symbols
 *  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
 *
 * cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
 *
 */
