/** 
* @file BB2004StrategySymbols.h
*
* Declaration of class BB2004StrategySymbols.
*
* @author Martin Ltzsch
*/

#ifndef __BB2004StrategySymbols_h_
#define __BB2004StrategySymbols_h_

#include "../../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

/**
* The Xabsl2 symbols that are defined in "strategy-symbols.xml"
*
* @author Martin Ltzsch
*/ 
class BB2004StrategySymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
  /*
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  BB2004StrategySymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
  /** updates the symbols */
  void update();

  /** current estimated time to reach the ball */
  double estimatedTimeToReachBall;

  /** computes the estimated time to reach the ball */
  void estimateTimeToReachBall();

  /** current role */
  BehaviorTeamMessage::DynamicRole role;

  /** The current task*/
  enum Task {playGoalie, standardDefend, standardSupport, playBall, searchBall} task;

  /** The base strategy*/
  enum BaseStrategy {defensive=0, standard, offensive} baseStrategy;

  /** computes the current role */
  void computeRole();

  /** computes the current task */
  void computeTask();

  //!@name Input symbols
  //!@{
  /* 
  * A function for the symbol "robot-number". 
  * Returns the robots back number as read from player.cfg 
  */
  double getRobotNumber() { return (double)(getPlayer().getPlayerNumber() + 1); };

  /** A function for the symbol "another-player-is-in-ready-state". */
  bool getAnotherPlayerIsInReadyState();

  /** A function for the symbol "another-teammate-is-preparing-a-kick" */
  bool getAnotherTeammateIsPreparingAKick();

  /** A function for the symbol "another-teammate-is-performing-a-kick" */
  bool getAnotherTeammateIsPerformingAKick();

  /** A function for the symbol "another-teammate-just-performed-a-kick" */
  bool getAnotherTeammateJustPerformedAKick();

  /** A funtion for the symbol "catch-ball" */
  bool getCaught(); 

  /** A function for the symbol "catch-ball-time" */
  double getCatchTime(); 

  /** A function for the symbol "search-ball.x" */
  double getSearchBallX();

  //!@}

  /** The time when the ball was started to catch */
  unsigned long timeWhenBallWasStartedToCatch;

  /** The time until the ball was caught */
  unsigned long timeUntilBallWasCaught;

  /** Indicates if the robot is stuck (based on obstacles model)*/
  bool robotIsStuck;

  /** Indicates that there are close obstacles */
  bool obstaclesAreClose;

  unsigned long timeOfLastTaskSelection;
};


#endif // __BB2004StrategySymbols_h_

/*
* Change Log
* 
* $Log: BB2004StrategySymbols.h,v $
* Revision 1.8  2004/04/09 14:06:44  tim
* integrated changes from GO2004
*
* Revision 1.8  2004/04/02 19:18:57  tim
* changed parameters
*
* Revision 1.7  2004/03/29 11:52:39  tim
* several small changes
*
* Revision 1.6  2004/03/25 12:05:55  tim
* added new tasks
*
* Revision 1.5  2004/03/19 15:38:00  tim
* changed BB2004BehaviorControl
*
* Revision 1.4  2004/03/15 12:50:31  tim
* Adaptions to new GameController
*
* Revision 1.3  2004/03/08 00:58:51  roefer
* Interfaces should be const
*
* Revision 1.2  2003/12/06 17:45:33  loetzsch
* replaced Player::playerRole (goalie, defender, striker1, striker2)
* by Player::playerNumber (one, two, three, four)
*
* Revision 1.1  2003/10/26 22:49:37  loetzsch
* created ATH2004BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
*
*/

