/** 
* @file PotentialFieldBehaviorSymbolSet.h
*
* Declaration of class PotentialFieldBehaviorSymbolSet.
*
* @author <a href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</a>
*/

#ifndef PotentialfieldBehaviorSymbolSet_h_
#define PotentialfieldBehaviorSymbolSet_h_

#include <string>
#include "../../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"
#include "../BBPotentialfields.h"


/**
* @class PotentialFieldBehaviorSymbolSet
*
* @author <a href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</a>
*/ 
class PotentialFieldBehaviorSymbolSet: public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{ 
public:
  /** Constructor 
  * @param interfaces The behavior control interfaces
  * @param behaviorName The name of the behavior
  * @param pfcFileName The name of the corresponding pfc file
  */
  PotentialFieldBehaviorSymbolSet(const BehaviorControlInterfaces& interfaces,
                                  const std::string& behaviorName, const std::string& pfcFileName);

  /** Registers the symbols at an engine 
  * @param engine A reference to the engine
  */
  void registerSymbols(Xabsl2Engine& engine);

  double getX();

  double getY();

  double getRotation();

  int getAction();

protected:
  /** The play ball behaviors*/
  enum PlayBallBehaviors {runToBall=0, avoidObstacles, dribble, kickForward, kickRight, kickLeft};
  /** The goalie behaviors*/
  enum GoalieBehaviors {goaliePosition=0, goalieGotoBall, goalieKickForward, goalieKickRight, goalieKickLeft, goalieStand};
  /** The standard defense behaviors*/
  enum StandardDefenseBehaviors {gotoDefense=0};
  /** The standard supporting behaviors*/
  enum StandardSupportBehaviors {gotoSupport=0};

  /** The potential fields*/
  BBPotentialfields pfields;
  /** The result computed by the potential fields*/
  PotentialfieldResult result;
  /** The selected action*/
  int action;
  /** The time stamp of the last computation*/
  unsigned long lastComputationTimeStamp;
  /** The name of the behavior*/
  std::string name;

  /** Updates the member variables*/
  void update();

  /** Resolves the name of the chosen potential field action*/
  void resolveActionName();
};


#endif // PotentialfieldBehaviorSymbolSet_h_

/*
* $Log: PotentialFieldBehaviorSymbolSet.h,v $
* Revision 1.6  2004/04/09 14:06:44  tim
* integrated changes from GO2004
*
* Revision 1.9  2004/04/03 05:21:08  tim
* improved behavior
*
* Revision 1.8  2004/03/31 21:22:35  tim
* changed behavior
*
* Revision 1.7  2004/03/31 20:13:06  tim
* changed behavior
*
* Revision 1.6  2004/03/30 22:45:16  tim
* changed behavior
*
* Revision 1.5  2004/03/27 09:34:04  tim
* changed BB2004 behavior
*
* Revision 1.4  2004/03/25 12:05:55  tim
* added new tasks
*
* Revision 1.3  2004/03/24 14:05:50  tim
* several small changes
*
* Revision 1.2  2004/03/19 15:38:01  tim
* changed BB2004BehaviorControl
*
* Revision 1.1  2004/03/15 12:37:24  tim
* BB2004 dynamic task selection classes added
*
*/

