/** 
* @file CommonBasicBehaviors.cpp
*
* Implementation of basic behaviors defined in simple-basic-behaviors.xml.
*
* @author Uwe Dffert
* @author Matthias Jngel
* @author Martin Ltzsch
* @author Max Risler
*/

#include "CommonBasicBehaviors.h"

void CommonBasicBehaviors::registerBasicBehaviors(Xabsl2Engine& engine)
{
  engine.registerBasicBehavior(basicBehaviorDoNothing);
  engine.registerBasicBehavior(basicBehaviorShutdown);
  engine.registerBasicBehavior(basicBehaviorSpecialAction);
  engine.registerBasicBehavior(basicBehaviorStand);
  engine.registerBasicBehavior(basicBehaviorWalk);
}

void BasicBehaviorShutdown::execute()
{
  SystemCall::shutdown();
}

void BasicBehaviorDoNothing::execute()
{
  // do nothing;
}

void BasicBehaviorWalk::execute()
{
  motionRequest.motionType = MotionRequest::walk;
  motionRequest.walkType   = static_cast<MotionRequest::WalkType>(static_cast<int>(type));
  motionRequest.walkParams.translation.x = speedX;
  motionRequest.walkParams.translation.y = speedY;
  motionRequest.walkParams.rotation = fromDegrees(rotationSpeed);
}

void BasicBehaviorSpecialAction::execute()
{
  motionRequest.motionType = MotionRequest::specialAction;
  motionRequest.specialActionType = static_cast<MotionRequest::SpecialActionID>(static_cast<int>(specialActionID));
}

void BasicBehaviorStand::execute()
{
  accelerationRestrictor.saveLastWalkParameters();

  motionRequest.walkParams.translation.x = 0;
  motionRequest.walkParams.translation.y = 0;
  motionRequest.walkParams.rotation = 0;

  accelerationRestrictor.restrictAccelerations(250,250,150);

  if (fabs(motionRequest.walkParams.translation.x) < 30
    && fabs(motionRequest.walkParams.translation.y) < 30
    && fabs(motionRequest.walkParams.rotation) < fromDegrees(30))
  {
    motionRequest.motionType = MotionRequest::stand;
  }
}


/*
* Change Log
* 
* $Log: CommonBasicBehaviors.cpp,v $
* Revision 1.8  2004/05/04 20:24:54  loetzsch
* minor improvments
*
* Revision 1.7  2004/05/04 10:48:58  loetzsch
* replaced all enums
* xxxBehaviorControlTimeAfterWhichCommunicatedBallsAreAccepted
* by
* behaviorControlTimeAfterWhichCommunicatedBallsAreAccepted
* (this mechanism was neither fully implemented nor used)
*
* Revision 1.6  2004/04/08 15:33:01  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.5  2004/04/07 13:44:33  risler
* ddd checkin after go04 - second part fixed walktype
*
* Revision 1.4  2004/04/07 12:28:56  risler
* ddd checkin after go04 - first part
*
* Revision 1.3  2004/03/29 17:49:27  loetzsch
* added walk type turnWithBall4
*
* Revision 1.2  2004/03/17 21:08:38  cesarz
* Added turnWithBall3, which points to MSH2004TurnWithBallWalkingParameters.
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
*/

