/** 
* @file CalibrationSymbols.cpp
*
* Implementation of class CalibrationSymbols.
*
* @author Matthias Jngel
*/

#include "CalibrationSymbols.h"
#include "Tools/StringFunctions.h"

CalibrationSymbols::CalibrationSymbols(const BehaviorControlInterfaces& interfaces)
: BehaviorControlInterfaces(interfaces)
{
}


void CalibrationSymbols::registerSymbols(Xabsl2Engine& engine)
{
  int i;
  char s[256];

  engine.registerEnumeratedOutputSymbol("calibration-mode",(int*)&calibrationRequest.mode);
  for (i = 0; i < CalibrationRequest::numOfCalibrationModes; i++)
  {
    sprintf(s,"calibration-mode.");
    getXmlString(s+strlen(s), CalibrationRequest::getCalibrationModeName((CalibrationRequest::CalibrationMode)i));
    engine.registerEnumeratedOutputSymbolEnumElement("calibration-mode",s,i);
  }

  engine.registerEnumeratedOutputSymbol("calibration-feedback",(int*)&calibrationRequest.feedback);
  for (i = 0; i < CalibrationRequest::numOfCalibrationFeedbacks; i++)
  {
    sprintf(s,"calibration-feedback.");
    getXmlString(s+strlen(s), CalibrationRequest::getCalibrationFeedbackName((CalibrationRequest::CalibrationFeedback)i));
    engine.registerEnumeratedOutputSymbolEnumElement("calibration-feedback",s,i);
  }
}


/*
* Change Log
* 
* $Log: CalibrationSymbols.cpp,v $
* Revision 1.1  2004/03/21 12:37:29  juengel
* Moved calibration symbols to common symbols.
*
* Revision 1.2  2004/03/08 01:06:58  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/12 11:44:58  juengel
* Added CalibrationRequest.
*
*/

