/** 
* @file ChallengeSymbols.h
*
* Declaration of class ChallengeSymbols.
*
* @author Thomas Rfer
*/

#ifndef __ChallengeSymbols_h_
#define __ChallengeSymbols_h_

#include "../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

/**
* The Xabsl2 symbols that are defined in "challenge-symbols.xml"
*
* @author Thomas Rfer
*/ 
class ChallengeSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The parameters of the BehaviorControl module.
  */
  ChallengeSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);

  /** updates the symbols */
  void update();
};


#endif // __ChallengeSymbols_h_

/*
* Change Log
* 
* $Log: ChallengeSymbols.h,v $
* Revision 1.2  2004/03/08 00:58:55  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
*/

