/** 
* @file LEDAndSoundSymbols.cpp
*
* Implementation of class LEDAndSoundSymbols.
*
* @author Uwe Dffert
* @author Martin Ltzsch
*/

#include "LEDAndSoundSymbols.h"
#include "Tools/StringFunctions.h"

LEDAndSoundSymbols::LEDAndSoundSymbols(const BehaviorControlInterfaces& interfaces)
: BehaviorControlInterfaces(interfaces)
{
}


void LEDAndSoundSymbols::registerSymbols(Xabsl2Engine& engine)
{
  int i;
  char s[256];

  // "leds.top-red"
  engine.registerEnumeratedOutputSymbol("leds.top-red",(int*)&ledRequest.redTopLEDs);
  for (i=0;i<LEDRequest::numOfRedLEDPairs;i++)
  {
    sprintf(s,"top.");
    getXmlString(s+strlen(s),LEDRequest::getRedLEDPairName((LEDRequest::RedLEDPair)i));
    engine.registerEnumeratedOutputSymbolEnumElement("leds.top-red",s,i);
  }
  
  // "leds.bottom-red"
  engine.registerEnumeratedOutputSymbol("leds.bottom-red",(int*)&ledRequest.redBottomLEDs);
  for (i=0;i<LEDRequest::numOfRedLEDPairs;i++)
  {
    char s[256];
    sprintf(s,"bottom.");
    getXmlString(s+strlen(s),LEDRequest::getRedLEDPairName((LEDRequest::RedLEDPair)i));
    engine.registerEnumeratedOutputSymbolEnumElement("leds.bottom-red",s,i);
  }

  // "leds.face"
  for(int faceLEDNumber = 1; faceLEDNumber <= 14; faceLEDNumber++)
  {
    char symbolName[256];
    sprintf(symbolName,"leds.face%i", faceLEDNumber);
    engine.registerEnumeratedOutputSymbol(symbolName,(int*)&ledRequest.faceLED[faceLEDNumber-1]);
    for (i=0;i<LEDRequest::numOfBlinkModes;i++)
    {
      char s[256];
      sprintf(s,"face%i.", faceLEDNumber);
      getXmlString(s+strlen(s),LEDRequest::getBlinkModeName((LEDRequest::BlinkMode)i));
      engine.registerEnumeratedOutputSymbolEnumElement(symbolName,s,i);
    }
  }

  // leds.back-front-white
  engine.registerEnumeratedOutputSymbol("leds.back-front-white",(int*)&ledRequest.backFrontWhiteLED);
  for (i=0;i<LEDRequest::numOfBlinkModes;i++)
  {
    char s[256];
    sprintf(s,"back-front-white.");
    getXmlString(s+strlen(s),LEDRequest::getBlinkModeName((LEDRequest::BlinkMode)i));
    engine.registerEnumeratedOutputSymbolEnumElement("leds.back-front-white",s,i);
  }

  // leds.back-front-blue
  engine.registerEnumeratedOutputSymbol("leds.back-front-blue",(int*)&ledRequest.backFrontBlueLED);
  for (i=0;i<LEDRequest::numOfBlinkModes;i++)
  {
    char s[256];
    sprintf(s,"back-front-blue.");
    getXmlString(s+strlen(s),LEDRequest::getBlinkModeName((LEDRequest::BlinkMode)i));
    engine.registerEnumeratedOutputSymbolEnumElement("leds.back-front-blue",s,i);
  }

  // leds.back-middle-white
  engine.registerEnumeratedOutputSymbol("leds.back-middle-white",(int*)&ledRequest.backMiddleWhiteLED);
  for (i=0;i<LEDRequest::numOfBlinkModes;i++)
  {
    char s[256];
    sprintf(s,"back-middle-white.");
    getXmlString(s+strlen(s),LEDRequest::getBlinkModeName((LEDRequest::BlinkMode)i));
    engine.registerEnumeratedOutputSymbolEnumElement("leds.back-middle-white",s,i);
  }

  // leds.back-middle-orange
  engine.registerEnumeratedOutputSymbol("leds.back-middle-orange",(int*)&ledRequest.backMiddleOrangeLED);
  for (i=0;i<LEDRequest::numOfBlinkModes;i++)
  {
    char s[256];
    sprintf(s,"back-middle-orange.");
    getXmlString(s+strlen(s),LEDRequest::getBlinkModeName((LEDRequest::BlinkMode)i));
    engine.registerEnumeratedOutputSymbolEnumElement("leds.back-middle-orange",s,i);
  }

  // leds.back-rear-white
  engine.registerEnumeratedOutputSymbol("leds.back-rear-white",(int*)&ledRequest.backRearWhiteLED);
  for (i=0;i<LEDRequest::numOfBlinkModes;i++)
  {
    char s[256];
    sprintf(s,"back-rear-white.");
    getXmlString(s+strlen(s),LEDRequest::getBlinkModeName((LEDRequest::BlinkMode)i));
    engine.registerEnumeratedOutputSymbolEnumElement("leds.back-rear-white",s,i);
  }

  // leds.back-rear-red
  engine.registerEnumeratedOutputSymbol("leds.back-rear-red",(int*)&ledRequest.backRearRedLED);
  for (i=0;i<LEDRequest::numOfBlinkModes;i++)
  {
    char s[256];
    sprintf(s,"back-rear-red.");
    getXmlString(s+strlen(s),LEDRequest::getBlinkModeName((LEDRequest::BlinkMode)i));
    engine.registerEnumeratedOutputSymbolEnumElement("leds.back-rear-red",s,i);
  }

  // leds.head-white
  engine.registerEnumeratedOutputSymbol("leds.head-white",(int*)&ledRequest.headWhiteLED);
  for (i=0;i<LEDRequest::numOfBlinkModes;i++)
  {
    char s[256];
    sprintf(s,"head-white.");
    getXmlString(s+strlen(s),LEDRequest::getBlinkModeName((LEDRequest::BlinkMode)i));
    engine.registerEnumeratedOutputSymbolEnumElement("leds.head-white",s,i);
  }

  // leds.head-orange
  engine.registerEnumeratedOutputSymbol("leds.head-orange",(int*)&ledRequest.headOrangeLED);
  for (i=0;i<LEDRequest::numOfBlinkModes;i++)
  {
    char s[256];
    sprintf(s,"head-orange.");
    getXmlString(s+strlen(s),LEDRequest::getBlinkModeName((LEDRequest::BlinkMode)i));
    engine.registerEnumeratedOutputSymbolEnumElement("leds.head-orange",s,i);
  }


  // "leds.tail-mode"
  engine.registerEnumeratedOutputSymbol("leds.tail-mode",(int*)&ledRequest.tailMode);
  for (i=0;i<LEDRequest::numOfTailModes;i++)
  {
    char s[256];
    sprintf(s,"tail.");
    getXmlString(s+strlen(s),LEDRequest::getTailModeName((LEDRequest::TailMode)i));
    engine.registerEnumeratedOutputSymbolEnumElement("leds.tail-mode",s,i);
  }

  // "sound-request"
  engine.registerEnumeratedOutputSymbol("sound-request",(int*)&soundRequest.soundID);
  for (i=0;i<SoundRequest::numOfSoundIDs;i++)
  {
    sprintf(s,"sound-request.");
    getXmlString(s+strlen(s),SoundRequest::getSoundIDName((SoundRequest::SoundID)i));
    engine.registerEnumeratedOutputSymbolEnumElement("sound-request",s,i);
  }
}


/*
* Change Log
* 
* $Log: LEDAndSoundSymbols.cpp,v $
* Revision 1.8  2004/03/25 21:20:19  juengel
* Added head LEDs.
*
* Revision 1.7  2004/03/25 19:56:28  loetzsch
* again changed the led request
*
* Revision 1.6  2004/03/25 17:40:15  loetzsch
* adaptations to changes in the game controller and the led request
*
* Revision 1.5  2004/03/21 19:08:15  juengel
* Added back*White LED support.
*
* Revision 1.4  2004/03/20 19:24:06  juengel
* Added face LEDs to LEDRequest
*
* Revision 1.3  2004/03/08 00:58:56  roefer
* Interfaces should be const
*
* Revision 1.2  2004/03/01 12:37:20  wachter
* Added LED-Request for button-interface
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:28  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2003/05/08 14:27:33  risler
* added tailMode to LEDRequest
*
* Revision 1.1  2003/05/06 14:46:12  loetzsch
* added registration of generated GT2003BehaviorControl symbols
*
*/

