/** 
* @file MotionRequestSymbols.h
*
* Declaration of class MotionRequestSymbols.
*
* @author Max Risler
*/

#ifndef __MotionRequestSymbols_h_
#define __MotionRequestSymbols_h_

#include "../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

/**
* The Xabsl2 symbols that are defined in "motion-request-symbols.xml"
*
* @author Max Risler
*/ 
class MotionRequestSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the BehaviorControl module.
  */
  MotionRequestSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
  /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  /** Function for symbol "executed-motion-request.special-action-type" */
  double getExecutedSpecialActionType();
  //!@}
};


#endif // __MotionRequestSymbols_h_

/*
* Change Log
* 
* $Log: MotionRequestSymbols.h,v $
* Revision 1.2  2004/03/08 00:58:56  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:28  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/07/07 15:02:33  cesarz
* added input symbol dribble.speed-y
*
* Revision 1.2  2003/07/03 18:39:30  risler
* do-kick option added
* all kicks use do-kick
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2003/05/08 00:22:29  risler
* removed symbol executed-motion-request.ball-caught
*
* Revision 1.1  2003/05/07 17:28:00  risler
* added MotionRequestSymbols
*
*
*/

