/** 
* @file RoboCupGameManagerSymbols.h
*
* Declaration of class RoboCupGameManagerSymbols.
*
* @author Matthias Jngel
*/

#ifndef __RoboCupGameManagerSymbols_h_
#define __RoboCupGameManagerSymbols_h_

#include "../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"


/**
* The Xabsl2 symbols that are defined in "robocup-game-manager-symbols.xml"
*
* @author Matthias Jngel
*/ 
class RoboCupGameManagerSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the BehaviorControl module.
  */
  RoboCupGameManagerSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
    /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  int getState(); /*!< A function for the symbol "game.state" */
  int getKickoff(); /*!< A function for the symbol "game.kickoff" */
  int getTeamColor(); /*!< A function for the symbol "game.team-color" */
  bool getOwnTeamScored(); /*!< A function for the symbol "game.own-team-scored"  */
  bool getOpponentTeamScored(); /*!< A function for the symbol "game.opponent-team-scored"  */
  double getOwnScore(); /*!< A function for the symbol "game.own-score" */
  double getOpponentScore(); /*!< A function for the symbol "game.opponent-score" */
  double getTimeSinceLastMessage(); /*!< A function for the symbol "game.time-since-last-message" */
  //!@}

  /* A function for the output symbol "set-team-color". */
  void setTeamColor(int teamColor);

private:
  /** the game control state we received the last time */
  int lastGameControlDataState;

  /** keeps the recent own score value */
  int lastOwnScore;

  /** keeps the recent opponent score value */
  int lastOpponentScore;

  /** keeps the time when the last own goal was shot */
  unsigned long timeWhenOwnTeamScored;

  /** keeps the time when the last opponent goal was shot */
  unsigned long timeWhenOpponentTeamScored;

  /** The current game state (set by the behavior)*/
  RState currentState;
};


#endif // __RoboCupGameManagerSymbols_h_

/*
* Change Log
* 
* $Log: RoboCupGameManagerSymbols.h,v $
* Revision 1.8  2004/04/09 14:06:45  tim
* integrated changes from GO2004
*
* Revision 1.7  2004/04/08 11:21:55  loetzsch
* removed function getCurrentState from RoboCupGameManagerSymbols
*
* Revision 1.6  2004/04/08 10:08:42  risler
* fixed and unified team color symbols
*
* Revision 1.5  2004/04/07 12:29:00  risler
* ddd checkin after go04 - first part
*
* Revision 1.3  2004/04/01 18:55:53  risler
* bugfix RoboCupGameManager team color interpertreted correctly
*
* Revision 1.2  2004/03/31 00:10:16  risler
* implemented new kickoff rules
*
* Revision 1.1.1.1  2004/03/29 08:28:49  Administrator
* initial transfer from tamara
*
* Revision 1.4  2004/03/25 15:49:47  tim
* changed handling of current state
*
* Revision 1.3  2004/03/15 12:50:31  tim
* Adaptions to new GameController
*
* Revision 1.2  2004/03/08 00:58:57  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:28  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/07/06 09:34:58  dueffert
* *-team-scored improved!
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2003/05/25 22:37:02  loetzsch
* finished the game state options of GT2003
*
* Revision 1.1  2003/05/07 17:54:46  juengel
* Added missing symbols to GT2003BehaviorControl.
*
*/

