/** 
* @file RobotPoseSymbols.h
*
* Declaration of class RobotPoseSymbols.
*
* @author Martin Ltzsch
*/

#ifndef __RobotPoseSymbols_h_
#define __RobotPoseSymbols_h_

#include "../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"
#include "Tools/FieldDimensions.h"
#include "Tools/Actorics/RobotDimensions.h"

/**
* The Xabsl2 symbols that are defined in "robot-pose-symbols.xml"
*
* @author Martin Ltzsch
*/ 
class RobotPoseSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the BehaviorControl module.
  */
  RobotPoseSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
    /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  double getAngle(); /*!< A function for the symbol "robot-pose.angle" */
  double getAngleToBorder(); /*!< A function for the symbol "robot-pose.angle-to-border" */
  double getDistanceToOwnGoal(); /*!< A function for the symbol "robot-pose.distance-to-own-goal" */
  double getDistanceToOwnPenaltyArea(); /*!< A function for the symbol "robot-pose.distance-to-own-penalty-area" */
  double getDistanceToOpponentGoal(); /*!< A function for the symbol "robot-pose.distance-to-opponent-goal" */
  double getAngleToOpponentGoal(); /*!< A function for the symbol "robot-pose.angle-to-opponent-goal" */
  double getBestAngleToOpponentGoal(); /*!< calculates the value for the symbol "robot-pose.best-angle-to-opponent-goal" */
  double getAngleToLeftOpponentGoal(); /*!< calculates the value for the symbol "robot-pose.angle-to-left-opponent-goal" */
  double getAngleToRightOpponentGoal(); /*!< calculates the value for the symbol "robot-pose.angle-to-right-opponent-goal" */
  double getBestAngleToOpponentGoalNoObstacles(); /*!< calculates the value for the symbol "robot-pose.best-angle-to-opponent-goal-no-obstacles" */
  double getAngleToPointBehindOpponentGoal(); /*!< calculates the value for the symbol "robot-pose.angle-to-point-behind-opponent-goal" */
  double getBestAngleAwayFromOwnGoal(); /*!< calculates the value for the symbol "robot-pose.best-angle-away-from-own-goal" */
  double getBestAngleAwayFromOwnGoalNoObstacles(); /*!< calculates the value for the symbol "robot-pose.best-angle-away-from-own-goal-no-obstacles" */
  bool getFreePartOfOpponentGoalWasDetermined(); /*!< calculates the value for the symbol "robot-pose.free-part-of-opponent-goal-was-determined" */
  bool getFreePartOfOwnGoalWasDetermined(); /*!< calculates the value for the symbol "robot-pose.free-part-of-own-goal-was-determined" */
  double getAngleToFreePartOfOpponentGoal(); /*!< calculates the value for the symbol "robot-pose.angle-to-free-part-of-opponent-goal" */
  bool getAngleToNextFreeTeammateWasDetermined(); /*!< calculates the value for the symbol "robot-pose.angle-to-next-free-teammate-was-determined" */
  double getAngleToNextFreeTeammate(); /*!< calculates the value for the symbol "robot-pose.angle-to-next-free-teammate" */
  double getDefensiveSupporterRobotPoseY(); /*!< calculates the value for the symbol "defensive-supporter.robot-pose.y" */
  double getStrikerRobotPoseY(); /*!< calculates the value for the symbol "striker.robot-pose.y" */
  double getGoalieGoalKickAngle(); /*!< calculates the value for the symbol "goalie.goal-kick-angle" */
  double getAngleToPenaltyPoint(); /*!< calculates the value for the symbol "robot-pose.get-penalty-point-angle" */
  double updateGoalieDefendPosition(); /*!< calculates the values for the symbols "robot-pose.goalie-defend-angle","robot-pose.goalie-defend-pos-x","robot-pose.goalie-defend-pos-y","robot-pose.goalie-defend-step-pos-x","robot-pose.goalie-defend-step-pos-y","robot-pose.goalie-defend-step-angle"*/
  double getGoalieDefendAngle(); /*!< returns the Symbol "robot-pose.goalie-defend-angle" */
  double getGoalieDefendPosY(); /*!< returns the Symbol "robot-pose.goalie-defend-pos-x" */
  double getGoalieDefendPosX(); /*!< returns the Symbol "robot-pose.goalie-defend-pos-y" */
  double getGoalieDefendStepPosX(); /*!< returns the Symbol "robot-pose.goalie-defend-step-pos-x" */
  double getGoalieDefendStepPosY(); /*!< returns the Symbol "robot-pose.goalie-defend-step-pos-y" */
  double getGoalieDefendStepAngle(); /*!< returns the Symbol "robot-pose.goalie-defend-step-angle" */
  double ballPosX; /*!< the Parameter "robot-pose.update-goalie-defend-position.ball-pos-x" for the decimal input function "robot-pose.update-goalie-defend-position" */
  double ballPosY; /*!< the Parameter "robot-pose.update-goalie-defend-position.ball-pos-y" for the decimal input function "robot-pose.update-goalie-defend-position" */
  void computeGoalieDefendMinPos(const double& alpha, const RobotDimensions& rD); /*!< calculates the values for the variables 'goalieDefendMinPosX','goalieDefendMinPosY','goalieDefendMinAngle' needed for the function 'updateGoalieDefendPosition'*/
  bool somethingInFrontOfChest(); /*!< true if something, e.g. the ball is in front of then chest */
  double getDistanceToSIFOC();

  //!@}
private:
  double goalieGoalKickAngle;
  double bestAngleToOpponentGoal;
  double bestAngleToOpponentGoalNoObstacles;
  double angleToPointBehindOpponentGoal;
  double bestAngleAwayFromOwnGoal;
  double bestAngleAwayFromOwnGoalNoObstacles;

  double goalieDefendAngle;
  double goalieDefendPositionX;
  double goalieDefendPositionY;
  double goalieDefendStepPosX;
  double goalieDefendStepPosY;
  double goalieDefendStepAngle;
  double goalieDefendRadiusMax;
  double goalieDefendRadiusMin;
  double goalieDefendMinPosX;
  double goalieDefendMinPosY;
  double goalieDefendRadius;
};


#endif // __RobotPoseSymbols_h_

/*
* Change Log
* 
* $Log: RobotPoseSymbols.h,v $
* Revision 1.12  2004/04/08 15:33:01  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.11  2004/04/05 17:56:47  loetzsch
* merged the local German Open CVS of the aibo team humboldt with the tamara CVS
*
* Revision 1.2  2004/04/04 01:16:13  jumped
* Added angle-to-point-behind-opponent-goal.
*
* Revision 1.1.1.1  2004/03/31 11:16:42  loetzsch
* created ATH repository for german open 2004
*
* Revision 1.10  2004/03/27 16:16:37  juengel
* Added distanceToBorder and angleToBorder.
*
* Revision 1.9  2004/03/17 16:31:20  kerdels
* added boolean input symbol "robot-pose.something-in-front-of-chest" utilizing the chest distance sensor
*
* Revision 1.8  2004/03/08 00:58:58  roefer
* Interfaces should be const
*
* Revision 1.7  2004/03/01 17:14:03  kerdels
* added robot-pose.distance-to-opponent-goal,
* moved robot-pose.angle-to-teammate1-3 to MSH2004StrategySymbols as fieldpos.angle-to-teammate1-3,
* added fieldpos.distance-to-teammate1-3,
* added DTT-Options newKickToGoal, newKickToClear, newKickToTeammate1-3,
* added DTT-OptionClass newKickToTeammate,
* added kickToPosRating function in DefaultOptionRating
*
* Revision 1.6  2004/02/27 10:45:17  spranger
* moved get-Angle-to-Teammate function and parameter to ATH2004StrategySymbols
*
* Revision 1.5  2004/02/25 13:45:24  spranger
* added function getAngleToTeammate and Xabsl input-function get-angle-to-teammate
*
* Revision 1.4  2004/02/16 00:55:07  rempe
* symbols for new goalie
*
* Revision 1.3  2004/01/27 14:28:14  lohmann
* getPenaltyPointAngle added (for bananaCross)
*
* Revision 1.2  2004/01/07 23:17:01  kerdels
* added symbols:
* robot-pose.angle-to-teammate1
* robot-pose.angle-to-teammate2
* robot-pose.angle-to-teammate3
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:29  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/07/05 23:57:09  juengel
* Added best-angle-away-from-own-goal and best-angle-away-from-own-goal-no-obstacles.
*
* Revision 1.2  2003/07/04 12:25:28  juengel
* Added bestAngleToOpponentGoalNoObstacles.
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.9  2003/06/19 19:51:07  juengel
* Obstacles are used to determine bestAngleToOpponentGoal.
*
* Revision 1.8  2003/06/19 12:11:17  juengel
* Changed calculation of goal-kick-angle.
*
* Revision 1.7  2003/06/18 13:47:36  loetzsch
* added input symbol "goalie.kick-when-stuck"
*
* Revision 1.6  2003/06/18 09:12:47  loetzsch
* added symbol "striker.robot-pose.y"
*
* Revision 1.5  2003/06/17 18:28:45  thomas
* added: goalie cont-behaviours, return-state, etc.
*
* Revision 1.4  2003/06/16 20:01:23  loetzsch
* added "defensive-supporter.robot-pose.y"
*
* Revision 1.3  2003/06/05 18:10:02  juengel
* Added angle-to-next-free-teammate.
*
* Revision 1.2  2003/05/26 13:06:46  juengel
* Moved angleToFreePartOfGoal from specialPercept to obstaclesPercept.
*
* Revision 1.1  2003/05/06 16:03:05  loetzsch
* added class RobotPoseSymbols
*
*/

