/** 
* @file RobotStateSymbols.cpp
*
* Implementation of class RobotStateSymbols.
*
* @author Matthias Jngel
*/

#include "RobotStateSymbols.h"

RobotStateSymbols::RobotStateSymbols(const BehaviorControlInterfaces& interfaces)
: BehaviorControlInterfaces(interfaces)
{
}


void RobotStateSymbols::registerSymbols(Xabsl2Engine& engine)
{
  // "robot-state.switches"
  engine.registerEnumeratedInputSymbol("robot-state.switches",this,
    (int (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getSwitches);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.switches","no-switch-pressed",RobotState::nothingPressed);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.switches","head-pressed",RobotState::headPressed);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.switches","fore-head-pressed",RobotState::headFrontPressed);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.switches","hind-head-pressed",RobotState::headBackPressed);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.switches","back-pressed",RobotState::backPressed);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.switches","fore-back-pressed",RobotState::backFrontPressed);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.switches","hind-back-pressed",RobotState::backBackPressed);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.switches","tail-up",RobotState::tailUp);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.switches","tail-down",RobotState::tailDown);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.switches","tail-left",RobotState::tailLeft);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.switches","tail-right",RobotState::tailRight);
  // "robot-state.switches.pressed-time"
  engine.registerDecimalInputSymbol("robot-state.switches.pressed-time",this,
    (double (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getSwitchesPressedTime);
  
  // "robot-state.tail-position"
  engine.registerEnumeratedInputSymbol("robot-state.tail-position",this,
    (int (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getTailPosition);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.tail-position","tail-left-top",RobotState::tailLeftTop);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.tail-position","tail-center-top",RobotState::tailCenterTop);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.tail-position","tail-right-top",RobotState::tailRightTop);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.tail-position","tail-left-center",RobotState::tailLeftCenter);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.tail-position","tail-center-center",RobotState::tailCenterCenter);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.tail-position","tail-right-center",RobotState::tailRightCenter);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.tail-position","tail-left-bottom",RobotState::tailLeftBottom);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.tail-position","tail-center-bottom",RobotState::tailCenterBottom);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.tail-position","tail-right-bottom",RobotState::tailRightBottom);
  
  // "robot-state.mouth-state"
  engine.registerEnumeratedInputSymbol("robot-state.mouth-state",this,
    (int (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getMouthState);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.mouth-state","mouth-open",RobotState::mouthOpen);
  engine.registerEnumeratedInputSymbolEnumElement("robot-state.mouth-state","mouth-closed",RobotState::mouthClosed);

  engine.registerBooleanInputSymbol("robot-state.ball-under-head",this,
    (bool (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getBallUnderHead);

  // "robot-state.system-time"
  engine.registerDecimalInputSymbol("robot-state.system-time",this,
    (double (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getCurrentSystemTime);
  // "robot-state.remaining-capacity"
  engine.registerDecimalInputSymbol("robot-state.remaining-capacity",this,
    (double (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getRemainingCapacity);

  // "robot-state.collision-front-left"
  engine.registerBooleanInputSymbol("robot-state.collision-front-left",this,
    (bool (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getCollisionFrontLeft);
  // "robot-state.collision-front-left"
  engine.registerBooleanInputSymbol("robot-state.collision-front-right",this,
    (bool (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getCollisionFrontRight);
  // "robot-state.collision-front-left"
  engine.registerBooleanInputSymbol("robot-state.collision-hind-left",this,
    (bool (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getCollisionHindLeft);
  // "robot-state.collision-front-left"
  engine.registerBooleanInputSymbol("robot-state.collision-hind-right",this,
    (bool (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getCollisionHindRight);
  // "robot-state.collision-front-left"
  engine.registerBooleanInputSymbol("robot-state.collision-head",this,
    (bool (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getCollisionHead);
  // "robot-state.collision-front-left"
  engine.registerBooleanInputSymbol("robot-state.collision-aggregate",this,
    (bool (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getCollisionAggregate);

  // "robot-state.consecutive-collision-time-front-left"
  engine.registerDecimalInputSymbol("robot-state.consecutive-collision-time-front-left",this,
    (double (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getConsecutiveCollisionTimeFrontLeft);
  // "robot-state.collision-consecutive-front-time-left"
  engine.registerDecimalInputSymbol("robot-state.consecutive-collision-time-front-right",this,
    (double (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getConsecutiveCollisionTimeFrontRight);
  // "robot-state.collision-consecutive-front-time-left"
  engine.registerDecimalInputSymbol("robot-state.consecutive-collision-time-hind-left",this,
    (double (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getConsecutiveCollisionTimeHindLeft);
  // "robot-state.collision-consecutive-front-time-left"
  engine.registerDecimalInputSymbol("robot-state.consecutive-collision-time-hind-right",this,
    (double (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getConsecutiveCollisionTimeHindRight);
  // "robot-state.collision-consecutive-front-time-left"
  engine.registerDecimalInputSymbol("robot-state.consecutive-collision-time-head",this,
    (double (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getConsecutiveCollisionTimeHead);
  // "robot-state.collision-consecutive-front-time-left"
  engine.registerDecimalInputSymbol("robot-state.consecutive-collision-time-aggregate",this,
    (double (Xabsl2FunctionProvider::*)())&RobotStateSymbols::getConsecutiveCollisionTimeAggregate);

}

void RobotStateSymbols::update()
{
}

int RobotStateSymbols::getSwitches()
{
  if (SystemCall::getTimeSince(robotState.getSwitchTimestamp())<1000)
  {
    return robotState.getSwitches();
  }
  else
  {
    return RobotState::nothingPressed;
  }
}

int RobotStateSymbols::getTailPosition()
{
  return robotState.getTailPosition();
}

int RobotStateSymbols::getMouthState()
{
  return robotState.getMouthState();
}

double RobotStateSymbols::getCurrentSystemTime()
{
  return SystemCall::getCurrentSystemTime();
}

double RobotStateSymbols::getRemainingCapacity()
{
  return SystemCall::getRemainingPower();
}

bool RobotStateSymbols::getCollisionFrontLeft()
{
  return robotState.getCollisionFrontLeft();
}

bool RobotStateSymbols::getCollisionFrontRight()
{
  return robotState.getCollisionFrontRight();
}

bool RobotStateSymbols::getCollisionHindLeft()
{
  return robotState.getCollisionHindLeft();
}

bool RobotStateSymbols::getCollisionHindRight()
{
  return robotState.getCollisionHindRight();
}

bool RobotStateSymbols::getCollisionHead()
{
  return robotState.getCollisionHead();
}

bool RobotStateSymbols::getCollisionAggregate()
{
  return robotState.getCollisionAggregate();
}

double RobotStateSymbols::getConsecutiveCollisionTimeFrontLeft()
{
  return robotState.getConsecutiveCollisionTimeFrontLeft();
}

double RobotStateSymbols::getConsecutiveCollisionTimeFrontRight()
{
  return robotState.getConsecutiveCollisionTimeFrontRight();
}

double RobotStateSymbols::getConsecutiveCollisionTimeHindLeft()
{
  return robotState.getConsecutiveCollisionTimeHindLeft();
}

double RobotStateSymbols::getConsecutiveCollisionTimeHindRight()
{
  return robotState.getConsecutiveCollisionTimeHindRight();
}

double RobotStateSymbols::getConsecutiveCollisionTimeHead()
{
  return robotState.getConsecutiveCollisionTimeHead();
}

double RobotStateSymbols::getConsecutiveCollisionTimeAggregate()
{
  return robotState.getConsecutiveCollisionTimeAggregate();
}

double RobotStateSymbols::getSwitchesPressedTime()
{
  return robotState.getSwitchDuration();
}

bool RobotStateSymbols::getBallUnderHead()
{
//  cout << sensorDataBuffer.lastFrame().data[SensorData::headTilt1]<<"|"<<sensorDataBuffer.lastFrame().data[SensorData::headTilt2]<<"\n";
//  cout << flush;
  return sensorDataBuffer.lastFrame().data[SensorData::headTilt2]>270000;

}

/*
* Change Log
* 
* $Log: RobotStateSymbols.cpp,v $
* Revision 1.4  2004/04/08 15:33:01  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.3  2004/03/08 00:58:58  roefer
* Interfaces should be const
*
* Revision 1.2  2004/01/24 11:40:13  juengel
* Added ERS7 switches (head, backFront, backBack).
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:29  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/08/09 14:56:09  dueffert
* symbol remaining-capacity added
*
* Revision 1.2  2003/07/06 12:33:05  dueffert
* robot.state-system.time added
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/06/21 13:06:51  goehring
* Debug Collisionsymbols
*
* Revision 1.4  2003/06/20 13:27:20  risler
* added tailLeft tailRight messages
*
* Revision 1.3  2003/06/20 10:32:27  goehring
* Added CollisionStateSymbols
*
* Revision 1.2  2003/06/10 15:09:07  goehring
* Collision-Detector Xabsl symbols added
*
* Revision 1.1  2003/05/07 17:54:46  juengel
* Added missing symbols to GT2003BehaviorControl.
*
*/

