/** 
* @file SpecialVisionSymbols.h
*
* Declaration of class SpecialVisionSymbols.
*
* @author Matthias Jngel
*/

#ifndef __SpecialVisionSymbols_h_
#define __SpecialVisionSymbols_h_

#include "../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

/**
* The Xabsl2 symbols that are defined in "special-vision-symbols.xml"
*
* @author Matthias Jngel
*/ 
class SpecialVisionSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the BehaviorControl module.
  */
  SpecialVisionSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
    /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  int getBarCodeValue(); /*!< A function for the symbol "bar-code" */
  //!@}
};


#endif // __SpecialVisionSymbols_h_

/*
* Change Log
* 
* $Log: SpecialVisionSymbols.h,v $
* Revision 1.2  2004/03/08 00:58:59  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:29  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/05/07 17:54:46  juengel
* Added missing symbols to GT2003BehaviorControl.
*
*/

