/** 
* @file DDD2004StrategySymbols.h
*
* Declaration of class DDD2004StrategySymbols.
*
* @author Martin Ltzsch
*/

#ifndef __DDD2004StrategySymbols_h_
#define __DDD2004StrategySymbols_h_

#include "../../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

/**
* The Xabsl2 symbols that are defined in "strategy-symbols.xml"
*
* @author Martin Ltzsch
*/ 
class DDD2004StrategySymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
  /*
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  DDD2004StrategySymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
  /** updates the symbols */
  void update();

  /** current estimated time to reach the ball */
  double estimatedTimeToReachBall;

  /** computes the estimated time to reach the ball */
  void estimateTimeToReachBall();

  /** current role */
  BehaviorTeamMessage::DynamicRole role;

  /** computes the current role */
  void computeRole();

  //!@name Input symbols
  //!@{
  /* 
  * A function for the symbol "robot-number". 
  * Returns the robots back number as read from player.cfg 
  */
  double getRobotNumber() { return (double)(getPlayer().getPlayerNumber() + 1); };

  /** A function for the symbol "another-player-is-in-ready-state". */
  bool getAnotherPlayerIsInReadyState();

  /** A function for the symbol "another-teammate-is-preparing-a-kick" */
  bool getAnotherTeammateIsPreparingAKick();

  /** A function for the symbol "another-teammate-is-performing-a-kick" */
  bool getAnotherTeammateIsPerformingAKick();

  /** A function for the symbol "another-teammate-just-performed-a-kick" */
  bool getAnotherTeammateJustPerformedAKick();

  /** A function for the symbol "the-striker-is-playing-near-the-opponent-goal" */
  bool getTheStrikerIsPlayingNearTheOpponentGoal();

  /** A function for the symbol "the-striker-is-not-playing-near-the-opponent-goal" */
  bool getTheStrikerIsNotPlayingNearTheOpponentGoal();

  /** A function for the symbol "the-striker-is-playing-near-the-own-goal" */
  bool getTheStrikerIsPlayingNearTheOwnGoal();

  /** A function for the symbol "the-striker-is-not-playing-near-the-own-goal" */
  bool getTheStrikerIsNotPlayingNearTheOwnGoal();

  /** A funtion for the symbol "catch-ball" */
  bool getCaught(); 

  /** A function for the symbol "catch-ball-time" */
  double getCatchTime(); 

  /** A function for the symbol "search-ball.x" */
  double getSearchBallX();

  /** A function for the symbol "all-teammates-send-sync" */
  bool getAllTeammatesSendSync();

  //!@}

  /** The time when the ball was started to catch */
  unsigned long timeWhenBallWasStartedToCatch;

  /** The time until the ball was caught */
  unsigned long timeUntilBallWasCaught;

  /** Indicates if the robot is stuck (based on obstacles model)*/
  bool robotIsStuck;

  /** Indicates that there are close obstacles */
  bool obstaclesAreClose;
};


#endif // __DDD2004StrategySymbols_h_

/*
* Change Log
* 
* $Log: DDD2004StrategySymbols.h,v $
* Revision 1.5  2004/05/03 22:23:36  risler
* added goal and final stuff
*
* Revision 1.4  2004/04/07 12:28:57  risler
* ddd checkin after go04 - first part
*
* Revision 1.2  2004/03/31 18:19:50  risler
* added body-psd input symbol
*
* Revision 1.3  2004/03/08 01:06:48  roefer
* Interfaces should be const
*
* Revision 1.2  2003/12/06 17:45:33  loetzsch
* replaced Player::playerRole (goalie, defender, striker1, striker2)
* by Player::playerNumber (one, two, three, four)
*
* Revision 1.1  2003/10/26 22:49:38  loetzsch
* created ATH2004BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
*
*/

