/** 
* @file GT2003ContinuousBasicBehaviors.h
*
* Declaration of basic behaviors defined in continuous-basic-behaviors.xml.
*
* @author Martin Kallnik
* @author Max Risler
*/

#ifndef __GT2003ContinuousBasicBehaviors_h_
#define __GT2003ContinuousBasicBehaviors_h_

#include "Tools/ContinuousBasicBehaviors/ContinuousBasicBehavior.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"
#include "../GT2003BehaviorConfiguration.h"

/**
* @class GT2003ContinuousBasicBehaviors
*
* Creates and registers simple basic behaviors
*/
class GT2003ContinuousBasicBehaviors : public BehaviorControlInterfaces
{
public:
  /**
  * Constructor
  */
  GT2003ContinuousBasicBehaviors(
                       const BehaviorControlInterfaces& interfaces,
                       GT2003BehaviorConfiguration& configuration,
                       Xabsl2ErrorHandler& errorHandler);

  /** Registers basic behaviors at the engine */
  void registerBasicBehaviors(Xabsl2Engine& engine);


  /** updates some variables */
  void update();

  //!@name Basic Behaviors parameters
  //!@{
  double goToPointX;
  double goToPointY;
  double goToPointAngle;
  double goToPointMaxSpeed;

  double goForwardToPointX;
  double goForwardToPointY;
  double goForwardToPointMaxSpeed;

  double goForwardToPointTurningX;
  double goForwardToPointTurningY;
  double goForwardToPointTurningMaxSpeed;
  double goForwardToPointTurningObstacleInfluenceLength;

  double dribbleX;
  double dribbleY;

  double turnWithBallAngle;
  double turnWithBallMaxRotationSpeed;
  double turnWithBallRotationCenter;
  double turnWithBallSpeedY;

  double walkAvoidingObstaclesType;
  double walkAvoidingObstaclesX;
  double walkAvoidingObstaclesY;
  double walkAvoidingObstaclesRot;

  double walkAroundAvoidingObstaclesX;
  double walkAroundAvoidingObstaclesY;

  double turnToBallMaxRotationSpeed;

  double turnRotationSpeed;

  double goalieClearMaxSpeed;
  double goalieGuardMaxSpeed;

  double goaliePositionX;
  double goaliePositionY;
  double goaliePositionMaxSpeed;
  double goaliePositionAngle;

  double supporterPositionX;
  double supporterPositionY;
  double supporterPositionMaxSpeed;
  //!@}

  /** known ball position used for some basic behaviors */
  Vector2<double> knownBallPos;

  /** known ball position in robot relative coordinates 
   * this is needed for basic behaviors that work with selflocator samples
   * as relative position has to be reconstructed first. */
  Vector2<double> knownBallPosRobotRelative;

private:
  /** Is invoked when errors occurs */
  Xabsl2ErrorHandler& errorHandler;

  /**
  * contains the current configuration parameters 
  */
  GT2003BehaviorConfiguration& configuration;

  //!@name Basic Behaviors
  //!@{
  ContinuousBasicBehavior goToPoint;
  ContinuousBasicBehavior goForwardToPoint;
  ContinuousBasicBehavior goForwardToPointTurning;
  ContinuousBasicBehavior goToBall;
  ContinuousBasicBehavior dribble;
  ContinuousBasicBehavior turnWithBall;
  ContinuousBasicBehavior walkAvoidingObstacles;
  ContinuousBasicBehavior walkAroundAvoidingObstacles;
  ContinuousBasicBehavior turnToBall;
  ContinuousBasicBehavior turn;
  ContinuousBasicBehavior goalieClear;
  ContinuousBasicBehavior goalieGuard;
  ContinuousBasicBehavior goaliePosition;
  ContinuousBasicBehavior goalieReturn;
  ContinuousBasicBehavior supporterPosition;
  //!@}

};


#endif // __GT2003ContinuousBasicBehaviors_h_

/*
* Change Log
* 
* $Log: GT2003ContinuousBasicBehaviors.h,v $
* Revision 1.3  2004/03/08 01:06:49  roefer
* Interfaces should be const
*
* Revision 1.2  2003/10/31 08:32:49  dueffert
* doxygen bugs fixed
*
* Revision 1.1  2003/10/22 22:18:45  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:31  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/07/07 09:28:03  thomas
* modified: goalie based on cont-goalie-clear and angle limit in guard-mode
*
* Revision 1.2  2003/07/03 10:51:32  juengel
* Added CBB goForwardToPointTurning
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.24  2003/06/18 15:36:49  risler
* added parameters max-rotation-speed, rotation-center to turn-with-ball
*
* Revision 1.23  2003/06/18 10:49:11  risler
* added cont-turn-with-ball
*
* Revision 1.22  2003/06/17 20:39:10  thomas
* modified: goalie position etc.
* added: parameter for max-speed etc.
*
* Revision 1.21  2003/06/17 18:28:45  thomas
* added: goalie cont-behaviours, return-state, etc.
*
* Revision 1.20  2003/06/07 16:58:30  risler
* added cont-turn
*
* Revision 1.19  2003/06/06 15:54:24  risler
* added parameter supporter-position.max-speed
*
* Revision 1.18  2003/06/05 17:30:47  risler
* added supporterPosition
* removed some unused behaviors
* dribble now has destination as parameter
*
* Revision 1.17  2003/06/05 08:08:28  juengel
* Added parameters to cont-walk-around-avoiding-obstacles.
*
* Revision 1.16  2003/06/04 11:20:06  risler
* added cont-goalie-position, cont-position-on-line
* walk rule does not set rotation
* dribble uses stricter acceleration restriction
*
* Revision 1.15  2003/06/03 13:07:07  juengel
* Added cont-walk-around-avoiding-obstacles.
*
* Revision 1.14  2003/05/29 12:32:32  risler
* added cont-turn-to-ball
*
* Revision 1.13  2003/05/26 09:51:48  risler
* configuration has to be reference
*
* Revision 1.12  2003/05/25 14:41:40  risler
* added GT2003BehaviorConfiguration
*
* Revision 1.11  2003/05/25 11:35:39  risler
* maxSpeed added to cont-go-to-point,cont-go-forward-to-point
*
* Revision 1.10  2003/05/15 10:26:58  risler
* added continuous rule Walk
* added continuous basic behavior walkAvoidingObstacles
*
* Revision 1.9  2003/05/15 01:22:23  risler
* added continuous basic behavior goToBall
*
* Revision 1.8  2003/05/14 09:05:53  risler
* added relative position to GoToPoint/TurnToPoint rules
*
* Revision 1.7  2003/05/13 15:39:56  risler
* goToPoint rule has no rotation
* added rules turnToPoint, turnToAngle
* added basic behavior go-forward-to-point
* added parameter angle to basic behavior go-to-point
*
* Revision 1.6  2003/05/09 15:23:08  risler
* renamed ballPos to knownBallPos
*
* Revision 1.5  2003/05/09 13:10:11  loetzsch
* removed useless #include statements
*
* Revision 1.4  2003/05/08 01:09:00  risler
* bugfix: gotopoint target point was no reference
*
* Revision 1.3  2003/05/07 13:02:34  risler
* added first continuous basic behaviors to GT2003BehaviorControl
*
* Revision 1.2  2003/05/05 19:22:03  risler
* added classes Simple/ContinuousBasicBehaviors for registering basic behaviors
*
* Revision 1.1  2003/05/03 15:14:02  loetzsch
* GT2003BehaviorControl first draft
*
*
*/

