/**
* @file GT2003ContinuousRules/Walk.h
*
* @author Max Risler
*/

#ifndef __GT2003Rules_Walk_h_
#define __GT2003Rules_Walk_h_

#include "Tools/ContinuousBasicBehaviors/ContinuousRule.h"

namespace GT2003ContinuousRules
{

/**@class Walk
 */
class Walk: public ContinuousRule{
private:
  /** reference to the requested speeds */
  const double &speedX;
  const double &speedY;

public:

  /** constructor
   */
  Walk(
    const BehaviorControlInterfaces& interfaces,
    const double &speedX,
    const double &speedY)
    :
    ContinuousRule(interfaces,"Walk"),
    speedX(speedX),
    speedY(speedY)
  {};

  /**
   * Returns whether this rule generates absolute or robot relative coordinates.
   * This rule is robot relative.
   */
  virtual bool isRelative() {return true;}

 	/** executes the basic behavior rule
   * @param robotPose the current robots pose at which the rule is to be evaluated
   * @param walk the direction and speed of the suggested motion coded as an vector (output)
	 * @param ra the rotation angle, the direction the robot should be directed (output)
	 * @param rweight the rotation weight the weight of the suggested rotation (output)
   */
  virtual void execute(const RobotPose& robotPose,
                       Vector2<double>& walk,
                       double& ra, double& rweight)
  {
    walk = Vector2<double>(speedX, speedY) / walkMaxForwardSpeed;
    rweight=0;
  }
};

}

#endif //__GT2003Rules_Walk_h_


/*
* Change log:
*
* $Log: Walk.h,v $
* Revision 1.3  2004/03/08 01:06:55  roefer
* Interfaces should be const
*
* Revision 1.2  2003/10/31 08:32:48  dueffert
* doxygen bugs fixed
*
* Revision 1.1  2003/10/22 22:18:46  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:31  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.7  2003/06/18 15:37:25  risler
* added rules walkX, walkY
*
* Revision 1.6  2003/06/17 19:57:16  juengel
* Added constructor with speedX only.
*
* Revision 1.5  2003/06/04 11:20:06  risler
* added cont-goalie-position, cont-position-on-line
* walk rule does not set rotation
* dribble uses stricter acceleration restriction
*
* Revision 1.4  2003/06/03 10:51:24  risler
* ContinuousRules can be in relative coordinates
* no rotation rule active => no rotation
*
* Revision 1.3  2003/05/22 06:48:02  dueffert
* extra ; warning removed
*
* Revision 1.2  2003/05/21 11:43:31  risler
* added namespaces to continuous rules to avoid problems with ambiguous class names
*
* Revision 1.1  2003/05/15 10:26:57  risler
* added continuous rule Walk
* added continuous basic behavior walkAvoidingObstacles
*
*
*/
