/**
* @file GT2003BehaviorConfiguration.cpp
* 
* Implementation of class GT2003BehaviorConfiguration.
*
* @author Max Risler
*/

#include "GT2003BehaviorConfiguration.h"

bool GT2003BehaviorConfiguration::handleMessage(InMessage& message)
{
  switch (message.getMessageID())
  {
    case idGT2003BehaviorConfiguration:
      message.bin >> *this;
      return true;
  }
  return false;
}

Out& operator<<(Out& stream, const GT2003BehaviorConfiguration& gt2003BehaviorConfiguration)
{
  stream.write(&gt2003BehaviorConfiguration,sizeof(GT2003BehaviorConfiguration));
  return stream;
}

In& operator>>(In& stream,GT2003BehaviorConfiguration& gt2003BehaviorConfiguration)
{
  stream.read(&gt2003BehaviorConfiguration,sizeof(GT2003BehaviorConfiguration));
  return stream;
}

/*
 * Change log :
 *
 * $Log: GT2003BehaviorConfiguration.cpp,v $
 * Revision 1.1  2003/10/06 13:39:29  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.4  2003/06/22 14:25:01  roefer
 * Challenge 2 symbols added
 *
 * Revision 1.3  2003/06/21 18:26:04  roefer
 * Loading points.cfg
 *
 * Revision 1.2  2003/05/27 15:51:15  dueffert
 * end of file warning removed
 *
 * Revision 1.1  2003/05/27 12:23:42  risler
 * added GT2003BehaviorConfiguration debug message
 *
 *
 */
