/** 
* @file ConfigurationSymbols.h
*
* Declaration of class ConfigurationSymbols.
*
* @author Max Risler
*/

#ifndef __ConfigurationSymbols_h_
#define __ConfigurationSymbols_h_

#include "../../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"
#include "../GT2003BehaviorConfiguration.h"

/**
* The Xabsl2 symbols that are defined in "configuration-symbols.xml"
*
* @author Max Risler
*/ 
class ConfigurationSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The parameters of the BehaviorControl module.
  */
  ConfigurationSymbols(const BehaviorControlInterfaces& interfaces, GT2003BehaviorConfiguration& configuration);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);

  /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  double getCurrentKickoff(); /*!< A function for the symbol "current-kickoff-variant" */
  double getOwnKickoffX(); /*!< A function for the symbol "own-kickoff.x" */
  double getOwnKickoffY(); /*!< A function for the symbol "own-kickoff.y" */
  double getOwnKickoffAngle(); /*!< A function for the symbol "own-kickoff.angle" */
  double getOpponentKickoffX(); /*!< A function for the symbol "opponent-kickoff.x" */
  double getOpponentKickoffY(); /*!< A function for the symbol "opponent-kickoff.y" */
  double getOpponentKickoffAngle(); /*!< A function for the symbol "opponent-kickoff.angle" */
  double getDribbleSpeedY(); /*!< A function for the symbol "dribble.speed-y" */
  //!@}
private:
  /**
  * contains the current configuration parameters 
  */
  GT2003BehaviorConfiguration& configuration;

  /**
  * current own kickoff variant 
  */
  int currentKickoff;
};


#endif // __ConfigurationSymbols_h_

/*
* Change Log
* 
* $Log: ConfigurationSymbols.h,v $
* Revision 1.3  2004/03/08 01:06:58  roefer
* Interfaces should be const
*
* Revision 1.2  2003/10/22 22:18:47  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:28  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.3  2003/06/21 15:01:13  risler
* kickoff with more than one player possible
* different kickoff variants added
*
* Revision 1.2  2003/05/26 09:51:19  risler
* configuration has to be reference
*
* Revision 1.1  2003/05/25 14:41:40  risler
* added GT2003BehaviorConfiguration
*
*
*/

