/**
* @file MSH2004BehaviorControl.cpp
* 
* Implementation of class MSH2004BehaviorControl.
*
* @author Martin Ltzsch
*/

#include "MSH2004BehaviorControl.h"
#include "Tools/Player.h"

#include "MSH2004DTT/DefaultOptionRating.h"
#include "MSH2004DTT/DefaultTacticChooser.h"
#include "Tools/Location.h"
#include "OpenChallengeDefines.h"
//#include <iostream.h>

MSH2004BehaviorControl::MSH2004BehaviorControl(const BehaviorControlInterfaces& interfaces)
: Xabsl2BehaviorControl(interfaces,SolutionRequest::msh2004),
  ballSymbols(interfaces),
  configurationSymbols(interfaces,configuration),
  headAndTailSymbols(interfaces),
  joystickSymbols(interfaces),
  ledAndSoundSymbols(interfaces),
  mathFunctions(interfaces),
  motionRequestSymbols(interfaces),
  roboCupGameManagerSymbols(interfaces), 
  robotPoseSymbols(interfaces),
  robotStateSymbols(interfaces),
  specialVisionSymbols(interfaces),
  strategySymbols(interfaces),
  kickEngineSymbols(interfaces,&kickEngine),
  testSymbols(interfaces),
  challengeSymbols(interfaces),
  openChallengeSymbols(interfaces),
	dttSymbols(interfaces,&actualTacticChooser,kickInProgress),
  evoSymbols(interfaces),
  simpleBasicBehaviors(interfaces,errorHandler),
  continuousBasicBehaviors(interfaces,configuration,errorHandler),
  evoBasicBehaviors(interfaces,errorHandler),
  commonBasicBehaviors(interfaces,errorHandler),
  lastSound(SoundRequest::none),
	collectedBeliefs(interfaces)
{
	// DynamicTeamTactic Section
  chooserRaterInterfaces.lastChoosenOption = RateableOptions::noOption;

  kickEngine=new MSH2004KickEngine(getLocation().getFilename("mshkicks.ke5"));
//  kickEngine->addKick(10,10,0,800.0,MotionRequest::bicycleKick);
//  kickEngine->addKick(3.0,100.1,0,800.0,MotionRequest::bicycleKickLeft);
//  kickEngine->addKick(3.0,100.1,0,800.0,MotionRequest::bicycleKickLeft); 

//  double successRate=30;
  //  MSH2004KickEngineSearchResult result=kickEngine->getPreferredKick(3.0,100.1,0,800);
  //  result.movement_x=0;

  //  result=kickEngine->getNeighbourhoodKick(3.0,140.1,0,800,20,10 );
  //  result.movement_x=0;
    
    //  MotionRequest::SpecialActionID  kick=kickEngine->getPreferredKick(3.0,300.1,0,800,successRate);

//  kickEngine->addKick(3.0,300.1,3,800.0,MotionRequest::bicycleKickLeft);
//  successRate=30;
//  kick=kickEngine->getPreferredKick(3.0,300.1,3,800,successRate);

  // Alle Engines erzeugen und im Array eintragen...

	// Hier die DefaultOptionRating Engine..
	optionRating[RateableOptions::defaultOptionRating] =
		new DefaultOptionRating(interfaces,collectedBeliefs,chooserRaterInterfaces,kickInProgress);

  // Die default engine als actuelle engine setzen.
	actualOptionRating = optionRating[RateableOptions::defaultOptionRating];


	// Hier die DefaultTacticChooser Engine..
	tacticChooser[RateableOptions::defaultTacticChooser] =
		new DefaultTacticChooser(interfaces,collectedBeliefs,chooserRaterInterfaces);

  // Die default engine als actuelle engine setzen.
	actualTacticChooser = tacticChooser[RateableOptions::defaultTacticChooser];


  // speed up the comspeed
  const_cast<TeamMessageCollection&>(teamMessageCollection).setDelay(500);



  Xabsl2FileInputSource file("Xabsl2/msh04-ic.dat");
  init(file);
}

MSH2004BehaviorControl::~MSH2004BehaviorControl()
{
	// Alle engines auch wieder aus dem Speicher putzen..
  delete(kickEngine);
  kickEngine=NULL;
  delete(optionRating[RateableOptions::defaultOptionRating]);
  optionRating[RateableOptions::defaultOptionRating] = NULL;
  delete(tacticChooser[RateableOptions::defaultTacticChooser]);
  tacticChooser[RateableOptions::defaultTacticChooser] = NULL;
  actualTacticChooser = NULL;
}

void MSH2004BehaviorControl::registerSymbolsAndBasicBehaviors()
{
  simpleBasicBehaviors.registerBasicBehaviors(*pEngine);
  continuousBasicBehaviors.registerBasicBehaviors(*pEngine);
  evoBasicBehaviors.registerBasicBehaviors(*pEngine);
  commonBasicBehaviors.registerBasicBehaviors(*pEngine);
  
  ballSymbols.registerSymbols(*pEngine);
  configurationSymbols.registerSymbols(*pEngine);
  headAndTailSymbols.registerSymbols(*pEngine);
  joystickSymbols.registerSymbols(*pEngine);
  ledAndSoundSymbols.registerSymbols(*pEngine);
  mathFunctions.registerSymbols(*pEngine);
  motionRequestSymbols.registerSymbols(*pEngine);
  roboCupGameManagerSymbols.registerSymbols(*pEngine);
  robotPoseSymbols.registerSymbols(*pEngine);
  robotStateSymbols.registerSymbols(*pEngine);
  specialVisionSymbols.registerSymbols(*pEngine);
  strategySymbols.registerSymbols(*pEngine);
  kickEngineSymbols.registerSymbols(*pEngine);
  challengeSymbols.registerSymbols(*pEngine);
	dttSymbols.registerSymbols(*pEngine);
	evoSymbols.registerSymbols(*pEngine);
	testSymbols.registerSymbols(*pEngine);
	openChallengeSymbols.registerSymbols(*pEngine);
}

void MSH2004BehaviorControl::execute()
{
  ballSymbols.update();
  configurationSymbols.update();
  roboCupGameManagerSymbols.update();
  robotPoseSymbols.update();
  strategySymbols.update();
  testSymbols.update();

#ifdef OPENCHALLENGE_DEFINES
 /* if ((dttSymbols.actualOption == RateableOptions::gotoBitePos1)
    ||(dttSymbols.actualOption == RateableOptions::bitePos1)
    ||(dttSymbols.actualOption == RateableOptions::movePos1)
    )
    openChallengeSymbols.bitePointToUse[getPlayer().getPlayerNumber()] = BitePoint::frontleft;
  if ((dttSymbols.actualOption == RateableOptions::gotoBitePos2)
    ||(dttSymbols.actualOption == RateableOptions::bitePos2)
    ||(dttSymbols.actualOption == RateableOptions::movePos2)
    )
    openChallengeSymbols.bitePointToUse[getPlayer().getPlayerNumber()] = BitePoint::frontright;
  if ((dttSymbols.actualOption == RateableOptions::gotoBitePos3)
    ||(dttSymbols.actualOption == RateableOptions::bitePos3)
    ||(dttSymbols.actualOption == RateableOptions::movePos3)
    )
    openChallengeSymbols.bitePointToUse[getPlayer().getPlayerNumber()] = BitePoint::behindleft;
  if ((dttSymbols.actualOption == RateableOptions::gotoBitePos4)
    ||(dttSymbols.actualOption == RateableOptions::bitePos4)
    ||(dttSymbols.actualOption == RateableOptions::movePos4)
    )
    openChallengeSymbols.bitePointToUse[getPlayer().getPlayerNumber()] = BitePoint::behindright;
*/
  /*
  for(int j=0; j<Player::numOfPlayerNumbers; ++j)
  {
    RateableOptions::OptionID option = ((DefaultTacticChooser*)actualTacticChooser)->ocplayerrole[j];
  if ((option == RateableOptions::gotoBitePos1)
    ||(option == RateableOptions::bitePos1)
    ||(option == RateableOptions::movePos1)
    )
    openChallengeSymbols.bitePointToUse[j] = BitePoint::frontleft;
  if ((option == RateableOptions::gotoBitePos2)
    ||(option == RateableOptions::bitePos2)
    ||(option == RateableOptions::movePos2)
    )
    openChallengeSymbols.bitePointToUse[j] = BitePoint::frontright;
  if ((option == RateableOptions::gotoBitePos3)
    ||(option == RateableOptions::bitePos3)
    ||(option == RateableOptions::movePos3)
    )
    openChallengeSymbols.bitePointToUse[j] = BitePoint::behindleft;
  if ((option == RateableOptions::gotoBitePos4)
    ||(option == RateableOptions::bitePos4)
    ||(option == RateableOptions::movePos4)
    )
    openChallengeSymbols.bitePointToUse[j] = BitePoint::behindright;
  if ((option == RateableOptions::gotoBridge)
    ||(option == RateableOptions::climbBridge)
    ||(option == RateableOptions::moveBridge)
    )
    {
      openChallengeSymbols.bitePointToUse[j] = BitePoint::master;
      openChallengeSymbols.masterDog = j;
    }
  }
*/
#endif

  openChallengeSymbols.update();
  
  continuousBasicBehaviors.update();



//  cout << sensorDataBuffer.lastFrame().data[SensorData::headTilt1]<<"|"<<sensorDataBuffer.lastFrame().data[SensorData::headTilt2]<<"\n";
//  cout << flush;

  
  // set the outgoint behavior team message to none
  outgoingBehaviorTeamMessage.message = BehaviorTeamMessage::none;
  
#ifndef SHOW_FREE_MEM

  // set the upper leds depending on the dynamic role.
  switch (strategySymbols.role)
  {
  case BehaviorTeamMessage::striker:
    ledRequest.redTopLEDs = LEDRequest::bothOn;
    break;
  case BehaviorTeamMessage::offensiveSupporter:
    ledRequest.redTopLEDs = LEDRequest::bothFastBlink;
    break;
  case BehaviorTeamMessage::defensiveSupporter:
  default:
    ledRequest.redTopLEDs = LEDRequest::bothOff;
  }
 
#else

  ledRequest.backFrontWhiteLED  = LEDRequest::oooo;

  ledRequest.backMiddleWhiteLED = LEDRequest::oooo;

  ledRequest.backRearWhiteLED   = LEDRequest::oooo;

  double freemem = (double)(SystemCall::getFreeMem()) / 67108864.0;
  
  if (freemem > 0.25)
    ledRequest.backRearWhiteLED = LEDRequest::llll;

  if (freemem > 0.5)
    ledRequest.backMiddleWhiteLED = LEDRequest::llll;

  if (freemem > 0.75)
    ledRequest.backFrontWhiteLED = LEDRequest::llll;

#endif
  
  // Set the tail request depending on whether the ball was seen
  if (SystemCall::getTimeSince(ballPosition.seen.timeWhenLastSeen) < 100)
  {
    framesBallSeen++;
    if (framesBallSeen>=5){
    // ball seen now
      motionRequest.tailRequest = MotionRequest::wagHorizontalFast;
    }
//    kickEngine->reportPossibleBallPosition(kickEngineSymbols.getRobotRelativeBallPosX(),kickEngineSymbols.getRobotRelativeBallPosY());
  }
  else if (SystemCall::getTimeSince(ballPosition.seen.timeWhenLastSeen) 
    > BallModel::behaviorControlTimeAfterWhichCommunicatedBallsAreAccepted
    && SystemCall::getTimeSince(ballPosition.communicated.timeWhenLastObserved) < 3000)
  {
    framesBallSeen=0;
    // ball known
    motionRequest.tailRequest = MotionRequest::wagVertical;
  }
  else
  {
    framesBallSeen=0;
    // ball not known
    motionRequest.tailRequest = MotionRequest::noTailWag;
  }
  
  // set head control mode lookToStars to detect missing settings
  headControlMode.headControlMode = HeadControlMode::lookToStars;


  // DynamicTeamTactic Section
	// Update the collectedBeliefs
	collectedBeliefs.update();

	// Rate your Options with actual ratingEngine
	actualOptionRating->rateOptions();

	// Update the DynamicTeamTactic Symbols
	dttSymbols.update();

#ifdef OPENCHALLENGE_DEFINES
  if ((dttSymbols.actualOption == RateableOptions::gotoBitePos1)
    ||(dttSymbols.actualOption == RateableOptions::bitePos1)
    ||(dttSymbols.actualOption == RateableOptions::movePos1)
    )
    ledRequest.faceLED[1] = LEDRequest::llll;
  if ((dttSymbols.actualOption == RateableOptions::gotoBitePos2)
    ||(dttSymbols.actualOption == RateableOptions::bitePos2)
    ||(dttSymbols.actualOption == RateableOptions::movePos2)
    )
    ledRequest.faceLED[0] = LEDRequest::llll;
  if ((dttSymbols.actualOption == RateableOptions::gotoBitePos3)
    ||(dttSymbols.actualOption == RateableOptions::bitePos3)
    ||(dttSymbols.actualOption == RateableOptions::movePos3)
    )
    ledRequest.faceLED[3] = LEDRequest::llll;
  if ((dttSymbols.actualOption == RateableOptions::gotoBitePos4)
    ||(dttSymbols.actualOption == RateableOptions::bitePos4)
    ||(dttSymbols.actualOption == RateableOptions::movePos4)
    )
    ledRequest.faceLED[2] = LEDRequest::llll;

  for(int j=0; j<Player::numOfPlayerNumbers; ++j)
  {
    RateableOptions::OptionID option = ((DefaultTacticChooser*)actualTacticChooser)->ocplayerrole[j];
  if ((option == RateableOptions::gotoBitePos1)
    ||(option == RateableOptions::bitePos1)
    ||(option == RateableOptions::movePos1)
    )
    openChallengeSymbols.bitePointToUse[j] = BitePoint::frontleft;
  if ((option == RateableOptions::gotoBitePos2)
    ||(option == RateableOptions::bitePos2)
    ||(option == RateableOptions::movePos2)
    )
    openChallengeSymbols.bitePointToUse[j] = BitePoint::frontright;
  if ((option == RateableOptions::gotoBitePos3)
    ||(option == RateableOptions::bitePos3)
    ||(option == RateableOptions::movePos3)
    )
    openChallengeSymbols.bitePointToUse[j] = BitePoint::behindleft;
  if ((option == RateableOptions::gotoBitePos4)
    ||(option == RateableOptions::bitePos4)
    ||(option == RateableOptions::movePos4)
    )
    openChallengeSymbols.bitePointToUse[j] = BitePoint::behindright;
  if ((option == RateableOptions::gotoBridge)
    ||(option == RateableOptions::climbBridge)
    ||(option == RateableOptions::moveBridge)
    )
    {
      openChallengeSymbols.bitePointToUse[j] = BitePoint::master;
      openChallengeSymbols.masterDog = j;
    }
  }

#endif    
	// broadcast your option-rating
	collectedBeliefs.broadcast();

	// trigger the singleBeliefs
	collectedBeliefs.trigger();

  // execute the engine
  executeEngine();

  if((robotState.getState() == RobotState::crashed)||
     (robotState.getState() == RobotState::rollLeft)||
     (robotState.getState() == RobotState::rollRight))
  {
    if ((motionRequest.motionType == MotionRequest::walk &&
      motionRequest.walkType != MotionRequest::upsideDown)||
      (motionRequest.motionType == MotionRequest::stand))
    {
      motionRequest.motionType = MotionRequest::getup;
      return;
    }
  }

  //  robotStateSymbols.behaviorExitTimeStamp = SystemCall::getCurrentSystemTime();
	
	SoundRequest::SoundID currentSound = soundRequest.soundID;
  
  if (headControlMode.headControlMode == HeadControlMode::lookToStars)
  {
    soundRequest.soundID = SoundRequest::rob101;
  }
  else if (
    strategySymbols.role == BehaviorTeamMessage::striker &&
    currentSound == lastSound)
  {
    if (strategySymbols.robotIsStuck)
    {
      soundRequest.soundID = SoundRequest::bing03;
    }
    else if (strategySymbols.obstaclesAreClose)
    {
      soundRequest.soundID = SoundRequest::bing01;
    }
    else if (robotState.getConsecutiveCollisionTimeAggregate() > 2000)
    {
      soundRequest.soundID = SoundRequest::bing05;
    }
  }

  lastSound = currentSound;
}

bool MSH2004BehaviorControl::handleMessage(InMessage& message)
{
  // Hier sollte mal eine Message abgefangen werden, die dann
  // actualOptionRating und den actualTacticChooser setzt..
	// al actualOptionRating = optionRating[selectedRating];
	// wobei selectedRating aus message kommt


  return (configuration.handleMessage(message) ||
    Xabsl2BehaviorControl::handleMessage(message) ||
    actualTacticChooser->handleMessage(message) );
}


/*
* Change log :
* 
* $Log: MSH2004BehaviorControl.cpp,v $
* Revision 1.33  2004/06/18 13:21:37  hamerla
* oc nach test rollenzuteilung
*
* Revision 1.32  2004/06/17 09:47:48  hamerla
* OC rollenzuteilung
*
* Revision 1.31  2004/06/16 20:35:56  kerdels
* added free mem display in MSH Behavior
*
* Revision 1.30  2004/06/16 11:44:32  hamerla
* OC LED BitePos
*
* Revision 1.29  2004/06/02 22:40:33  kerdels
* merged OpenChallengeSymbols from WM-Repository...
*
* Revision 1.28  2004/05/26 14:39:40  schumann
* some symbols for the challenge
*
* Revision 1.27  2004/05/14 11:37:08  loetzsch
* support for multiple xabsl2engines in different modules
* preliminary GT2004HeadControl (does not work at all)
*
* Revision 1.26  2004/05/04 10:48:58  loetzsch
* replaced all enums
* xxxBehaviorControlTimeAfterWhichCommunicatedBallsAreAccepted
* by
* behaviorControlTimeAfterWhichCommunicatedBallsAreAccepted
* (this mechanism was neither fully implemented nor used)
*
* Revision 1.25  2004/04/14 06:37:15  loetzsch
* removed the hack "kickInProgress" from the BehaviorControlInterfaces
*
* Revision 1.24  2004/04/08 15:33:01  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.32  2004/04/02 15:51:13  schumann
* Debug
*
* Revision 1.31  2004/03/31 12:15:34  pg_cars
* Added improved ball grabbing
*
* Revision 1.30  2004/03/27 13:58:44  pg_cars
* Bug fixed
*
* Revision 1.29  2004/03/26 15:31:33  pg_cars
* Improved data file format, improved debugging
*
* Revision 1.28  2004/03/26 09:21:48  pg_cars
* datafile changed, aggressive kick engine
*
* Revision 1.27  2004/03/24 14:45:12  pg_miwa
* Integrated button-interface for team-color and kickoff selection into option "initial"
* (does not really set the Team-Color at the moment)
*
* Revision 1.26  2004/03/24 12:19:03  pg_joha
* goalie kicks
*
* Revision 1.25  2004/03/22 17:53:07  pg_cars
* improved training for kick engine
*
* Revision 1.24  2004/03/21 04:36:05  pg_joke
* added slidingAverage to OptionRatings,
* added ratingBoost (Hysteresis) to OptionRatings
*
* Revision 1.23  2004/03/15 15:59:45  schumann
* splitted symbols for kick engine from other symbols
*
* Revision 1.22  2004/03/14 18:19:24  wachter
* rewrote glassbox-goalie
*
* Revision 1.21  2004/03/09 23:11:11  kerdels
* unmystified this bug (wasn't mystical at all :-( )
*
* Revision 1.20  2004/03/09 19:53:29  kerdels
* removed a myterious error ...
*
* Revision 1.19  2004/03/09 14:13:29  schumann
* changed training for kickengine
*
* Revision 1.18  2004/03/08 01:07:06  roefer
* Interfaces should be const
*
* Revision 1.17  2004/03/04 08:37:39  schumann
* added neighbourhood search
*
* Revision 1.16  2004/02/26 18:07:27  cesarz
* first version of evolution behavior
*
* Revision 1.15  2004/02/25 11:53:20  schumann
* extended range of kick engine
*
* Revision 1.14  2004/02/24 20:56:41  wachter
* Added some xabsl-symbols for testing.
*
* Revision 1.13  2004/02/24 13:51:32  schumann
* Changed structure of kick engine
*
* Revision 1.12  2004/02/23 12:52:57  schumann
* added MSH2004KickEngine
*
* Revision 1.11  2004/02/19 16:27:05  kerdels
* rated backUp option,
* made modifications discussed with michael,
* added backUp option to default.dtt
*
* Revision 1.10  2004/02/03 13:20:48  spranger
* renamed all references to  class BallPosition to BallModel (possibly changed include files)
*
* Revision 1.9  2004/01/29 21:33:27  kerdels
* added turn-for-ball Option to DTT,
* added link between TacticChooser and OptionRating
*
* Revision 1.8  2004/01/07 14:56:08  kerdels
* added send functionality to TacticDesigner
*
* Revision 1.7  2003/12/17 20:51:29  kerdels
* Updated dtt-symbols
*
* Revision 1.6  2003/12/15 12:18:13  kerdels
* memory leak fixed
*
* Revision 1.5  2003/12/15 11:34:03  dueffert
* memory leak fixed
*
* Revision 1.4  2003/12/11 19:36:59  kerdels
* Debugged.
*
* Revision 1.3  2003/12/11 18:28:21  kerdels
* DTT Framework fertiggestellt.
*
* Revision 1.2  2003/12/11 16:22:20  kerdels
* Die DynamicTeamTactic neu strukturiert und ins MSH2004 Behavior integriert..
*
* Revision 1.1  2003/10/26 22:49:39  loetzsch
* created ATH2004BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
*
*/

