/**
* @file MSH2004BehaviorControl.h
* 
* Implementation of class MSH2004BehaviorControl.
*
* @author Martin Ltzsch
*/

#ifndef __MSH2004BehaviorControl_h_
#define __MSH2004BehaviorControl_h_

#include "MSH2004BasicBehaviors/MSH2004SimpleBasicBehaviors.h"
#include "MSH2004BasicBehaviors/MSH2004ContinuousBasicBehaviors.h"
#include "MSH2004BasicBehaviors/MSH2004EvoBasicBehaviors.h"
#include "../CommonXabsl2BasicBehaviors/CommonBasicBehaviors.h"

#include "../CommonXabsl2Symbols/BallSymbols.h"
#include "../CommonXabsl2Symbols/HeadAndTailSymbols.h"
#include "../CommonXabsl2Symbols/JoystickSymbols.h"
#include "../CommonXabsl2Symbols/LEDAndSoundSymbols.h"
#include "../CommonXabsl2Symbols/MathFunctions.h"
#include "../CommonXabsl2Symbols/MotionRequestSymbols.h"
#include "../CommonXabsl2Symbols/RoboCupGameManagerSymbols.h"
#include "../CommonXabsl2Symbols/RobotPoseSymbols.h"
#include "../CommonXabsl2Symbols/RobotStateSymbols.h"
#include "../CommonXabsl2Symbols/SpecialVisionSymbols.h"
#include "../CommonXabsl2Symbols/ChallengeSymbols.h"
#include "MSH2004Symbols/MSH2004StrategySymbols.h"
#include "MSH2004Symbols/MSH2004KickEngineSymbols.h"
#include "MSH2004Symbols/OpenChallengeSymbols.h"
#include "MSH2004Symbols/MSH2004ConfigurationSymbols.h"
#include "MSH2004Symbols/MSH2004EvoSymbols.h"

#include "../Xabsl2BehaviorControl.h"

#include "MSH2004BehaviorConfiguration.h"

// Includes for DynamicTeamTactic
#include "Tools/DynamicTeamTactic/CollectedBeliefs.h"
#include "Tools/DynamicTeamTactic/OptionRating.h"
#include "Tools/DynamicTeamTactic/TacticChooser.h"
#include "Tools/DynamicTeamTactic/RateableOptions.h"
#include "MSH2004Symbols/MSH2004DTTSymbols.h"
#include "Tools/DynamicTeamTactic/ChooserRaterInterfaces.h"
#include "MSH2004KickEngine/MSH2004KickEngine.h"

// Test-Symbols for special testing

#include "MSH2004Symbols/MSH2004TestSymbols.h"

/**
* @class MSH2004BehaviorControl
*
* A Behavior based on the Xabsl2Engine that is used by the Microsoft Hellhounds
* for the RoboCup German Open 2004.
*
* @author Martin Ltzsch
*/ 
class MSH2004BehaviorControl : public Xabsl2BehaviorControl
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  MSH2004BehaviorControl(const BehaviorControlInterfaces& interfaces);

  /** destructor */
  ~MSH2004BehaviorControl();

  /** Registers symbols and basic behaviors at the engine */
  virtual void registerSymbolsAndBasicBehaviors();
  
  /** Executes the module */
  virtual void execute();

  /** 
  * Is called for every incoming debug message.
  * @param message An interface to read the message from the queue
  * @return if the messag was read
  */
  virtual bool handleMessage(InMessage& message);

  /**
  * contains the current configuration parameters 
  */
  MSH2004BehaviorConfiguration configuration;

private:
 
  //!@name Symbols
  //!@{
  BallSymbols ballSymbols;
  MSH2004ConfigurationSymbols configurationSymbols;
  HeadAndTailSymbols headAndTailSymbols;
  JoystickSymbols joystickSymbols;
  LEDAndSoundSymbols ledAndSoundSymbols;
  MathFunctions mathFunctions;
  MotionRequestSymbols motionRequestSymbols;
  RoboCupGameManagerSymbols roboCupGameManagerSymbols;
  RobotPoseSymbols robotPoseSymbols;
  RobotStateSymbols robotStateSymbols;
  SpecialVisionSymbols specialVisionSymbols;
  MSH2004StrategySymbols strategySymbols;
  MSH2004KickEngineSymbols kickEngineSymbols;
  MSH2004TestSymbols testSymbols;
  ChallengeSymbols challengeSymbols;
  OpenChallengeSymbols openChallengeSymbols;
	MSH2004DTTSymbols dttSymbols;
	MSH2004EvoSymbols evoSymbols;
  //!@}

  //!@name Basic Behaviors
  //!@{
  MSH2004SimpleBasicBehaviors simpleBasicBehaviors;
  MSH2004ContinuousBasicBehaviors continuousBasicBehaviors;
  MSH2004EvoBasicBehaviors evoBasicBehaviors;
  CommonBasicBehaviors commonBasicBehaviors;
  //!@}

  SoundRequest::SoundID lastSound;

	// DynamicTeamTactic Section
  ChooserRaterInterfaces chooserRaterInterfaces;
	
	// CollectedBeliefs Structure
	CollectedBeliefs collectedBeliefs;

	// OptionRating engine(s)
  OptionRating* optionRating[RateableOptions::numOfOptionRatings];
	// The actual choosen OptionRating
	OptionRating* actualOptionRating;

	// TacticChooser engine(s)
  TacticChooser* tacticChooser[RateableOptions::numOfTacticChoosers];
	// The actual choosen OptionRating
	TacticChooser* actualTacticChooser;

  MSH2004KickEngine* kickEngine;

  int framesBallSeen;

  // just a little hack for option rating
  bool kickInProgress;
};

#endif// __MSH2004BehaviorControl_h_

/*
 * Change log :
 * 
 * $Log: MSH2004BehaviorControl.h,v $
 * Revision 1.14  2004/05/26 14:39:40  schumann
 * some symbols for the challenge
 *
 * Revision 1.13  2004/04/14 06:37:15  loetzsch
 * removed the hack "kickInProgress" from the BehaviorControlInterfaces
 *
 * Revision 1.12  2004/04/08 15:33:01  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.12  2004/04/02 15:51:13  schumann
 * Debug
 *
 * Revision 1.11  2004/03/15 15:59:46  schumann
 * splitted symbols for kick engine from other symbols
 *
 * Revision 1.10  2004/03/09 23:11:12  kerdels
 * unmystified this bug (wasn't mystical at all :-( )
 *
 * Revision 1.9  2004/03/09 19:53:29  kerdels
 * removed a myterious error ...
 *
 * Revision 1.8  2004/03/08 01:07:07  roefer
 * Interfaces should be const
 *
 * Revision 1.7  2004/02/26 18:07:27  cesarz
 * first version of evolution behavior
 *
 * Revision 1.6  2004/02/24 20:56:41  wachter
 * Added some xabsl-symbols for testing.
 *
 * Revision 1.5  2004/02/23 12:52:57  schumann
 * added MSH2004KickEngine
 *
 * Revision 1.4  2004/01/29 21:33:27  kerdels
 * added turn-for-ball Option to DTT,
 * added link between TacticChooser and OptionRating
 *
 * Revision 1.3  2003/12/11 18:28:21  kerdels
 * DTT Framework fertiggestellt.
 *
 * Revision 1.2  2003/12/11 16:22:20  kerdels
 * Die DynamicTeamTactic neu strukturiert und ins MSH2004 Behavior integriert..
 *
 * Revision 1.1  2003/10/26 22:49:39  loetzsch
 * created ATH2004BehaviorControl from GT2003BehaviorControl
 *  - strongly simplified option graph
 *  - moved some symbols from GT2003 to CommonXabsl2Symbols
 *  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
 *
 * cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
 *
 */
