/**
* @file DefaultOptionRating.cpp
* 
* Implementation of class DefaultOptionRating
*
*/

#include <math.h>
#include "DefaultOptionRating.h"
#include "Tools/DynamicTeamTactic/RateableOptions.h"
#include "Tools/Math/Geometry.h"
#include "Tools/Math/Common.h"
#include "../OpenChallengeDefines.h"

#define NO_ENEMY_RATING
//#define NO_TEAMMATE_RATING

static int const defendZone1Border = 500;
static int const defendZone2Border = 1000;
static int const defendZone3Border = 1250;

static double const ballHasMovedThreshold = 100.0;

static unsigned long const speedTrigger = 1000;

#ifdef OPENCHALLENGE_DEFINES
  extern OCSetStatus2 ocstate;
#endif



DefaultOptionRating::DefaultOptionRating(const BehaviorControlInterfaces& interfaces,
																				 CollectedBeliefs& collectedBeliefs,
                                         ChooserRaterInterfaces& chooserRaterInterfaces,
                                         bool& kickInProgress)
: OptionRating(interfaces, collectedBeliefs, chooserRaterInterfaces, kickInProgress)
{
	lastDoJumpDefend = 0;

  freshDefend  = true;

  ballSensedPos.x = 0;
  ballSensedPos.y = 0;

  ballSensedTime = 0;
  ballSensedRelPos.x = 0;
  ballSensedRelPos.y = 0;

  jumpDefendRating = 0;
  jumpLeftRating   = 0;
  jumpRightRating  = 0;

  ballBase.reset(25);
  ballAct.reset(5);

  for(int i=0; i<5; i++)
    ocrating[i] = 100;
}

// doing some preCalculations... used in rateOptions()
void DefaultOptionRating::doPreCals()
{
  #ifndef OPENCHALLENGE_DEFINES

  int i,j;
  robotOrient.x = cos(robotPose.rotation);
	robotOrient.y = sin(robotPose.rotation);
  robotODist = robotOrient.abs();
  if (robotODist < 1)
    robotODist = 1;

  for (i=0; i < playerPoseCollection.numberOfOpponentPlayers; ++i) {
	  enemyRelPos[i].x =
			playerPoseCollection.getOpponentPlayerPose(i).getPose().translation.x - 
			robotPose.translation.x;
		enemyRelPos[i].y =
			playerPoseCollection.getOpponentPlayerPose(i).getPose().translation.y -
			robotPose.translation.y;
		enemyRelDist[i] = enemyRelPos[i].abs();
		if (enemyRelDist[i] < 1)
			enemyRelDist[i] = 1; 
    enemyValidity[i] = 
      playerPoseCollection.getOpponentPlayerPose(i).getValidity();
    if (enemyValidity[i] < 0)
      enemyValidity[i] = 0;
    if (enemyValidity[i] > 1)
      enemyValidity[i] = 1;
	}

	for (i=0; i < playerPoseCollection.numberOfOwnPlayers; ++i) {
	  teamRelPos[i].x =
			playerPoseCollection.getOwnPlayerPose(i).getPose().translation.x -
			robotPose.translation.x;
		teamRelPos[i].y =
      playerPoseCollection.getOwnPlayerPose(i).getPose().translation.y -
			robotPose.translation.y;
		teamRelDist[i] = teamRelPos[i].abs();
		if (teamRelDist[i] < 1)
      teamRelDist[i] = 1;
    teamValidity[i] =
      playerPoseCollection.getOwnPlayerPose(i).getValidity();
    if (teamValidity[i] < 0)
      teamValidity[i] = 0;
    if (teamValidity[i] > 1)
      teamValidity[i] = 1;
	}

  //ballValidity = ballPosition.validity;

  ballValidity = 1.0;

/*
  // this can be used to handle a variing (jumping) ball validity

  ballBase = int(floor(1000.0 * ballPosition.validity));
  ballAct  = int(floor(1000.0 * ballPosition.validity)); 
  ballBase.trigger();
  ballAct.trigger();
  
  if ((ballAct < ballBase / 5) || (ballAct == 0))
  {
    ballValidity = 0.0;
  }
  else
  {
    ballValidity = 1.0;
  }
*/

/*
  if (ballValidity < 0)
    ballValidity = 0;
  if (ballValidity > 1)
    ballValidity = 1;
*/
  //ballMotionValidity = ballPosition.motionValidity;
  ballMotionValidity = 0.0;
  if (ballMotionValidity < 0)
    ballMotionValidity = 0;
  if (ballMotionValidity > 1)
    ballMotionValidity = 1;
  ballSpeed = ballPosition.seen.speed.abs();

  for (i=0; i < numOfFieldPositions; ++i)
  {
    switch (i) {
      case Ball :
      {
        fieldPosData[i].absPos.x = ballPosition.getKnownPosition(1500).x;
        fieldPosData[i].absPos.y = ballPosition.getKnownPosition(1500).y;
        fieldPosData[i].maxDist  = 49.93;
      } break;
      case NextBall :
      {
        fieldPosData[i].absPos.x = fieldPosData[Ball].absPos.x + ballPosition.seen.speed.x;  
        fieldPosData[i].absPos.y = fieldPosData[Ball].absPos.y + ballPosition.seen.speed.y;
        fieldPosData[i].maxDist  = 49.93;
      } break;
      case FrontLeft :
      {
        fieldPosData[i].absPos.x = 1400;  
        fieldPosData[i].absPos.y =  900;
        fieldPosData[i].maxDist  = 41.61;
      } break;
      case FrontPenLeft :
      {
        fieldPosData[i].absPos.x = 1500;  
        fieldPosData[i].absPos.y =  600;
        fieldPosData[i].maxDist  = 40.95;
      } break;
      case FrontMiddle :
      {
        fieldPosData[i].absPos.x = 1400;  
        fieldPosData[i].absPos.y =    0;
        fieldPosData[i].maxDist  = 37.52;
      } break;
      case FrontPenRight :
      {
        fieldPosData[i].absPos.x = 1500;  
        fieldPosData[i].absPos.y = -600;
        fieldPosData[i].maxDist  = 40.95;
      } break;
      case FrontRight :
      {
        fieldPosData[i].absPos.x = 1400;  
        fieldPosData[i].absPos.y = -900;
        fieldPosData[i].maxDist  = 41.61;
      } break;
      case MiddleLeft :
      {
        fieldPosData[i].absPos.x =    0;  
        fieldPosData[i].absPos.y =  900;
        fieldPosData[i].maxDist  = 30.78;
      } break;
      case Middle :
      {
        fieldPosData[i].absPos.x =    0;  
        fieldPosData[i].absPos.y =    0;
        fieldPosData[i].maxDist  = 24.97;
      } break;
      case MiddleRight :
      {
        fieldPosData[i].absPos.x =    0;  
        fieldPosData[i].absPos.y = -900;
        fieldPosData[i].maxDist  = 30.78;
      } break;
      case BehindLeft :
      {
        fieldPosData[i].absPos.x = -1400;  
        fieldPosData[i].absPos.y =   900;
        fieldPosData[i].maxDist  = 41.61;
      } break;
      case BehindMiddle :
      {
        fieldPosData[i].absPos.x = -1000;  
        fieldPosData[i].absPos.y =     0;
        fieldPosData[i].maxDist  = 37.52;
      } break;
      case BehindRight :
      {
        fieldPosData[i].absPos.x = -1400;  
        fieldPosData[i].absPos.y =  -900;
        fieldPosData[i].maxDist  = 41.61;
      } break;
      case OwnGoal :
      {
        fieldPosData[i].absPos.x = -2000;  
        fieldPosData[i].absPos.y =     0;
        fieldPosData[i].maxDist  = 44.12;
      } break;
      case OpponentGoal :
      {
        fieldPosData[i].absPos.x =  2100;  
        fieldPosData[i].absPos.y =     0;
        fieldPosData[i].maxDist  = 44.12;
      } break;
      case Teammate1 :
      {
        fieldPosData[i].absPos.x = playerPoseCollection.getOwnPlayerPose(0).getPose().translation.x;  
        fieldPosData[i].absPos.y = playerPoseCollection.getOwnPlayerPose(0).getPose().translation.y;
        fieldPosData[i].maxDist  = 49.93;
      } break;
      case Teammate2 :
      {
        fieldPosData[i].absPos.x = playerPoseCollection.getOwnPlayerPose(1).getPose().translation.x;  
        fieldPosData[i].absPos.y = playerPoseCollection.getOwnPlayerPose(1).getPose().translation.y;
        fieldPosData[i].maxDist  = 49.93;
      } break;
      case Teammate3 :
      {
        fieldPosData[i].absPos.x = playerPoseCollection.getOwnPlayerPose(2).getPose().translation.x;  
        fieldPosData[i].absPos.y = playerPoseCollection.getOwnPlayerPose(2).getPose().translation.y;
        fieldPosData[i].maxDist  = 49.93;
      } break;
      case Intercept1 :
      {
        fieldPosData[i].absPos.x = (playerPoseCollection.getOpponentPlayerPose(0).getPose().translation.x
                                    + fieldPosData[OwnGoal].absPos.x) / 2;  
        fieldPosData[i].absPos.y = (playerPoseCollection.getOpponentPlayerPose(0).getPose().translation.y
                                    + fieldPosData[OwnGoal].absPos.y) / 2;
        fieldPosData[i].maxDist  = 29.18;
      } break;
      case Intercept2 :
      {
        fieldPosData[i].absPos.x = (playerPoseCollection.getOpponentPlayerPose(1).getPose().translation.x
                                    + fieldPosData[OwnGoal].absPos.x) / 2;  
        fieldPosData[i].absPos.y = (playerPoseCollection.getOpponentPlayerPose(1).getPose().translation.y
                                    + fieldPosData[OwnGoal].absPos.y) / 2;
        fieldPosData[i].maxDist  = 29.18;
      } break;
      case Intercept3 :  
      {
        fieldPosData[i].absPos.x = (playerPoseCollection.getOpponentPlayerPose(2).getPose().translation.x
                                    + fieldPosData[OwnGoal].absPos.x) / 2;  
        fieldPosData[i].absPos.y = (playerPoseCollection.getOpponentPlayerPose(2).getPose().translation.y
                                    + fieldPosData[OwnGoal].absPos.y) / 2;
        fieldPosData[i].maxDist  = 29.18;
      } break;
      case Intercept4 :
      {
        fieldPosData[i].absPos.x = (playerPoseCollection.getOpponentPlayerPose(3).getPose().translation.x
                                    + fieldPosData[OwnGoal].absPos.x) / 2;  
        fieldPosData[i].absPos.y = (playerPoseCollection.getOpponentPlayerPose(3).getPose().translation.y
                                    + fieldPosData[OwnGoal].absPos.y) / 2;
        fieldPosData[i].maxDist  = 29.18;
      } break;
      case InterceptBall :
      {
        fieldPosData[i].absPos.x = ((fieldPosData[Ball].absPos.x - 2100) / 2);  
        fieldPosData[i].absPos.y = ( fieldPosData[Ball].absPos.y / 2);  
        fieldPosData[i].maxDist  = 49.93;
      } break;
      case GoaliePos :
      {
        fieldPosData[i].absPos.x = fieldPosData[Ball].absPos.x - (-2300);  
        fieldPosData[i].absPos.y = fieldPosData[Ball].absPos.y - 0;  
        fieldPosData[i].absPos = fieldPosData[i].absPos.normalize() * 500;
        fieldPosData[i].absPos.x += -2300;
        if (fieldPosData[i].absPos.x < -2000)
          fieldPosData[i].absPos.x = -2000;
        fieldPosData[i].maxDist  = 49.93;
      } break;
      case CatenaccioLeft :
      {
        fieldPosData[i].absPos.x = -1500;  
        fieldPosData[i].absPos.y =   600;
        fieldPosData[i].maxDist  = 40.95;
      } break;
      case CatenaccioMiddle :
      {
        fieldPosData[i].absPos.x = -1400;  
        fieldPosData[i].absPos.y =     0;
        fieldPosData[i].maxDist  = 37.52;
      } break;
      case CatenaccioRight :
      {
        fieldPosData[i].absPos.x = -1500;  
        fieldPosData[i].absPos.y =  -600;
        fieldPosData[i].maxDist  = 40.95;
      } break;
	    case PenaltyPoint :
      {
        fieldPosData[i].absPos.x = 1800;  
        fieldPosData[i].absPos.y =  0;
        fieldPosData[i].maxDist  = 41.28;
      } break;
      case ToFront :
      {
        fieldPosData[i].absPos.x = robotPose.translation.x + 2000;  
        fieldPosData[i].absPos.y = robotPose.translation.y;
        fieldPosData[i].maxDist  = 49.93;
        if (fieldPosData[i].absPos.x > 2100)
          fieldPosData[i].absPos.x = 2100;
      } break;
      case MiddleAtBall :
      {
        fieldPosData[i].absPos.x = 0;  
        if (fabs(fieldPosData[Ball].absPos.y) > 950)
          fieldPosData[i].absPos.y = sgn(fieldPosData[Ball].absPos.y)*950;
        else
        fieldPosData[i].absPos.y = fieldPosData[Ball].absPos.y;
        fieldPosData[i].maxDist  = 37.49;
      } break;
      case FrontAtBall :
      {
        fieldPosData[i].absPos.x =  1250 - (1-((fieldPosData[Ball].absPos.x+2100) / 4200))*500;  
        if (fabs(fieldPosData[Ball].absPos.y) > 950)
          fieldPosData[i].absPos.y = sgn(fieldPosData[Ball].absPos.y)*950;
        else
          fieldPosData[i].absPos.y = fieldPosData[Ball].absPos.y;
        fieldPosData[i].maxDist  = 43.03;
      } break;
      case BehindAtBall :
      {
        fieldPosData[i].absPos.x = max(-1250,-1250 + ((fieldPosData[Ball].absPos.x) / 2100)*1000);  
        if (fabs(fieldPosData[Ball].absPos.y) > 950)
          fieldPosData[i].absPos.y = sgn(fieldPosData[Ball].absPos.y)*950;
        else
          fieldPosData[i].absPos.y = fieldPosData[Ball].absPos.y;
        fieldPosData[i].maxDist  = 43.03;
      } break;
      case RightAtBall :
      {
        fieldPosData[i].absPos.x = fieldPosData[Ball].absPos.x;  
        fieldPosData[i].absPos.y = -1000;
        fieldPosData[i].maxDist  = 48.13;
      } break;
      case LeftAtBall :
      {
        fieldPosData[i].absPos.x = fieldPosData[Ball].absPos.x;  
        fieldPosData[i].absPos.y = 1000;
        fieldPosData[i].maxDist  = 48.13;
      } break;
    }
    fieldPosData[i].relPos.x = fieldPosData[i].absPos.x - robotPose.translation.x;  
    fieldPosData[i].relPos.y = fieldPosData[i].absPos.y - robotPose.translation.y;
    fieldPosData[i].relDist    = fieldPosData[i].relPos.abs();
    if (fieldPosData[i].relDist < 1)
      fieldPosData[i].relDist = 1;
    fieldPosData[i].distRating = 100 - (int)(fieldPosData[i].relDist /
                                             fieldPosData[i].maxDist);
    if (fieldPosData[i].distRating < 0)
      fieldPosData[i].distRating = 0;
    fieldPosData[i].relOrient = ((fieldPosData[i].relPos.x*robotOrient.x +
		                              fieldPosData[i].relPos.y*robotOrient.y  )/
		                             (fieldPosData[i].relDist * robotODist)     ) + 1;
    fieldPosData[i].relAngle = toDegrees(Geometry::angleTo(robotPose,fieldPosData[i].absPos));

    fieldPosData[i].enemyFact1 = 1.0;
    fieldPosData[i].enemyFact2 = 1.0;
    double tmpd;
	  for (j=0; j < playerPoseCollection.numberOfOpponentPlayers; ++j)
		  if ( (((fieldPosData[i].relPos.x*enemyRelPos[j].x +
		          fieldPosData[i].relPos.y*enemyRelPos[j].y  )/
		         (fieldPosData[i].relDist * enemyRelDist[j])   ) + 1 > 1.97) &&
				     (enemyRelDist[j] < fieldPosData[i].relDist + 300) )
		  {
			  tmpd = enemyRelDist[j] / 2000;
			  if (tmpd > 1)
				  tmpd = 1;
        if (tmpd < 0.5) // don't reduce the rating more than half
          tmpd = 0.5;
        fieldPosData[i].enemyFact1 = (   enemyValidity[j] * (fieldPosData[i].enemyFact1 * tmpd)) +
                                     ((1-enemyValidity[j])*  fieldPosData[i].enemyFact1);
        if (enemyRelDist[j] < fieldPosData[i].relDist)
          fieldPosData[i].enemyFact2 = (   enemyValidity[j] * (fieldPosData[i].enemyFact2 * tmpd)) +
                                       ((1-enemyValidity[j])*  fieldPosData[i].enemyFact2);
		  }
    fieldPosData[i].teamFact1 = 1.0;
    fieldPosData[i].teamFact2 = 1.0;
	  for (j=0; j < playerPoseCollection.numberOfOwnPlayers; ++j)
		  if ( (((fieldPosData[i].relPos.x*teamRelPos[j].x +
		          fieldPosData[i].relPos.y*teamRelPos[j].y  )/
		         (fieldPosData[i].relDist * teamRelDist[j])   ) + 1 > 1.97) &&
				     (teamRelDist[j] < fieldPosData[i].relDist + 300) )
		  {
			  tmpd = teamRelDist[j] / 2000;
			  if (tmpd > 1)
				  tmpd = 1;
        if (tmpd < 0.5) // don't reduce the rating more than half
          tmpd = 0.5;
        fieldPosData[i].teamFact1 = (   teamValidity[j] * (fieldPosData[i].teamFact1 * tmpd)) +
                                    ((1-teamValidity[j])*  fieldPosData[i].teamFact1);
        if (enemyRelDist[j] < fieldPosData[i].relDist)
          fieldPosData[i].teamFact2 = (   teamValidity[j] * (fieldPosData[i].teamFact2 * tmpd)) +
                                      ((1-teamValidity[j])*  fieldPosData[i].teamFact2);
		  }
  }
  OrientDiff = fieldPosData[Ball].relOrient - fieldPosData[NextBall].relOrient;
  
	for (i=0; i < playerPoseCollection.numberOfOwnPlayers; ++i) {
		interceptRelPos[i].x = 	
				playerPoseCollection.getOwnPlayerPose(i).getPose().translation.x - 
				fieldPosData[InterceptBall].absPos.x;
		interceptRelPos[i].y = 	
				playerPoseCollection.getOwnPlayerPose(i).getPose().translation.y - 
				fieldPosData[InterceptBall].absPos.y;
		interceptRelDist[i] = interceptRelPos[i].abs();
	}


  for (i=0; i < numOfKickTimes; ++i) {
    kickTimeFact[i] = 1.0;
    double distfact;
    int testdist = (i * 250);
	  for (j=0; j < playerPoseCollection.numberOfOpponentPlayers; ++j)
		  if ( enemyRelDist[j] < testdist)
        kickTimeFact[i] = 0.0;
      else
		  {
			  distfact = (enemyRelDist[j]-testdist) / testdist;
			  if (distfact > 1)
				  distfact = 1;
        kickTimeFact[i] *= distfact;
		  }
  }

  // some stuff for the doJumpDefend...
  jumpDefendRating = 0;
  jumpLeftRating   = 0;
  jumpRightRating  = 0;
  if ((fieldPosData[Ball].relDist > defendZone1Border) && (fieldPosData[Ball].relDist < defendZone2Border))
  { 
    ballSensedPos = fieldPosData[Ball].absPos;

    ballSensedRelPos = fieldPosData[Ball].relPos;
    if ((fieldPosData[Ball].relAngle > -90) && (fieldPosData[Ball].relAngle <= 90))
      ballSensedTime = SystemCall::getCurrentSystemTime();
  }

  if (fieldPosData[Ball].relDist > defendZone3Border) {
    freshDefend  = true;
  }

  if (    (fieldPosData[Ball].relAngle > -90)
       && (fieldPosData[Ball].relAngle <  90)
       && (fieldPosData[Ball].relDist  <  defendZone1Border)
       && (freshDefend == true))
  {
    freshDefend = false;
    if (    (SystemCall::getCurrentSystemTime() - ballSensedTime <  speedTrigger)
         && (ballSensedRelPos.x - fieldPosData[Ball].relPos.x  >= 1)
         && (( fabs((ballSensedRelPos.x - fieldPosData[Ball].relPos.x) -
                    (ballSensedPos.x    - fieldPosData[Ball].absPos.x)   ) < ballHasMovedThreshold)
             ||
             ( fabs((ballSensedRelPos.y - fieldPosData[Ball].relPos.y) -
                    (ballSensedPos.y    - fieldPosData[Ball].absPos.y)   ) < ballHasMovedThreshold) ) )
    {
      if ((robotPose.translation.y > -100) && (robotPose.translation.y < 100))
    {
      double side;
      side = ballSensedRelPos.y + (ballSensedRelPos.x / (fieldPosData[Ball].relPos.x - ballSensedRelPos.x))*(fieldPosData[Ball].relPos.y - ballSensedRelPos.y);
      if ((side > -150) && (side < 150))
        jumpDefendRating = 100;
      else if ((side > -500) && (side <= -150))
        jumpRightRating = 100;
      else if ((side >= 150) && (side < 500))
        jumpLeftRating = 100;
      } else {
        if (robotPose.translation.y >= 100)
          jumpRightRating = 100;
        else 
          jumpLeftRating = 100;
      }

    }
  }

#else
  if (ocstate == dtt_initial)
  {
    /*
    ocrating[0] = (int)min(robotPose.translation.y/9+400/3,-(robotPose.translation.y/9)+200/3);
    ocrating[1] = (int)(-1*robotPose.translation.y*robotPose.translation.y*robotPose.translation.y*100/(1200*1200*1200));
    ocrating[2] = (int)min(-robotPose.translation.y/9+400/3,robotPose.translation.y/9+200/3);
    ocrating[3] = (int)(robotPose.translation.y*robotPose.translation.y*robotPose.translation.y*100/(1200*1200*1200));
*/    //hier mac eintragen
 /*   if (getPlayer().getPlayerNumber()==Player::five)
        ocrating[4] = 100;
    else
        ocrating[4] = 10;
*/
 /*   unsigned char smac[6];
    unsigned char tmac[6];
    tmac[0] = 0x00;
    tmac[1] =   0x10;
    tmac[2] =     0xC6;
    tmac[3] =       0x24;
    tmac[4] =         0x4A;
    tmac[5] =           0xB2;
    SystemCall::getMacAddress(smac);
    if (memcmp(tmac, smac,6)==0)
      ocrating[4] = 100;
    else
      ocrating[4] = 10;

    

    for(int i=0; i<5;++i)
    {
      if (ocrating[i]>100)
        ocrating[i] = 100;
      if (ocrating[i]<10)
        ocrating[i] = 10;
    }
    */
    ocrating[0] = 0;
    ocrating[1] = 0;
    ocrating[2] = 0;
    ocrating[3] = 0;
    ocrating[4] = 0;
    ocrating[getPlayer().getPlayerNumber()] = 100;
/*
    RateableOptions::OptionID option = ((DefaultTacticChooser*)actualTacticChooser)->ocplayerrole[j];
  if ((option == RateableOptions::gotoBitePos1)
    ||(option == RateableOptions::bitePos1)
    ||(option == RateableOptions::movePos1)
    )
    openChallengeSymbols.bitePointToUse[j] = BitePoint::frontleft;
  if ((option == RateableOptions::gotoBitePos2)
    ||(option == RateableOptions::bitePos2)
    ||(option == RateableOptions::movePos2)
    )
    openChallengeSymbols.bitePointToUse[j] = BitePoint::frontright;
  if ((option == RateableOptions::gotoBitePos3)
    ||(option == RateableOptions::bitePos3)
    ||(option == RateableOptions::movePos3)
    )
    openChallengeSymbols.bitePointToUse[j] = BitePoint::behindleft;
  if ((option == RateableOptions::gotoBitePos4)
    ||(option == RateableOptions::bitePos4)
    ||(option == RateableOptions::movePos4)
    )
    openChallengeSymbols.bitePointToUse[j] = BitePoint::behindright;
  if ((option == RateableOptions::gotoBridge)
    ||(option == RateableOptions::climbBridge)
    ||(option == RateableOptions::moveBridge)
    )
    {
      openChallengeSymbols.bitePointToUse[j] = BitePoint::master;
      openChallengeSymbols.masterDog = j;
    }

  }else{
    */}

#endif

}

// used in rateOptions();
int DefaultOptionRating::getGoToFieldPosRating(FieldPositions fpos)
{

	// if we are (in a 25cm range) at fpos, we return best rating
	if (fieldPosData[fpos].relDist < 250)
		return 100;

  int tmpRating = fieldPosData[fpos].distRating;

	// taking the rotation with 40 % into account and fading this
	// to 0 % at the target position.

  // changed this to 20%
  tmpRating = (int)( (tmpRating * (fieldPosData[fpos].relOrient / 2)) * (0.0020*(100-tmpRating)) +
  		                tmpRating * (0.80 + (0.0020*tmpRating)) );

#ifndef NO_ENEMY_RATING
  // take possible enemys into account...
  // for each enemy on your way nearer 2m reduce Rating...
  tmpRating = (int)(tmpRating * fieldPosData[fpos].enemyFact1);
#endif
				
#ifndef NO_TEAMMATE_RATING
  // take possible team-mates into account...
  // for each team-mate  on your way nearer 2m reduce Rating...
  tmpRating = (int)(tmpRating * fieldPosData[fpos].teamFact1);
#endif

  return tmpRating;
}

int DefaultOptionRating::getKickToTeammateRating(int mate)
{
  int tmpRating = 0;
  if (mate <= playerPoseCollection.numberOfOwnPlayers)
  {
    // using the goToPosRating here
    switch (mate) {
      case 1 : tmpRating =  getGoToFieldPosRating(Teammate1); break;
      case 2 : tmpRating =  getGoToFieldPosRating(Teammate2); break;
      case 3 : tmpRating =  getGoToFieldPosRating(Teammate3); break;
    }
    
    // now modifiy the rating

    // if the teammate stands more than 50cm behind me rate down to 1m behind me
    double profront = 1.0;
    if (teamRelPos[mate-1].x < -500)
    {
      profront = (teamRelPos[mate-1].x+500) / -500;
      if (profront > 1)
        profront = 1;
      profront = 1 - profront;
    }

    // if i'm more than 30cm away from the ball, rate down to a distance of 1m
    double ballfact = 1.0;
    if (fieldPosData[Ball].relDist > 150)
    {
      ballfact =(fieldPosData[Ball].relDist-150) / 100;
      if (ballfact > 1)
        ballfact = 1;
      ballfact = 1 - ballfact;
    }

    // if the teammate is closer than 1m to me, rate down between 1m and 50cm
    double distfact = 1.0;
    if (teamRelDist[mate-1] < 1000)
    {
      distfact = (teamRelDist[mate-1]-500) / 500; 
      if (distfact < 0)
        distfact = 0;
    }
    // mix it together and boost the whole thing a little bit
    tmpRating = (int)(1.75 * tmpRating * profront * ballfact * distfact * ballValidity);
    if (tmpRating > 100)
      tmpRating = 100;
    if (tmpRating < 0)
      tmpRating = 0;
  }
  return tmpRating;
}

int DefaultOptionRating::getSpecialKickToPosRating(int kickangle, int kickrange, KickTimes kicktime, FieldPositions fpos)
{
  // check some special ratings first
  switch (fpos) {
    case (Teammate1) : if (playerPoseCollection.numberOfOwnPlayers < 1) return 0; break;
    case (Teammate2) : if (playerPoseCollection.numberOfOwnPlayers < 2) return 0; break;
    case (Teammate3) : if (playerPoseCollection.numberOfOwnPlayers < 3) return 0; break;
  }
  // let's look if this kick is suitable for this distance
  double powerFact = kickrange / fieldPosData[fpos].relDist;
  if (powerFact > 1)
  { 
    // kick is more powerfull than we need, so rate between 1 and 3
	  if ((fpos == OpponentGoal) || (fpos == ToFront))
	    powerFact = 1;
	  else
        powerFact = 1-((powerFact - 1) / 2);
    
  } else {
    // kick is less powerfull than we need, so rate between 1 and 0.5
	  if (fpos == ToFront)
	    powerFact = 1;
	  else
      powerFact = (powerFact - 0.5) / 0.5;
  }
  if (powerFact < 0)
    powerFact = 0;

  // let's look at the kickangle...
//  double angleFact = 1 - fabs((fieldPosData[fpos].relAngle - kickangle) / 180); 
  // reducing the influence of anglefakt to 33%
  double angleFact = 1 - fabs((fieldPosData[fpos].relAngle - kickangle) / 540); 

  // is the ball near to us ?
  double ballFact = 1.0;
  if (fieldPosData[Ball].relDist > 100) // if the ball is farer than 10cm
  {
    ballFact = (fieldPosData[Ball].relDist-100) / 200; // rate down from 10cm to 30cm
    if (ballFact > 1)
      ballFact = 1;
    ballFact = 1 - ballFact; // in fact the inverse provides the correct rating *g*
  }
  // if it's unsure that the ball is in out range, rate down ballFact
  ballFact *=  ballValidity;

  // we should not kick to far backwards, especially when we are close to our
  // own goal...
  double preventFact = 1.0;
  // if we are near the Opponent-Goal, we can kick 0.5m backwards without being
  // rated down, reducing this range to 0 by getting closer to own goal..
  if (fieldPosData[fpos].relPos.x < -500*((robotPose.translation.x+2100)/4200) )
  {
    // rate down, if we have to shoot to far backwards...
    preventFact = fabs(fieldPosData[fpos].relPos.x + 500) / 500;
    if (preventFact > 1)
      preventFact = 1;
    preventFact = 1-preventFact;
  }


  // we need an additional downrating is we are at the opponent-border and
  // we want to kick to the goal...
  double goalFact = 1.0;
  if ((fpos == OpponentGoal) &&
      (fieldPosData[fpos].relPos.x < 150) &&
      (fabs(fieldPosData[fpos].relPos.y) > 300))
  {
    goalFact = (fabs(fieldPosData[fpos].relPos.y)-300) / 1050;
    if (goalFact > 1)
      goalFact = 1;
    goalFact = 1 - goalFact;
  }

  // check the speed of the ball... a fast ball is unkickable *g*
  double speedFact = 1.0;
  if (ballSpeed > 150)
  {
    speedFact = ((ballSpeed-150) / 150);
    if (speedFact > 1)
      speedFact = 1;
    speedFact = 1 - speedFact;
  }
  // if the ballSpeed is valid, take it into account, else do not
  speedFact = (speedFact * ballMotionValidity) + (1 - ballMotionValidity);

  // mix all Factors together...
  int tmpRating = (int)(100 * powerFact * angleFact * 
                        ballFact * preventFact * goalFact *
                        kickTimeFact[kicktime] *  speedFact);

#ifndef NO_ENEMY_RATING

  tmpRating = (int)(tmpRating * fieldPosData[fpos].enemyFact2);

#endif

#ifndef NO_TEAMMATE_RATING

  tmpRating = (int)(tmpRating * fieldPosData[fpos].teamFact2);

#endif


  if (tmpRating > 100)
    tmpRating = 100;
  if (tmpRating < 0)
    tmpRating = 0;
  return tmpRating;
}

int DefaultOptionRating::getKickToPosRating(FieldPositions fpos)
{
  // check some special ratings first
  switch (fpos) {
    case (Teammate1) : if (playerPoseCollection.numberOfOwnPlayers < 1) return 0; break;
    case (Teammate2) : if (playerPoseCollection.numberOfOwnPlayers < 2) return 0; break;
    case (Teammate3) : if (playerPoseCollection.numberOfOwnPlayers < 3) return 0; break;
  }

  // is the ball near to us ?
  double ballFact = 1.0;
  if (fieldPosData[Ball].relDist > 200) // if the ball is farer than 20cm
  {
    ballFact = (fieldPosData[Ball].relDist-200) / 400; // rate down from 20cm to 60cm
    if (ballFact > 1)
      ballFact = 1;
    ballFact = 1 - ballFact; // in fact the inverse provides the correct rating *g*
  }
  // if it's unsure that the ball is in our range, rate down ballFact
  ballFact *=  ballValidity;

  // we should not kick to far backwards, especially when we are close to our
  // own goal...
  double preventFact = 1.0;
  // if we are near the Opponent-Goal, we can kick 0.5m backwards without being
  // rated down, reducing this range to 0 by getting closer to own goal..
  if (fieldPosData[fpos].relPos.x < -500*((robotPose.translation.x+2100)/4200) )
  {
    // rate down, if we have to shoot to far backwards...
    preventFact = fabs(fieldPosData[fpos].relPos.x + 500) / 500;
    if (preventFact > 1)
      preventFact = 1;
    preventFact = 1-preventFact;
  }


  // we need an additional downrating is we are at the opponent-border and
  // we want to kick to the goal...
  double goalFact = 1.0;
  if (playerPoseCollection.numberOfOwnPlayers == 3)
  {
  if ((fpos == OpponentGoal) &&
      (fieldPosData[fpos].relPos.x < 150) &&
      (fabs(fieldPosData[fpos].relPos.y) > 300))
  {
      goalFact = (fabs(fieldPosData[fpos].relPos.y)-300) / 2100; // we just want to downrate max 50%
    if (goalFact > 1)
      goalFact = 1;
    goalFact = 1 - goalFact;
  }
  }

  // check the speed of the ball... a fast ball is unkickable *g*
  double speedFact = 1.0;
  if (ballSpeed > 150)
  {
    speedFact = ((ballSpeed-150) / 150);
    if (speedFact > 1)
      speedFact = 1;
    speedFact = 1 - speedFact;
  }

  // if the ballSpeed is valid, take it into account, else do not
  speedFact = (speedFact * ballMotionValidity) + (1 - ballMotionValidity);

  // new! prefer straight kicks...
  double kickDirFact = 1.0;
  if (fieldPosData[fpos].relOrient < 1.5) // greater than ca. 60
  {
    kickDirFact = 0.8 + (0.2*(fieldPosData[fpos].relOrient/1.5)); // rate down to 80% if backwartskick is needed
  }

  //new! rate down if you didn't see the ball recently
  double lastSeenFact = 1.0;
  unsigned long notSeenFor = SystemCall::getCurrentSystemTime() - ballPosition.seen.timeWhenLastSeen;
  if (notSeenFor > 250)
  {
    lastSeenFact = ((notSeenFor-250)/2500);
    if (lastSeenFact > 0.5)
      lastSeenFact = 0.5;
    lastSeenFact = 1 - lastSeenFact;
  }

  // mix all Factors together...
  int tmpRating = (int)(100 * ballFact * preventFact * goalFact *
                        speedFact * kickDirFact * lastSeenFact);

#ifndef NO_ENEMY_RATING

  tmpRating = (int)(tmpRating * fieldPosData[fpos].enemyFact2);

#endif

#ifndef NO_TEAMMATE_RATING

  tmpRating = (int)(tmpRating * fieldPosData[fpos].teamFact2);

#endif


  if (tmpRating > 100)
    tmpRating = 100;
  if (tmpRating < 0)
    tmpRating = 0;

  if ((RateableOptions::getOptionType(chooserRaterInterfaces.lastChoosenOption) == RateableOptions::kickAction) &&
      (kickInProgress == true)) 
    tmpRating = 100;
  return tmpRating;
}


int DefaultOptionRating::getRollRating(int bdist, int bangle)
{
  // let's look if we are in the right position
  double distFact = bdist / fieldPosData[Ball].relDist;
  if (distFact > 1)
  { 
    // we are closer than we should, so rate down quite fast
    distFact = 1-(distFact - 1);

  } else {
    // we are "farer" than we should, rating down
    distFact = (distFact - 0.8) / 0.2;
  }
  if (distFact < 0)
    distFact = 0;

  double angleFact = bangle / fieldPosData[Ball].relAngle;
  if (angleFact > 1)
  { 
    // the relative angle of the ball is smaller
    angleFact = 1-(angleFact - 1);

  } else {
    // the relative angle of the ball is greater
    angleFact = (angleFact - 0.8) / 0.2;
  }
  if (angleFact < 0)
    angleFact = 0;

  return (int)(100*distFact*angleFact*ballValidity);
}

int DefaultOptionRating::getGoToBallRating(FieldPositions fpos, int goToBallRating)
{

//***********************************************************************************
  Vector2<double> tmp;
  // I'll think looking for the nextBall should be not too bad in here :-)
  //tmp.x = fieldPosData[NextBall].absPos.x - fieldPosData[fpos].absPos.x;
  //tmp.y = fieldPosData[NextBall].absPos.y - fieldPosData[fpos].absPos.y;

  //  If u don't like the stuff above, in-comment this stuff again
  //  And comment-out the stuff above (save calc-cycles *g*)
  tmp.x = fieldPosData[Ball].absPos.x - fieldPosData[fpos].absPos.x;
  tmp.y = fieldPosData[Ball].absPos.y - fieldPosData[fpos].absPos.y;
  
  
  double tmpdist = tmp.abs();
  double ballPosFact = 1.0;

  if (fpos != OwnGoal)
  {
  if (tmpdist > 450)
  {
    ballPosFact = (tmpdist - 450) / 600;
    if (ballPosFact > 1)
      ballPosFact = 1;
    ballPosFact = 1 - ballPosFact;
  }
  } else {
    if (tmpdist > 900)
    {
      ballPosFact = (tmpdist - 900) / 1300;
      if (ballPosFact > 1)
        ballPosFact = 1;
      ballPosFact = 1 - ballPosFact;
    }
  }

  return (int)(goToBallRating * ballPosFact);
}

int DefaultOptionRating::getKickFromRating(FieldPositions fpos, int kickRating)
{
  Vector2<double> tmp;
  tmp.x = fieldPosData[Ball].absPos.x - fieldPosData[fpos].absPos.x;
  tmp.y = fieldPosData[Ball].absPos.y - fieldPosData[fpos].absPos.y;
  double tmpdist = tmp.abs();
  double ballPosFact = 1.0;
  if (fpos != OwnGoal)
  {
    if (tmpdist > 500)
    {
      ballPosFact = (tmpdist - 500) / 600;
      if (ballPosFact > 1)
        ballPosFact = 1;
      ballPosFact = 1 - ballPosFact;
    }
  } else {
    if (tmpdist > 900)
    {
      ballPosFact = (tmpdist - 900) / 1300;
      if (ballPosFact > 1)
        ballPosFact = 1;
      ballPosFact = 1 - ballPosFact;
    }
  }
  return (int)(kickRating * ballPosFact);
}


void DefaultOptionRating::rateOptions()
{
  // Dann wird das unten nicht immer so 'ne Hammer Zeile bei jedem Eintrag...
  int tmpno = (int)(getPlayer().getPlayerNumber());
  if (tmpno != Player::undefinedPlayerNumber)
  {
	  SingleBeliefs& mySingleBeliefs = collectedBeliefs.singleBeliefs[tmpno];
    int i;
    if (gameControlData.data.state == ROBOCUP_STATE_PENALIZED)
    {
      for (i=0; i < RateableOptions::numOfOptions; ++i) 
        mySingleBeliefs.ratedOptions[i] = 0; 
    }
    else
    {
   
      // common calculations, that can be used in more than one Rating to
	    // reduce redundant calculations, the variables are deklared in the 
	    // header to enabled subroutines to read/write these variables...
      doPreCals();

    /***********************************************************************************/
      // rate all your options here ;-)
      // from 0 to 100; 0 is bad, 100 is good
      //
      for (i=0; i < RateableOptions::numOfOptions; ++i) {
        switch((RateableOptions::OptionID)i) {

          case RateableOptions::stand: 
            mySingleBeliefs.ratedOptions[i] = 100; 
            break;

          case RateableOptions::doNothing: 
            mySingleBeliefs.ratedOptions[i] = 100; 
            break;

          case RateableOptions::keepOption: 
            mySingleBeliefs.ratedOptions[i] = 100; 
            break;

    /***********************************************************************************/
    /* Movement ratings */
  #ifndef OPENCHALLENGE_DEFINES

          case RateableOptions::goToFrontLeft: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(FrontLeft);
            break;

          case RateableOptions::goToFrontPenLeft: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(FrontPenLeft);
            break;

          case RateableOptions::goToFrontMiddle: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(FrontMiddle);
            break;

          case RateableOptions::goToFrontPenRight: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(FrontPenRight);
            break;

          case RateableOptions::goToFrontRight: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(FrontRight);
            break;

          case RateableOptions::goToMiddleLeft: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(MiddleLeft);
            break;

          case RateableOptions::goToMiddle: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(Middle);
            break;

          case RateableOptions::goToMiddleRight: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(MiddleRight);
            break;

          case RateableOptions::goToBehindLeft: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(BehindLeft);
            break;

          case RateableOptions::goToBehindMiddle: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(BehindMiddle);
            break;

          case RateableOptions::goToBehindRight: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(BehindRight);
            break;

          case RateableOptions::goToCatenaccioLeft: 
            {
              int tmpRating = getGoToFieldPosRating(CatenaccioLeft);
              if (tmpRating < 1)
                tmpRating = 1;
              mySingleBeliefs.ratedOptions[i] = tmpRating;
            }
            break;

          case RateableOptions::goToCatenaccioMiddle: 
            {
              int tmpRating = getGoToFieldPosRating(CatenaccioMiddle);
              if (tmpRating < 1)
                tmpRating = 1;
              mySingleBeliefs.ratedOptions[i] = tmpRating;
            }
            break;

          case RateableOptions::goToCatenaccioRight: 
            {
              int tmpRating = getGoToFieldPosRating(CatenaccioRight);
              if (tmpRating < 1)
                tmpRating = 1;
              mySingleBeliefs.ratedOptions[i] = tmpRating;
            }
            break;

          case RateableOptions::approachCloseBall: 
            {
            int tmpRating = fieldPosData[Ball].distRating;

	          // taking the rotation with 40 % into account and fading this
	          // to 0 % at the target position.

            // changed this to 20%
            tmpRating = (int)( (tmpRating * (fieldPosData[Ball].relOrient / 2)) * 
					                     (0.0020*(100-tmpRating)) +
  		                         (tmpRating * (0.80 + (0.0020*tmpRating))) );

            // new! prefer walking to the ball in opponent goal direction...
            double walkDirFact = 1.0;
            if (fieldPosData[OpponentGoal].relOrient < 1.5) // greater than ca. 60
            {
              walkDirFact = 0.95 + (0.05*(fieldPosData[OpponentGoal].relOrient/1.5)); // rate down to 80% if backwartskick is needed
            }

            tmpRating = (int)(tmpRating * walkDirFact);

            //new! rate down if you didn't see the ball recently
            double lastSeenFact = 1.0;
            unsigned long notSeenFor = SystemCall::getCurrentSystemTime() - ballPosition.seen.timeWhenLastSeen;
            if (notSeenFor > 500)
            {
              lastSeenFact = ((notSeenFor-500)/2500);
              if (lastSeenFact > 0.5)
                lastSeenFact = 0.5;
              lastSeenFact = 1 - lastSeenFact;
            }

            tmpRating = (int)(tmpRating * lastSeenFact);

            #ifndef NO_ENEMY_RATING

            tmpRating = (int)(tmpRating * fieldPosData[Ball].enemyFact2);

            #endif

            #ifndef NO_TEAMMATE_RATING

            tmpRating = (int)(tmpRating * fieldPosData[Ball].teamFact2);

            #endif

            if (tmpRating < 1)
              tmpRating = 1;
            if (tmpRating > 100)
              tmpRating = 100;

				    mySingleBeliefs.ratedOptions[i] = (int)(ballValidity * tmpRating);
				    }
            break;

          case RateableOptions::goToBall: 
  			    mySingleBeliefs.ratedOptions[i] =
              mySingleBeliefs.ratedOptions[RateableOptions::approachCloseBall];

            break;

          case RateableOptions::goToBallFrontLeft: 
            mySingleBeliefs.ratedOptions[i] = 
              getGoToBallRating(FrontLeft,
                mySingleBeliefs.ratedOptions[RateableOptions::approachCloseBall]);
            break;

          case RateableOptions::goToBallFrontMiddle: 
            mySingleBeliefs.ratedOptions[i] = 
              getGoToBallRating(FrontMiddle,
                mySingleBeliefs.ratedOptions[RateableOptions::approachCloseBall]);
            break;

          case RateableOptions::goToBallFrontRight: 
            mySingleBeliefs.ratedOptions[i] = 
              getGoToBallRating(FrontRight,
                mySingleBeliefs.ratedOptions[RateableOptions::approachCloseBall]);
            break;

          case RateableOptions::goToBallMiddleLeft: 
            mySingleBeliefs.ratedOptions[i] = 
              getGoToBallRating(MiddleLeft,
                mySingleBeliefs.ratedOptions[RateableOptions::approachCloseBall]);
            break;

          case RateableOptions::goToBallMiddle: 
            mySingleBeliefs.ratedOptions[i] = 
              getGoToBallRating(Middle,
                mySingleBeliefs.ratedOptions[RateableOptions::approachCloseBall]);
            break;

          case RateableOptions::goToBallMiddleRight: 
            mySingleBeliefs.ratedOptions[i] = 
              getGoToBallRating(MiddleRight,
                mySingleBeliefs.ratedOptions[RateableOptions::approachCloseBall]);
            break;

          case RateableOptions::goToBallBehindLeft: 
            mySingleBeliefs.ratedOptions[i] = 
              getGoToBallRating(BehindLeft,
                mySingleBeliefs.ratedOptions[RateableOptions::approachCloseBall]);
            break;

          case RateableOptions::goToBallBehindMiddle: 
            mySingleBeliefs.ratedOptions[i] = 
              getGoToBallRating(BehindMiddle,
                mySingleBeliefs.ratedOptions[RateableOptions::approachCloseBall]);
            break;

          case RateableOptions::goToBallBehindRight: 
            mySingleBeliefs.ratedOptions[i] = 
              getGoToBallRating(BehindRight,
                mySingleBeliefs.ratedOptions[RateableOptions::approachCloseBall]);
            break;

          case RateableOptions::goToBallGoalie: 
            mySingleBeliefs.ratedOptions[i] =
              getGoToBallRating(OwnGoal,
                mySingleBeliefs.ratedOptions[RateableOptions::approachCloseBall]);
            break;

          case RateableOptions::goIntoOwnGoal: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(OwnGoal);
            break;

          case RateableOptions::doJumpDefend: 
            mySingleBeliefs.ratedOptions[i] = jumpDefendRating;
            break;

          case RateableOptions::doJumpLeft: 
            mySingleBeliefs.ratedOptions[i] = jumpLeftRating;
            break;

          case RateableOptions::doJumpRight: 
            mySingleBeliefs.ratedOptions[i] = jumpRightRating;
            break;

          case RateableOptions::kickToGoal: 
            {
              int tmpRating = getKickToPosRating(OpponentGoal);
              if (tmpRating < 1)
                tmpRating = 1;
              mySingleBeliefs.ratedOptions[i] = tmpRating;
            }
            break;

          case RateableOptions::kickToGoalFromFrontLeft: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(FrontLeft,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToGoal]);
            break;

          case RateableOptions::kickToGoalFromFrontMiddle: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(FrontMiddle,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToGoal]);
            break;
		    
          case RateableOptions::kickToGoalFromFrontRight: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(FrontRight,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToGoal]);
            break;

          case RateableOptions::kickToGoalFromMiddleLeft: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(MiddleLeft,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToGoal]);
            break;

          case RateableOptions::kickToGoalFromMiddle: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(Middle,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToGoal]);
            break;

          case RateableOptions::kickToGoalFromMiddleRight: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(MiddleRight,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToGoal]);
            break;

          case RateableOptions::kickToGoalFromBehindLeft: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(BehindLeft,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToGoal]);
            break;
		    
          case RateableOptions::kickToGoalFromBehindMiddle: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(BehindMiddle,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToGoal]);
            break;

          case RateableOptions::kickToGoalFromBehindRight: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(BehindRight,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToGoal]);
            break;

          case RateableOptions::kickToTeammate1: 
            mySingleBeliefs.ratedOptions[i] = getKickToPosRating(Teammate1);
            break;

          case RateableOptions::kickToTeammate2: 
            mySingleBeliefs.ratedOptions[i] = getKickToPosRating(Teammate2);
            break;

          case RateableOptions::kickToTeammate3: 
            mySingleBeliefs.ratedOptions[i] = getKickToPosRating(Teammate3);
            break;

          case RateableOptions::kickToClear: 
            mySingleBeliefs.ratedOptions[i] = getKickToPosRating(ToFront);
            break;

          case RateableOptions::kickToClearFromFrontLeft: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(FrontLeft,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToClear]);
            break;

          case RateableOptions::kickToClearFromFrontMiddle: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(FrontMiddle,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToClear]);
            break;

          case RateableOptions::kickToClearFromFrontRight: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(FrontRight,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToClear]);
            break;

          case RateableOptions::kickToClearFromMiddleLeft: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(MiddleLeft,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToClear]);
            break;

          case RateableOptions::kickToClearFromMiddle: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(Middle,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToClear]);
            break;

          case RateableOptions::kickToClearFromMiddleRight: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(MiddleRight,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToClear]);
            break;

          case RateableOptions::kickToClearFromBehindLeft: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(BehindLeft,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToClear]);
            break;

          case RateableOptions::kickToClearFromBehindMiddle: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(BehindMiddle,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToClear]);
            break;

          case RateableOptions::kickToClearFromBehindRight: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(BehindRight,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToClear]);
            break;

          case RateableOptions::kickToClearGoalie: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(OwnGoal,
                mySingleBeliefs.ratedOptions[RateableOptions::kickToClear]);
            break;

          case RateableOptions::newKickToGoal: 
            mySingleBeliefs.ratedOptions[i] =
              mySingleBeliefs.ratedOptions[RateableOptions::kickToGoal];
            break;

          case RateableOptions::newKickToGoalFromFrontLeft: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(FrontLeft,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToGoal]);
            break;

          case RateableOptions::newKickToGoalFromFrontMiddle: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(FrontMiddle,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToGoal]);
            break;

          case RateableOptions::newKickToGoalFromFrontRight: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(FrontRight,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToGoal]);
            break;

          case RateableOptions::newKickToGoalFromMiddleLeft: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(MiddleLeft,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToGoal]);
            break;

          case RateableOptions::newKickToGoalFromMiddle: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(Middle,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToGoal]);
            break;

          case RateableOptions::newKickToGoalFromMiddleRight: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(MiddleRight,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToGoal]);
            break;

          case RateableOptions::newKickToGoalFromBehindLeft: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(BehindLeft,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToGoal]);
            break;

          case RateableOptions::newKickToGoalFromBehindMiddle: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(BehindMiddle,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToGoal]);
            break;

          case RateableOptions::newKickToGoalFromBehindRight: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(BehindRight,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToGoal]);
            break;

          case RateableOptions::newKickToTeammate1: 
            mySingleBeliefs.ratedOptions[i] =
              mySingleBeliefs.ratedOptions[RateableOptions::kickToTeammate1];
            break;

          case RateableOptions::newKickToTeammate2: 
            mySingleBeliefs.ratedOptions[i] =
              mySingleBeliefs.ratedOptions[RateableOptions::kickToTeammate2];
            break;

          case RateableOptions::newKickToTeammate3: 
            mySingleBeliefs.ratedOptions[i] =
              mySingleBeliefs.ratedOptions[RateableOptions::kickToTeammate3];
            break;

          case RateableOptions::newKickToClear: 
            mySingleBeliefs.ratedOptions[i] =
              mySingleBeliefs.ratedOptions[RateableOptions::kickToClear];
            break;

          case RateableOptions::newKickToClearFromFrontLeft: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(FrontLeft,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToClear]);
            break;

          case RateableOptions::newKickToClearFromFrontMiddle: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(FrontMiddle,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToClear]);
            break;

          case RateableOptions::newKickToClearFromFrontRight: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(FrontRight,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToClear]);
            break;

          case RateableOptions::newKickToClearFromMiddleLeft: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(MiddleLeft,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToClear]);
            break;

          case RateableOptions::newKickToClearFromMiddle: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(Middle,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToClear]);
            break;

          case RateableOptions::newKickToClearFromMiddleRight: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(MiddleRight,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToClear]);
            break;

          case RateableOptions::newKickToClearFromBehindLeft: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(BehindLeft,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToClear]);
            break;

          case RateableOptions::newKickToClearFromBehindMiddle: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(BehindMiddle,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToClear]);
            break;

          case RateableOptions::newKickToClearFromBehindRight: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(BehindRight,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToClear]);
            break;

          case RateableOptions::newKickToClearGoalie: 
            mySingleBeliefs.ratedOptions[i] =
              getKickFromRating(OwnGoal,
                mySingleBeliefs.ratedOptions[RateableOptions::newKickToClear]);
            break;

          case RateableOptions::intercept1: 
            {
              if (playerPoseCollection.numberOfOpponentPlayers >= 1)
                mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(Intercept1);
              else
                mySingleBeliefs.ratedOptions[i] = 0;
				    }
            break;

          case RateableOptions::intercept2: 
            {
              if (playerPoseCollection.numberOfOpponentPlayers >= 2)
                mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(Intercept2);
              else
                mySingleBeliefs.ratedOptions[i] = 0;
				    }
            break;

          case RateableOptions::intercept3: 
            {
              if (playerPoseCollection.numberOfOpponentPlayers >= 3)
                mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(Intercept3);
              else
                mySingleBeliefs.ratedOptions[i] = 0;
				    }
            break;

          case RateableOptions::intercept4: 
            {
              if (playerPoseCollection.numberOfOpponentPlayers >= 4)
                mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(Intercept4);
              else
                mySingleBeliefs.ratedOptions[i] = 0;
				    }
            break;

          case RateableOptions::handleBallLeftBorder: 
            {
              if (fieldPosData[Ball].absPos.y > 1200)
                mySingleBeliefs.ratedOptions[i] = mySingleBeliefs.ratedOptions[RateableOptions::approachCloseBall];
              else
                mySingleBeliefs.ratedOptions[i] = 0;
				    }
            break;

          case RateableOptions::handleBallRightBorder: 
            {
              if (fieldPosData[Ball].absPos.y < -1200)
                mySingleBeliefs.ratedOptions[i] = mySingleBeliefs.ratedOptions[RateableOptions::approachCloseBall];
              else
                mySingleBeliefs.ratedOptions[i] = 0;
				    }
            break;

          case RateableOptions::dribbleToFront: 
            {
              int tmpRating = 100;
              // if i'm more than 20cm away from the ball, rate down to a distance of 50cm
              double ballfact = 1.0;
              if (fieldPosData[Ball].relDist > 200)
              {
                ballfact = fieldPosData[Ball].relDist / 500;
                if (ballfact > 1)
                  ballfact = 1;
                ballfact = 1 - ballfact;
              }

              double enemyfact = 1.0;
              double distfact;
	            for (int j=0; j < playerPoseCollection.numberOfOpponentPlayers; ++j)
		            if ( enemyRelDist[j] < 700)
                  enemyfact = 0.0;
                else
		            {
			            distfact = (enemyRelDist[j]-700) / 700;
			            if (distfact > 1)
				            distfact = 1;
                  enemyfact *= distfact;
		            }
              mySingleBeliefs.ratedOptions[i] = (int)(tmpRating * ballfact * enemyfact);
				    }
            break;

          case RateableOptions::goToInterceptBall: 
            {
			        // ad hoc calculation, DO NOT USE!
                    // mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(InterceptBall);
			        // break;
			        // OUTPUT(idText, text, "goToInterceptBall: " << mySingleBeliefs.ratedOptions[i]);

			        // Here follows a more sophisticated calculation...
			        if (fieldPosData[Ball].absPos.x > 0) {
				        // Ball in opponent half: no need for interception
				        mySingleBeliefs.ratedOptions[i] = 0;
			        }
			        else 
			        if (fieldPosData[Ball].absPos.x <=0 &&
				          robotPose.translation.x > 0) {
				        // Ball in own half, but robot in opponent half: interception is nonsense
				        mySingleBeliefs.ratedOptions[i] = 0;
			        }
			        else
			        if (fieldPosData[Ball].relDist < fieldPosData[InterceptBall].relDist) {
				        // Robot is closer to Ball than to InterceptPos: better go to ball instead
				        mySingleBeliefs.ratedOptions[i] = 0;
			        }
			        else {
				        // Ball and robot in own half: interception possible
				        // rating of distances: closest robot gets highest rating
				        double sumOfDistances = 1.0; // to prevent div by 0
				        for (int j=0; j< playerPoseCollection.numberOfOwnPlayers; j++) {
					        sumOfDistances += interceptRelDist[j];
				        }
				        int distanceRating = (int) floor((1.0 - fieldPosData[InterceptBall].relDist/sumOfDistances) * 100.0);
                if (distanceRating < 0)
                  distanceRating = 0;
				        mySingleBeliefs.ratedOptions[i] = distanceRating;
			        }
		        }
            break;

		  
		  case RateableOptions::bananaCrossFromLeft: 
            {
			        // dont do if not in opponent penalty zone
			        double robX = robotPose.translation.x;
				    double robY = robotPose.translation.y;
			        if ((robX < 1800) || (robY < 350))
				        mySingleBeliefs.ratedOptions[i] = 0;
			        else
			        {
				        double ballfact = 1.0;
				        if (fieldPosData[Ball].relDist > 300)
				        {
					        ballfact = (fieldPosData[Ball].relDist-300) / 700;
					        if (ballfact > 1)
						        ballfact = 1;
					        ballfact = 1 - ballfact;
				        }
				        // using goToPosRating here
				        int tmpRating = getGoToFieldPosRating(PenaltyPoint);
				        tmpRating = (int)(tmpRating); //* ((robX - 1800)/300));
				        mySingleBeliefs.ratedOptions[i] = (int)(tmpRating * ballfact * ballValidity);
			        
			        }
		        }
            break;

		  case RateableOptions::bananaCrossFromRight: 
            {
			        // dont do if not in opponent penalty zone
			        double robX = robotPose.translation.x;
				    double robY = robotPose.translation.y;
			        if ((robX < 1800) || (robY > -350))
				        mySingleBeliefs.ratedOptions[i] = 0;
			        else
			        {
				        double ballfact = 1.0;
				        if (fieldPosData[Ball].relDist > 300)
				        {
					        ballfact = (fieldPosData[Ball].relDist-300) / 700;
					        if (ballfact > 1)
						        ballfact = 1;
					        ballfact = 1 - ballfact;
				        }
				        // using goToPosRating here
				        int tmpRating = getGoToFieldPosRating(PenaltyPoint);
				        tmpRating = (int)(tmpRating);// * ((robX - 1800)/300));
				        mySingleBeliefs.ratedOptions[i] = (int)(tmpRating * ballfact * ballValidity);
			        
			        }
		        }
            break;

          case RateableOptions::doRollLeft:
            mySingleBeliefs.ratedOptions[i] = getRollRating(450, 90);
            break;

          case RateableOptions::doRollRight: 
            mySingleBeliefs.ratedOptions[i] = getRollRating(450, -90);
            break;

          case RateableOptions::turnForBall: 
            mySingleBeliefs.ratedOptions[i] = 100;
            break;

          case RateableOptions::goToGoaliePos: 
            {
              int tmpRating = getGoToFieldPosRating(GoaliePos);
              if (tmpRating < 1)
                tmpRating = 1;
              mySingleBeliefs.ratedOptions[i] = tmpRating;
            }
            break;

          case RateableOptions::backUp: 
            {
              mySingleBeliefs.ratedOptions[i] = 0;
              // when should we back up to prevent clustering ?
              // check if we are close to a teammate...
              int tm = -1;
              double minDist = 100000;
              for (int k = 0 ; k < playerPoseCollection.numberOfOwnPlayers; ++k)
                if ((teamRelDist[k] < 400) && (teamRelDist[k] < minDist))
                {
                  minDist = teamRelDist[k];
                  tm = k;
                }
              // if there is a teammate close to me...
              if (tm >= 0)
                // if the ball is far away, then rate by the Playernumber
                if (fieldPosData[Ball].relDist > 500)
                  mySingleBeliefs.ratedOptions[i] = 25 * (getPlayer().getPlayerNumber()+1);
                else
                {
                  // the robot closest to the ball should have the biggest rating
                  Vector2<double> tmp;
                  tmp.x   = fieldPosData[Ball].absPos.x -
                    playerPoseCollection.getOwnPlayerPose(tm).getPose().translation.x;  
                  tmp.y   = fieldPosData[Ball].absPos.y -
                    playerPoseCollection.getOwnPlayerPose(tm).getPose().translation.y;
                  if (fieldPosData[Ball].relDist > tmp.abs()) 
                    mySingleBeliefs.ratedOptions[i] = 25 * (getPlayer().getPlayerNumber()+1);
                }
				    }
            break;

		      case RateableOptions::waveLeft: 
            mySingleBeliefs.ratedOptions[i] = 100;
            break;

		      case RateableOptions::waveRight: 
            mySingleBeliefs.ratedOptions[i] = 100;
            break;

          case RateableOptions::goToMiddleAtBall: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(MiddleAtBall);
            break;

          case RateableOptions::goToFrontAtBall: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(FrontAtBall);
            break;

          case RateableOptions::goToBehindAtBall: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(BehindAtBall);
            break;

          case RateableOptions::goToRightAtBall: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(RightAtBall);
            break;

          case RateableOptions::goToLeftAtBall: 
            mySingleBeliefs.ratedOptions[i] = getGoToFieldPosRating(LeftAtBall);
            break;
#else
          case RateableOptions::intro: 
            mySingleBeliefs.ratedOptions[i] = 100;
            if ((ocstate == dtt_initial)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::extro: 
            mySingleBeliefs.ratedOptions[i] = 100;
            if ((ocstate != dtt_finished)
               &&(ocstate != dtt_finishedWalkWithBridge)
//               &&(ocstate != dtt_finishedBite)
               &&(ocstate != dtt_finishedExtro)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::finished: 
            mySingleBeliefs.ratedOptions[i] = 100;
            if ((ocstate != dtt_finished)
               &&(ocstate != dtt_finishedExtro)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::gotoBitePos1:
            mySingleBeliefs.ratedOptions[i] = ocrating[0];
//            if (getPlayer().getPlayerNumber()==Player::five)
//            if (getPlayer().getPlayerNumber()==Player::one)
//              mySingleBeliefs.ratedOptions[i] = 100;
            if (//(ocstate != dtt_start) &&
                (ocstate != dtt_finishedIntro) &&
                 (ocstate != dtt_finishedGoToBitePoint)
               &&(ocstate != dtt_finishedBite)
               &&(ocstate != dtt_loseBitePoints)
               &&(ocstate != dtt_finishedExtro)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::gotoBitePos2: 
            mySingleBeliefs.ratedOptions[i] = ocrating[1];
//            mySingleBeliefs.ratedOptions[i] = 0;
  //          if (getPlayer().getPlayerNumber()==Player::two)
    //          mySingleBeliefs.ratedOptions[i] = 100;
            if (//(ocstate != dtt_start) &&
                (ocstate != dtt_finishedIntro) &&
                (ocstate != dtt_finishedGoToBitePoint)
               &&(ocstate != dtt_finishedBite)
               &&(ocstate != dtt_loseBitePoints)
               &&(ocstate != dtt_finishedExtro)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::gotoBitePos3: 
            mySingleBeliefs.ratedOptions[i] = ocrating[2];
//            mySingleBeliefs.ratedOptions[i] = 0;
  //          if (getPlayer().getPlayerNumber()==Player::three)
    //          mySingleBeliefs.ratedOptions[i] = 100;
            if (//(ocstate != dtt_start) &&
                (ocstate != dtt_finishedIntro) &&
                 (ocstate != dtt_finishedGoToBitePoint)
               &&(ocstate != dtt_finishedBite)
               &&(ocstate != dtt_loseBitePoints)
               &&(ocstate != dtt_finishedExtro)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::gotoBitePos4: 
            mySingleBeliefs.ratedOptions[i] = ocrating[3];
//            mySingleBeliefs.ratedOptions[i] = 0;
  //          if (getPlayer().getPlayerNumber()==Player::four)
    //          mySingleBeliefs.ratedOptions[i] = 100;
            if (//(ocstate != dtt_start) &&
                (ocstate != dtt_finishedIntro) &&
                 (ocstate != dtt_finishedGoToBitePoint)
               &&(ocstate != dtt_finishedBite)
               &&(ocstate != dtt_loseBitePoints)
               &&(ocstate != dtt_finishedExtro)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::bitePos1: 
            mySingleBeliefs.ratedOptions[i] = mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos1];
            if ((ocstate != dtt_finishedGoToBitePoint)
               &&(ocstate != dtt_finishedBite)
               &&(ocstate != dtt_loseBitePoints)
               &&(ocstate != dtt_finishedExtro)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::bitePos2: 
            mySingleBeliefs.ratedOptions[i] = mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos2];;
            if ((ocstate != dtt_finishedGoToBitePoint)
               &&(ocstate != dtt_finishedBite)
               &&(ocstate != dtt_loseBitePoints)
               &&(ocstate != dtt_finishedExtro)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::bitePos3: 
            mySingleBeliefs.ratedOptions[i] = mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos3];
            if ((ocstate != dtt_finishedGoToBitePoint)
               &&(ocstate != dtt_finishedBite)
               &&(ocstate != dtt_loseBitePoints)
               &&(ocstate != dtt_finishedExtro)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::bitePos4: 
            mySingleBeliefs.ratedOptions[i] = mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos4];
            if ((ocstate != dtt_finishedGoToBitePoint)
               &&(ocstate != dtt_finishedBite)
               &&(ocstate != dtt_loseBitePoints)
               &&(ocstate != dtt_finishedExtro)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::movePos1: 
            mySingleBeliefs.ratedOptions[i] = mySingleBeliefs.ratedOptions[RateableOptions::bitePos1];
            if ((ocstate != dtt_finishedBite)
               &&(ocstate != dtt_finishedExtro)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::movePos2: 
            mySingleBeliefs.ratedOptions[i] = mySingleBeliefs.ratedOptions[RateableOptions::bitePos2];
            if ((ocstate != dtt_finishedBite)
               &&(ocstate != dtt_finishedExtro)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::movePos3: 
            mySingleBeliefs.ratedOptions[i] = mySingleBeliefs.ratedOptions[RateableOptions::bitePos3];
            if ((ocstate != dtt_finishedBite)
               &&(ocstate != dtt_finishedExtro)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::movePos4: 
            mySingleBeliefs.ratedOptions[i] = mySingleBeliefs.ratedOptions[RateableOptions::bitePos4];
            if ((ocstate != dtt_finishedBite)
               &&(ocstate != dtt_finishedExtro)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::gotoBridge: 
            mySingleBeliefs.ratedOptions[i] = ocrating[4];
//            mySingleBeliefs.ratedOptions[i] = 0;
 //           if (getPlayer().getPlayerNumber()==Player::five)
 //           if (getPlayer().getPlayerNumber()==Player::one)
//              mySingleBeliefs.ratedOptions[i] = 100;
            if ((ocstate != dtt_finishedIntro)&&
               (ocstate != dtt_finishedExtro)
               &&(ocstate != dtt_finishedGoToBridge)
               &&(ocstate != dtt_finishedClimbBridge)
               &&(ocstate != dtt_finishedWalkWithBridge)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::climbBridge: 
            mySingleBeliefs.ratedOptions[i] = mySingleBeliefs.ratedOptions[RateableOptions::gotoBridge];
            if ((ocstate != dtt_finishedExtro)
               &&(ocstate != dtt_finishedGoToBridge)
               &&(ocstate != dtt_finishedClimbBridge)
               &&(ocstate != dtt_finishedWalkWithBridge)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::moveBridge: 
            mySingleBeliefs.ratedOptions[i] = mySingleBeliefs.ratedOptions[RateableOptions::climbBridge];
            if ((ocstate != dtt_finishedExtro)
               &&(ocstate != dtt_finishedClimbBridge)
               &&(ocstate != dtt_finishedWalkWithBridge)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
          case RateableOptions::waitForBiteDogs: 
            mySingleBeliefs.ratedOptions[i] = mySingleBeliefs.ratedOptions[RateableOptions::climbBridge];
            if ((ocstate != dtt_finishedExtro)
               &&(ocstate != dtt_finishedClimbBridge)
               &&(ocstate != dtt_finishedWalkWithBridge)
               )  mySingleBeliefs.ratedOptions[i] = 0;
            break;
#endif
          default: 
            mySingleBeliefs.ratedOptions[i] = 0;
            break;
        }
      }
      mySingleBeliefs.ratedOptions[chooserRaterInterfaces.lastChoosenOption] +=
        RateableOptions::getRatingBoost(chooserRaterInterfaces.lastChoosenOption);
#ifdef OPENCHALLENGE_DEFINES
  LEDRequest::BlinkMode bmode = LEDRequest::oooo;
  if(mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos1] > 25)
    bmode = LEDRequest::looo;
  if(mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos1] > 50)
    bmode = LEDRequest::lloo;
  if(mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos1] > 75)
    bmode = LEDRequest::lllo;
  ledRequest.faceLED[1] = bmode;

  bmode = LEDRequest::oooo;
  if(mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos2] > 25)
    bmode = LEDRequest::looo;
  if(mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos2] > 50)
    bmode = LEDRequest::lloo;
  if(mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos2] > 75)
    bmode = LEDRequest::lllo;
  ledRequest.faceLED[0] = bmode;

  bmode = LEDRequest::oooo;
  if(mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos3] > 25)
    bmode = LEDRequest::looo;
  if(mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos3] > 50)
    bmode = LEDRequest::lloo;
  if(mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos3] > 75)
    bmode = LEDRequest::lllo;
  ledRequest.faceLED[3] = bmode;

  bmode = LEDRequest::oooo;
  if(mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos4] > 25)
    bmode = LEDRequest::looo;
  if(mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos4] > 50)
    bmode = LEDRequest::lloo;
  if(mySingleBeliefs.ratedOptions[RateableOptions::gotoBitePos4] > 75)
    bmode = LEDRequest::lllo;
  ledRequest.faceLED[2] = bmode;
#endif

    } 
	  // set timestamp - only used locally. The TimeStamps of the other dogs
	  // come from TeamMessageCollection and are the TimeStamps, when the
	  // data was send. Don't worry. This doesn't cause any problems. Just
	  // remember that we're single threadet ;-)
	  mySingleBeliefs.timeStamp = SystemCall::getCurrentSystemTime();
  } // endif playernumber
}


/*
 * Change log :
 * $Log: DefaultOptionRating.cpp,v $
 * Revision 1.100  2004/06/22 18:35:12  hamerla
 * OC version test di abend
 *
 * Revision 1.99  2004/06/22 01:51:04  kerdels
 * further work on openchallenge
 *
 * Revision 1.98  2004/06/21 22:02:11  hamerla
 * no message
 *
 * Revision 1.97  2004/06/21 11:52:53  hamerla
 * OpenChallenge
 *
 * Revision 1.96  2004/06/18 13:21:36  hamerla
 * oc nach test rollenzuteilung
 *
 * Revision 1.95  2004/06/17 09:47:47  hamerla
 * OC rollenzuteilung
 *
 * Revision 1.94  2004/06/16 11:44:32  hamerla
 * OC LED BitePos
 *
 * Revision 1.93  2004/06/11 16:32:25  hamerla
 * OC Test Version Freitag
 *
 * Revision 1.92  2004/06/08 15:58:24  hamerla
 * Open Challenge remove some Bugs
 *
 * Revision 1.91  2004/06/08 14:34:37  hamerla
 * dtt for openchallenge
 *
 * Revision 1.90  2004/06/07 16:00:57  hamerla
 * OptionRation fr OpenChallenge
 *
 * Revision 1.89  2004/05/12 19:33:12  kerdels
 * merged the behavior changes during australian, american and japan open
 *
 * Revision 1.88  2004/04/14 06:37:15  loetzsch
 * removed the hack "kickInProgress" from the BehaviorControlInterfaces
 *
 * Revision 1.87  2004/04/08 15:33:01  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.108  2004/04/04 00:10:53  kerdels
 * modified base ratings
 *
 * Revision 1.107  2004/04/03 18:25:28  lohmann
 * goalie doJump left/right bug
 *
 * Revision 1.106  2004/04/02 10:04:02  kerdels
 * worked on the "doNothing" problem
 *
 * Revision 1.105  2004/04/01 14:41:37  kerdels
 * retuned jump-defend
 *
 * Revision 1.104  2004/04/01 03:34:47  pg_joke
 * retuning of jump-ratings
 *
 * Revision 1.103  2004/04/01 02:46:29  pg_joke
 * some further finetuning of jump-ratings
 *
 * Revision 1.102  2004/04/01 02:14:03  pg_joke
 * now the goToBall-Rating is never less than 10
 *
 * Revision 1.101  2004/04/01 02:06:45  pg_joke
 * upon a suggestion by walter the goalie now estimates where the ball will pass him. So he can decide to JumpDefend, JumpLeft or JumpRight.
 *
 * Revision 1.100  2004/03/31 18:46:45  pg_joke
 * fine tuned jump defend rating and integrated it into default-dtt. But both - tacticEntrys in default.dtt and the ratings - are disabled (commented out) yet. A first, short test in the Arena looked quite good.
 *
 * Revision 1.99  2004/03/31 16:43:24  pg_joke
 * created a new doJumpDefend, doJumpLeft, doJumpRight rating. not tested yet, so commented out.
 *
 * Revision 1.98  2004/03/31 14:35:13  pg_mahu
 * re-tuned to the old go-to-ball-rating (NextBall is not good enough)
 *
 * Revision 1.97  2004/03/31 14:10:20  pg_mahu
 * Added some stuff 4 better playing (hopefully)
 *
 * Revision 1.96  2004/03/31 11:56:07  pg_mahu
 * Added some stuff 4 better playing (hopefully)
 *
 * Revision 1.95  2004/03/31 00:02:22  pg_joha
 * Presse heute gleich
 *
 * Revision 1.94  2004/03/30 01:32:22  pg_joke
 * added new states to the SpecialEventAnalyser to determine how many teammates are connected via wlan. Used this information in a new, slightly bigger default.dtt. The old default.dtt is saved to tbaseV5.dtt and a copy of the new default.dtt is tbaseV6.dtt. Changed some OptionRatings too. Hopefully this stuff will improve the behavior when the network is broken.
 *
 * Revision 1.93  2004/03/29 11:34:11  pg_joke
 * added output symbols kick.status.started and kick.status.stopped
 *
 * Revision 1.92  2004/03/24 15:32:10  pg_joke
 * added a kickToClearGoalie and a newKickToClearGoalie Option
 *
 * Revision 1.91  2004/03/24 15:11:34  pg_joke
 * added location dependend kickratings to improve team-behavior
 *
 * Revision 1.90  2004/03/24 12:54:23  pg_joke
 * added GoToBallGoalie
 *
 * Revision 1.89  2004/03/23 23:04:06  pg_joke
 * see mails
 *
 * Revision 1.88  2004/03/23 19:02:20  pg_joha
 * test spiel changes
 *
 * Revision 1.87  2004/03/21 04:36:05  pg_joke
 * added slidingAverage to OptionRatings,
 * added ratingBoost (Hysteresis) to OptionRatings
 *
 * Revision 1.86  2004/03/18 17:04:38  hamerla
 * gotoball
 *
 * Revision 1.85  2004/03/17 00:04:32  kerdels
 * set ballValidity to 1 and ballMotionValidity to 0
 *
 * Revision 1.84  2004/03/10 21:44:30  kerdels
 * added goToMiddleAtBall Option
 *
 * Revision 1.83  2004/03/09 23:11:12  kerdels
 * unmystified this bug (wasn't mystical at all :-( )
 *
 * Revision 1.82  2004/03/08 01:07:07  roefer
 * Interfaces should be const
 *
 * Revision 1.81  2004/03/01 17:14:03  kerdels
 * added robot-pose.distance-to-opponent-goal,
 * moved robot-pose.angle-to-teammate1-3 to MSH2004StrategySymbols as fieldpos.angle-to-teammate1-3,
 * added fieldpos.distance-to-teammate1-3,
 * added DTT-Options newKickToGoal, newKickToClear, newKickToTeammate1-3,
 * added DTT-OptionClass newKickToTeammate,
 * added kickToPosRating function in DefaultOptionRating
 *
 * Revision 1.80  2004/02/28 11:20:16  kerdels
 * removed single kicks from behavior...
 *
 * Revision 1.79  2004/02/24 16:21:19  hamerla
 * *** empty log message ***
 *
 * Revision 1.78  2004/02/19 17:01:10  kerdels
 * added goalie-switch with two demo-options waveLeft and waveRight
 *
 * Revision 1.77  2004/02/19 16:27:05  kerdels
 * rated backUp option,
 * made modifications discussed with michael,
 * added backUp option to default.dtt
 *
 * Revision 1.76  2004/02/18 23:32:58  kerdels
 * added goToFrontPenLeft, goToFrontPenRight
 * added backUp, not rated yet
 * splittet goto-switch.xml in goto-switch.xml and gotoBall-switch.xml
 *
 * Revision 1.75  2004/02/12 16:20:30  kerdels
 * adjusted some ratings for simple-kick use
 *
 * Revision 1.74  2004/02/11 11:32:50  kerdels
 * modified Rating for kicks
 *
 * Revision 1.73  2004/02/06 09:39:51  kerdels
 * modified some ratings, adjusted weights in tactics/tbase.dat
 *
 * Revision 1.72  2004/02/04 23:26:41  kerdels
 * added kicksToClear, clearkick-switch and option-type, specialKickToClear optionClass and apropriate ratings,
 * modified GoToBallPos ratings
 *
 * Revision 1.71  2004/02/04 17:48:06  kerdels
 * heelKicks removed
 *
 * Revision 1.70  2004/02/04 15:34:53  rossdeutscher
 * improved overall behaviour
 *
 * Revision 1.69  2004/02/04 11:20:29  rossdeutscher
 * cleaned up the code and added a comment here and there - doJumpDefend, doJumpLeft and doJumpRight Options
 *
 * Revision 1.68  2004/02/03 20:58:02  kerdels
 * modified tactis.dat, backup of old tactics.dat is otactics.dat
 *
 * Revision 1.67  2004/02/03 12:51:53  lohmann
 * BananaCross splitted into Left and Right.
 *
 * Revision 1.66  2004/02/02 20:23:55  kerdels
 * work at optionratings and new reflextest rxtest2.dat added.
 *
 * Revision 1.65  2004/02/02 19:10:30  kerdels
 * adjusted some options for the use with reflexes, created a simple version of turn-for-ball and modified some option ratings...
 *
 * Revision 1.64  2004/02/02 16:33:58  kerdels
 * added DTT-options goToCatenaccioLeft, goToCatenaccioMiddle and goToCatenaccioRight.
 * Also added catfun.dat to test this new options
 *
 * Revision 1.63  2004/02/02 12:23:45  lohmann
 * unsw-bash-optimized-kick added
 *
 * Revision 1.62  2004/01/30 18:15:40  kerdels
 * some minor changes
 *
 * Revision 1.61  2004/01/30 17:47:37  rossbacher
 * Added new doJumpDefend rating
 *
 * Revision 1.60  2004/01/29 23:56:35  kerdels
 * added special goalie position to DTT
 *
 * Revision 1.59  2004/01/29 22:09:37  kerdels
 * added goToPosBasic Option
 * improved specialkickToPos Rating
 *
 * Revision 1.58  2004/01/29 21:33:27  kerdels
 * added turn-for-ball Option to DTT,
 * added link between TacticChooser and OptionRating
 *
 * Revision 1.57  2004/01/28 23:27:32  kerdels
 * added rollLeft and rollRight Option to DTT,
 * rating has to be adjusted
 *
 * Revision 1.56  2004/01/28 18:28:57  kerdels
 * aenderungen arena,
 * mathias, frank, jochen
 *
 * Revision 1.55  2004/01/28 00:01:46  kerdels
 * added legKick, leftKick, rightKick, chestKick, leftHeadKick, rightHeadKick and fastDiveKick to DTT
 *
 * Revision 1.54  2004/01/27 22:26:54  kerdels
 * added fastHeadKicks to DTT
 *
 * Revision 1.53  2004/01/27 20:20:06  kerdels
 * some minor changes
 *
 * Revision 1.52  2004/01/27 14:25:43  lohmann
 * Banana Cross added.
 *
 * Revision 1.51  2004/01/26 21:33:30  kerdels
 * added swimKicks
 *
 * Revision 1.50  2004/01/26 20:40:49  kerdels
 * added pawKickRight
 *
 * Revision 1.49  2004/01/26 18:45:05  kerdels
 * added pawKickLeft
 *
 * Revision 1.48  2004/01/26 18:02:17  kerdels
 * added heel-kicks to dtt
 *
 * Revision 1.47  2004/01/26 13:51:47  kerdels
 * modified kickToSpecial
 *
 * Revision 1.46  2004/01/25 21:22:56  kerdels
 * added mantisKickToTeammates
 *
 * Revision 1.45  2004/01/25 18:31:19  kerdels
 * added specialKickToPosRating to DefaultOptionRating
 *
 * Revision 1.44  2004/01/25 16:57:32  kerdels
 * added absPos and relAngle to preCalcArray
 *
 * Revision 1.43  2004/01/25 16:17:12  kerdels
 * fixed a bug and reduced network traffic
 *
 * Revision 1.42  2004/01/25 15:21:58  kerdels
 * cleaned up a little bit
 *
 * Revision 1.41  2004/01/25 12:17:23  kerdels
 * added first single-kick-option "mantisKick" and modified aging of ratedOptions
 *
 * Revision 1.40  2004/01/23 12:53:38  udo
 * InterceptBall Position and Rating included
 *
 * Revision 1.39  2004/01/22 23:16:38  kerdels
 * dribbel-option hinzugefgt
 *
 * Revision 1.38  2004/01/22 22:28:46  kerdels
 * Optionen fr Bandenverhalten hinzugefuegt
 *
 * Revision 1.37  2004/01/22 18:24:40  kerdels
 * Position BehindMiddle ein wenig nach vorne verlagert
 *
 * Revision 1.36  2004/01/22 17:18:26  kerdels
 * intercept-options hinzugefgt
 *
 * Revision 1.35  2004/01/15 15:32:00  kerdels
 * state penalized im option-rating beruecksichtigt
 *
 * Revision 1.34  2004/01/13 22:49:58  kerdels
 * included "liftet" robot in optionRating
 *
 * Revision 1.33  2004/01/12 22:16:20  kerdels
 * added rating of doJumpDefend, doJumpLeft and doJumpRight
 *
 * Revision 1.32  2004/01/08 20:18:18  kerdels
 * kickToTeammate Rating verbessert
 *
 * Revision 1.31  2004/01/08 00:27:16  kerdels
 * added dtt-options:
 * kickToTeammate1-3
 * rating davon noch verbesserungswrdig
 *
 * Revision 1.30  2004/01/07 23:17:01  kerdels
 * added symbols:
 * robot-pose.angle-to-teammate1
 * robot-pose.angle-to-teammate2
 * robot-pose.angle-to-teammate3
 *
 * Revision 1.29  2004/01/07 17:15:07  kerdels
 * added DTT-Option kickToGoal
 *
 * Revision 1.28  2004/01/07 14:56:08  kerdels
 * added send functionality to TacticDesigner
 *
 * Revision 1.27  2004/01/06 21:09:38  kerdels
 * added some Reflex Options,
 * not rated yet
 *
 * Revision 1.26  2004/01/06 18:43:25  kerdels
 * added some DTT-Options,
 * modified tactics.dat
 *
 * Revision 1.25  2004/01/05 22:48:45  kerdels
 * *** empty log message ***
 *
 * Revision 1.24  2004/01/05 22:45:28  kerdels
 * Validitt der Gegner/Teammates einbezogen
 *
 * Revision 1.23  2004/01/05 20:44:20  kerdels
 * div zero bug behoben
 *
 * Revision 1.22  2004/01/04 13:59:52  kerdels
 * DTT-Options erstellt
 *
 * Revision 1.21  2003/12/28 19:26:21  kerdels
 * warning debuggt
 *
 * Revision 1.20  2003/12/28 19:03:29  kerdels
 * option rating dialog added
 *
 * Revision 1.19  2003/12/25 22:55:51  kerdels
 * tuned goToPosition and goToBall optionrating
 *
 * Revision 1.18  2003/12/25 22:02:49  kerdels
 * option goToBall added to dTT
 *
 * Revision 1.17  2003/12/25 19:20:23  kerdels
 * rating verfeinert
 *
 * Revision 1.16  2003/12/25 19:14:38  kerdels
 * removed OUTPUT
 *
 * Revision 1.15  2003/12/25 19:13:00  kerdels
 * added approachCloseBall to DTT
 *
 * Revision 1.14  2003/12/25 18:35:30  kerdels
 * little update
 *
 * Revision 1.13  2003/12/23 20:57:47  kerdels
 * testchooser gebastelt
 *
 * Revision 1.12  2003/12/23 19:22:48  kerdels
 * FieldPosOptions und Ratings hinzugefgt
 *
 * Revision 1.11  2003/12/23 17:57:21  kerdels
 * Rating von goToFrontLeft verfeinert
 *
 * Revision 1.10  2003/12/23 17:39:09  kerdels
 * DefaultOptionRating restrukturiert
 *
 * Revision 1.9  2003/12/23 17:02:34  kerdels
 * DefaultOptionRating restrukturiert
 *
 * Revision 1.8  2003/12/23 16:20:37  kerdels
 * DefaultOptionRating restrukturiert
 *
 * Revision 1.7  2003/12/23 15:02:26  kerdels
 * goToFrontLeft rating erweitert
 *
 * Revision 1.6  2003/12/22 20:06:57  kerdels
 * goToFrontLeft mini-demo gebastelt
 *
 * Revision 1.5  2003/12/22 18:50:27  kerdels
 * goToFrontLeft hinzugefgt
 *
 * Revision 1.4  2003/12/21 14:35:49  kerdels
 * option doNothing zum dtt hinzugefgt
 *
 * Revision 1.3  2003/12/18 00:12:59  kerdels
 * inserted dtt in msh2004 behavior
 *
 * Revision 1.2  2003/12/17 20:24:43  kerdels
 * Added TimeStamp-stuff to DefaultOptionRating
 *
 * Revision 1.1  2003/12/11 18:28:22  kerdels
 * DTT Framework fertiggestellt.
 *
 * Revision 1.1  2003/12/11 16:22:20  kerdels
 * Die DynamicTeamTactic neu strukturiert und ins MSH2004 Behavior integriert..
 *
 * Revision 1.1  2003/12/10 20:46:11  kerdels
 * CollectedBeliefs entfernt
 *
 * Revision 1.3  2003/12/07 15:21:12  kindler
 * Added missing breaks in switch statement.
 *
 * Revision 1.2  2003/12/07 15:03:43  kindler
 * Changelog keyword added.
 *
 *
 */
