/**
* @file DefaultTacticChooser.cpp
* 
* Implementation of class DefaultTacticChooser
*  
*  @author <A href=mailto:b@tchman.de>Mathias Hlsbusch</A>
*/

#include "DefaultTacticChooser.h"
#include "Tools/DynamicTeamTactic/RateableOptions.h"
#include "Tools/Location.h"
#include "Tools/Streams/InStreams.h"
#include "Modules/BehaviorControl/MSH2004BehaviorControl/OpenChallengeDefines.h"

static const int FADING_START_TIME = 1000;
static const int FADING_END_TIME = 6000;


DefaultTacticChooser::DefaultTacticChooser(const BehaviorControlInterfaces& interfaces,
																				   CollectedBeliefs& collectedBeliefs,
                                           ChooserRaterInterfaces& chooserRaterInterfaces)
: TacticChooser(interfaces, collectedBeliefs, chooserRaterInterfaces)
{
  freeze = false;
	// precalculation of all possible Dog permutaions...
	// it's not nice, but does it for all kinds of numOfPlayerNumbers > 0
	facOfNumOfPlayerNumbers = 1;
	int i;
	for (i = 2; i <= Player::numOfPlayerNumbers; ++i)
		facOfNumOfPlayerNumbers *= i;

	// create some space to store permutations...
  for (i = 0; i < Player::numOfPlayerNumbers; ++i)
		dogPermutation[i] = new int[facOfNumOfPlayerNumbers];

  // calculating some ranges..
  int divisors[Player::numOfPlayerNumbers-2];
  int tmp = facOfNumOfPlayerNumbers;
  
	// to be sure ...
	if (Player::numOfPlayerNumbers > 2) {
    for (i = Player::numOfPlayerNumbers; i > 2; --i) {
      divisors[Player::numOfPlayerNumbers - i] = tmp / i;
	    tmp = divisors[Player::numOfPlayerNumbers - i];
		}
	}

	// generate the permutations...
	int dogs[Player::numOfPlayerNumbers];
	int j,k,l;
  for (i = 0; i < facOfNumOfPlayerNumbers; ++i) {
		// initialising some fresh dogs...
	  for (j = 0; j < Player::numOfPlayerNumbers; ++j)
			dogs[j] = j;
		// go, create...
		tmp = i;
		j = 0;
    if (Player::numOfPlayerNumbers > 2) 
      for (j = 0; j < Player::numOfPlayerNumbers-2; ++j) {
	    	k = tmp / divisors[j];
	    	tmp %= divisors[j];
	    	// adding dog to permutation...
	      dogPermutation[j][i] = dogs[k];
        for (l = k; l < Player::numOfPlayerNumbers-1; ++l)
          dogs[l] = dogs[l+1];
			}

		// adding the last two dogs...
    dogPermutation[j][i]   = dogs[tmp];
    if (Player::numOfPlayerNumbers > 1) 
	    dogPermutation[j+1][i] = dogs[1-tmp];
	}


	// Loading the TacticEntryArray
  InBinaryFile stream(getLocation().getFilename("default.dtt"));
  if (stream.exists())
  {
    stream >> tacticEntryArray;
  }
  else
  {
		OUTPUT(idText,text,"DefaultTacticChoose : couldn't load TacticEntryArray");
  }


}

DefaultTacticChooser::~DefaultTacticChooser()
{
	// release the space for the permutations...
	for (int i = 0; i < Player::numOfPlayerNumbers; ++i)
    delete[] dogPermutation[i];
}

bool DefaultTacticChooser::handleMessage(InMessage& message)
{
  if (message.getMessageID() == idTacticEntryArray)
  {
    message.bin >> tacticEntryArray;
    return true;
  }
  if (message.getMessageID() == idFreezeRequest)
  {
    message.bin >> freeze;
    return true;
  }
  return false;
}



RateableOptions::OptionID DefaultTacticChooser::chooseOption()
{
  // here comes the funny stuff...
/*

	// just for testing purposes:
  RateableOptions::OptionID optToChoose = RateableOptions::stand;
	int maxval;
	int myself = getPlayer().getPlayerNumber();

	int bestdog = 0;
	int bestoption = 0;
	int i,j;
	int k = 0;
	
	
	// how many options do we have?
	//k = RateableOptions::getNumberOfClassMembers(RateableOptions::goToAnyFront)+
	//	RateableOptions::getNumberOfClassMembers(RateableOptions::goToAnyMiddle)+
	//	RateableOptions::getNumberOfClassMembers(RateableOptions::goToAnyBehind);
	
	int options[(int)RateableOptions::goToBehindRight][2];
	
	
	//which dog is the best for each postition
	for (i = (int)RateableOptions::goToFrontLeft;i <= (int)RateableOptions::goToBehindRight; ++i)
	{
		maxval=0;
		for (j=0; j < Player::numOfPlayerNumbers; ++j)
			if ((collectedBeliefs.singleBeliefs[j].ratedOptions[i] > maxval) && (collectedBeliefs.singleBeliefs[j].ratedOptions[i] > options[i][1]))
			{
				maxval = collectedBeliefs.singleBeliefs[j].ratedOptions[i];
				options[i][0] = j;
				options[i][1] = maxval;
			}
	}

	
	maxval = 0;

	// what am i best for?
	for (i = (int)RateableOptions::goToFrontLeft;i <= (int)RateableOptions::goToBehindRight; ++i)
		if ((options[i][0] == myself) && options[i][1] > maxval)
		{
			maxval = options[i][1];
			bestoption=i;
		}


	optToChoose = (RateableOptions::OptionID)bestoption;

	maxval = 0;
	bestdog = 0;
	
	for (i=0; i < Player::numOfPlayerNumbers; ++i)
		if (collectedBeliefs.singleBeliefs[i].ratedOptions[RateableOptions::approachCloseBall] > maxval)
		{
			maxval = collectedBeliefs.singleBeliefs[i].ratedOptions[RateableOptions::approachCloseBall];
			bestdog = i;
		}

	if (bestdog == myself)
		optToChoose = RateableOptions::goToBall;

	// OUTPUT(idText, text, RateableOptions::getOptionName(optToChoose));

*/

 	RateableOptions::OptionID optToChoose = RateableOptions::noOption;
  if (freeze)
    optToChoose = RateableOptions::stand;
  else {
    RateableOptions::OptionID usedOptions[Player::numOfPlayerNumbers];
    double maxScore = 0;
    int choosenTacticEntry = 0;
    unsigned long actTime = SystemCall::getCurrentSystemTime();
    double timeWeight[Player::numOfPlayerNumbers];
	  int k;
    int timediff;
    // doing some Aging...
    for (k = 0; k < Player::numOfPlayerNumbers; ++k) {
      timediff = actTime - collectedBeliefs.singleBeliefs[k].timeStamp;
      if (timediff < FADING_START_TIME)
        timediff = 0;
      else if (timediff > FADING_END_TIME)
        timediff = FADING_END_TIME - FADING_START_TIME;
      else timediff = timediff - FADING_START_TIME;
      timeWeight[k] = (double)((FADING_END_TIME - FADING_START_TIME)-timediff) /
                      (double)(FADING_END_TIME - FADING_START_TIME);
    }

		  
    // preparing the global Analysers...
    for (int n = 0; n < RateableOptions::numOfGlobalAnalysers; ++n)
		  globalAnalyser[n]->update();

    for (int i = 0; i < facOfNumOfPlayerNumbers; ++i) 
	  {

	    // walk through all TacticEntrys with that permutation..
		  for (int te=0; te < tacticEntryArray.entryCount; ++te)
		  {
			  // get score for permutation i
			  double score = 0;

   		  TacticEntry& aktTE = tacticEntryArray.entrys[te];

        // is this permutation a valid permutation for this tacticEntry ?
			  int validPermutation = 1;
        for (int j = 0; j < Player::numOfPlayerNumbers; ++j)
			    validPermutation *= aktTE.allowedDogs[dogPermutation[j][i]][j];

        if (validPermutation)
			  {
          // get the options for this entry ...
          for (k = 0; k < Player::numOfPlayerNumbers; ++k)
					  if (aktTE.isOptionClass[k])
						  usedOptions[k] = 
	  collectedBeliefs.singleBeliefs[dogPermutation[k][i]].getBestOptionInOptionClass(
	                         (RateableOptions::OptionClassID)(aktTE.neededOptions[k])
											  				                                                   );
					  else usedOptions[k] = (RateableOptions::OptionID)(aktTE.neededOptions[k]);

			    for (k = 0; k < Player::numOfPlayerNumbers; ++k)
				    score += aktTE.optionWeights[k] * timeWeight[dogPermutation[k][i]] *
    collectedBeliefs.singleBeliefs[dogPermutation[k][i]].ratedOptions[usedOptions[k]];

				  score *= aktTE.weight;

				  // applying global analysers
          for (k = 0; k < RateableOptions::numOfGlobalAnalysers; ++k)
					  score *= globalAnalyser[k]->getWeight(aktTE.globalAnalysersInfo[k]);

				  if (score >= maxScore)
				  {
					  maxScore = score;
            choosenTacticEntry = te;
					  for (int l = 0; l < Player::numOfPlayerNumbers; ++l)
					    if (dogPermutation[l][i] == getPlayer().getPlayerNumber())
						  {
						    optToChoose = usedOptions[l];
							  break;
						  }
					  for (int j = 0; j < Player::numOfPlayerNumbers; ++j)
              ocplayerrole[dogPermutation[j][i]] = usedOptions[j];
				  }// if (maxScore)
			  }// if (validPermutation)
	    }// for (TE)
	  }

  //	OUTPUT(idText, text, RateableOptions::getOptionName(optToChoose));
    INFO(sendOptionRatings,idChoosenTacticEntry,text,tacticEntryArray.entrys[choosenTacticEntry].name);
    char buffer[10];
    char buffer2[50] = "|";
    for (k=0; k < Player::numOfPlayerNumbers; ++k)
    {
      //_gcvt(timeWeight[k],2,buffer);
      sprintf( buffer, "%4.2f", timeWeight[k]);
      strcat(buffer,"|");
      strcat(buffer2,buffer);
    }
    INFO(sendOptionRatings,idTimeWeights,text,buffer2);

#ifndef OPENCHALLENGE_DEFINES
    if (optToChoose == RateableOptions::keepOption)
      optToChoose = chooserRaterInterfaces.lastChoosenOption;
    else
      // don't remember reflexes...
    if ((optToChoose != RateableOptions::backUp)       &&
        (optToChoose != RateableOptions::doJumpDefend)    )
  	  chooserRaterInterfaces.lastChoosenOption = optToChoose;
#endif
  } // end else part of "if (freeze)"
 
  INFO(sendOptionRatings,idChoosenOption,text,RateableOptions::getOptionName(optToChoose));
  return optToChoose;

}


/*
 * Change log :
 * $Log: DefaultTacticChooser.cpp,v $
 * Revision 1.30  2004/06/18 13:21:37  hamerla
 * oc nach test rollenzuteilung
 *
 * Revision 1.29  2004/06/07 16:00:57  hamerla
 * OptionRation fr OpenChallenge
 *
 * Revision 1.28  2004/03/08 01:07:09  roefer
 * Interfaces should be const
 *
 * Revision 1.27  2004/02/19 20:34:21  kerdels
 * improved keepOption in reflex situations
 *
 * Revision 1.26  2004/02/12 20:40:50  kerdels
 * renamed the tactics to .dtt from .dat to prevent confusions
 *
 * Revision 1.25  2004/02/04 16:45:10  kerdels
 * added keepOption
 *
 * Revision 1.24  2004/02/04 15:34:53  rossdeutscher
 * improved overall behaviour
 *
 * Revision 1.23  2004/01/29 21:33:28  kerdels
 * added turn-for-ball Option to DTT,
 * added link between TacticChooser and OptionRating
 *
 * Revision 1.22  2004/01/28 21:54:10  kerdels
 * fixed aging...
 *
 * Revision 1.21  2004/01/27 22:26:55  kerdels
 * added fastHeadKicks to DTT
 *
 * Revision 1.20  2004/01/27 20:20:07  kerdels
 * some minor changes
 *
 * Revision 1.19  2004/01/27 02:32:18  kerdels
 * restructuring the restructuring of our xabsl-stuff... +
 * found and removed a bad bug in collectedBeliefs.cpp
 *
 * Revision 1.18  2004/01/19 20:13:07  kerdels
 * added name capability to tacticentrys
 *
 * Revision 1.17  2004/01/12 17:17:52  kerdels
 * added freeze functionality to tacticDesigner
 *
 * Revision 1.16  2004/01/07 14:56:09  kerdels
 * added send functionality to TacticDesigner
 *
 * Revision 1.15  2004/01/06 00:01:57  kerdels
 * Aging im TacticChooser hinzugefgt,
 * OptionRatingDlgBar um choosenTacticEntry erweitert
 *
 * Revision 1.14  2004/01/04 01:00:46  kerdels
 * TacticDesigner hinzugefgt
 *
 * Revision 1.13  2004/01/01 00:03:25  kerdels
 * tacticEntryArray Streaming berarbeitet
 *
 * Revision 1.12  2003/12/30 23:13:06  rossbacher
 * Multiple dogs will not go to the same position now. Only in the in this version outcommented test
 *
 * Revision 1.11  2003/12/29 21:35:12  kerdels
 * tactics beispiel hinzugefgt,
 * laden aus datei im tacticchooser
 *
 * Revision 1.10  2003/12/29 12:26:27  kerdels
 * global analysis hinzugefgt
 *
 * Revision 1.9  2003/12/28 23:00:12  kerdels
 * tactic chooser berarbeitet
 *
 * Revision 1.8  2003/12/28 19:26:21  kerdels
 * warning debuggt
 *
 * Revision 1.7  2003/12/25 23:16:39  kerdels
 * tuned
 *
 * Revision 1.6  2003/12/25 22:02:49  kerdels
 * option goToBall added to dTT
 *
 * Revision 1.5  2003/12/25 19:56:56  kerdels
 * weiteres demo...
 *
 * Revision 1.4  2003/12/23 20:57:47  kerdels
 * testchooser gebastelt
 *
 * Revision 1.3  2003/12/22 20:06:57  kerdels
 * goToFrontLeft mini-demo gebastelt
 *
 * Revision 1.2  2003/12/17 23:58:06  huelsbusch
 * startet work on option-choosing
 *
 * Revision 1.1  2003/12/11 18:28:22  kerdels
 * DTT Framework fertiggestellt.
 *
 *
 */
