/**
 * @file DefaultTacticChooser.h
 * 
 * Implementation of class DefaultTacticChooser.
 *
 * @author <A href=mailto:jochen@kerdels.de>Jochen Kerdels</A>
 */

#ifndef __DefaultTacticChooser_h_
#define __DefaultTacticChooser_h_

#include "Tools/DynamicTeamTactic/TacticChooser.h"
#include "Tools/DynamicTeamTactic/TacticEntry.h"
#include "Tools/DynamicTeamTactic/ChooserRaterInterfaces.h"



/**
* @class DefaultTacticChooser
*
* A simple implementation of the DefaultTacticChooser class.
*
*/
class DefaultTacticChooser : public TacticChooser
{
private:
	int facOfNumOfPlayerNumbers;
	int* dogPermutation[Player::numOfPlayerNumbers];
public:
  /** 
   * Constructor.
   * @param interfaces The parameters of the TacticChooser class.
   * @param collectedBeliefs The collected-Beliefs to work on.
   * @param chooserRaterInterfaces We want to talk to the Option-Rating.
   */
  DefaultTacticChooser(const BehaviorControlInterfaces& interfaces,
                       CollectedBeliefs& collectedBeliefs,
                       ChooserRaterInterfaces& chooserRaterInterfaces);

	/*
	 * Destructor.
	 */
	~DefaultTacticChooser();

  /** the TacticEntryArray to work with... */
  TacticEntryArray tacticEntryArray;

  /** if true, the robots should stand still, e.g. using option stand */
  int freeze;

  /** choosing one option in here... */
  RateableOptions::OptionID chooseOption();

  // open challenge
  /** role of team player*/
  RateableOptions::OptionID ocplayerrole[Player::numOfPlayerNumbers];

  /** receiving new TacicEntryArrays in here */
  virtual bool handleMessage(InMessage& message);
};

#endif // __DefaultTacticChooser_h_

/*
 * Change log :
 * $Log: DefaultTacticChooser.h,v $
 * Revision 1.10  2004/06/18 13:21:37  hamerla
 * oc nach test rollenzuteilung
 *
 * Revision 1.9  2004/03/08 01:07:09  roefer
 * Interfaces should be const
 *
 * Revision 1.8  2004/03/02 22:28:07  huelsbusch
 * Added missing doxygen comments
 *
 * Revision 1.7  2004/01/29 21:33:28  kerdels
 * added turn-for-ball Option to DTT,
 * added link between TacticChooser and OptionRating
 *
 * Revision 1.6  2004/01/12 17:17:52  kerdels
 * added freeze functionality to tacticDesigner
 *
 * Revision 1.5  2004/01/07 14:56:09  kerdels
 * added send functionality to TacticDesigner
 *
 * Revision 1.4  2003/12/29 21:35:12  kerdels
 * tactics beispiel hinzugefgt,
 * laden aus datei im tacticchooser
 *
 * Revision 1.3  2003/12/28 23:00:12  kerdels
 * tactic chooser berarbeitet
 *
 * Revision 1.2  2003/12/17 23:58:06  huelsbusch
 * startet work on option-choosing
 *
 * Revision 1.1  2003/12/11 18:28:22  kerdels
 * DTT Framework fertiggestellt.
 *
 *
 */
