/**
* @file GoalieCoach.cpp
* 
* Implementation of class GoalieCoach
*
*/

#include <math.h>
#include "GoalieCoach.h"
#include "Tools/DynamicTeamTactic/RateableOptions.h"

GoalieCoach::GoalieCoach(const BehaviorControlInterfaces& interfaces)
: GlobalAnalyser(interfaces)
{
	lastTimeBallOponentsite = SystemCall::getCurrentSystemTime();
}

void GoalieCoach::update()
{
//  INFO(sendOptionRatings, idText, text, "Goalicoach");

  // fill in here calcWeights[] Array...
  double clear=0;
  double ballFact = 1.0;
 
//  double xposBall = ballPosition.getKnownPosition(100).x;
//  double yposBall = ballPosition.getKnownPosition(100).y;
  double xposBall = ballPosition.getKnownPosition(1500).x;
  double yposBall = ballPosition.getKnownPosition(1500).y;

  double xposGoalie = 0.0;
  double yposGoalie = 0.0;
  bool goalieFound(false);
  if ( getPlayer().getPlayerNumber() == Player::one )
  {
		xposGoalie = robotPose.getPose().translation.x;
		yposGoalie = robotPose.getPose().translation.y;
    goalieFound = true;
  }
  else
  {
   for(int i = 0; i < playerPoseCollection.numberOfOwnPlayers; ++i)
     if (playerPoseCollection.getOwnPlayerPose(i).getPlayerNumber() == Player::one)
     {
       xposGoalie = playerPoseCollection.getOwnPlayerPose(i).getPose().translation.x;
       yposGoalie = playerPoseCollection.getOwnPlayerPose(i).getPose().translation.y;
       goalieFound = true;
     }
  }

  if (xposBall > 2100)
    xposBall = 2100;
  if (xposBall < -2100)
    xposBall = -2100;

  if (xposBall > -1050)
  {
//    ballFact = fabs(xpos / -1050);
    ballFact = (xposBall / -1050);
    if (ballFact < 0)
      ballFact = 0;
    if (ballFact > 1)
      ballFact = 1;
  }

  // wenn ball vor kurzem ber die Mittelline gekommen ist
  // darf der Goali ClearBall
  double timeBallOwnSite=1;
  if (xposBall > 0)
  {
	  lastTimeBallOponentsite = SystemCall::getCurrentSystemTime();
  }
  else
  {
	  timeBallOwnSite = (1+fabs((double)SystemCall::getTimeSince(lastTimeBallOponentsite)))/1000;
//INFO(sendOptionRatings, idText, text, "timeBallOwnSite: "<< timeBallOwnSite);
  //+ GegerPos
  }

  if (goalieFound)
  {
	  //nicht genau aber schnell
	  double distance = max( fabs(xposBall-xposGoalie), fabs(yposBall-yposGoalie) );
	  distance = (170*170)/(distance*distance);
	//INFO(sendOptionRatings, idText, text, "distance: "<< distance);
	//  distance = distance+distance/(timeBallOwnSite);
	//  if (distance > 1) distance = 1;
	//  if (distance < 0) distance = 0;
	  if (clear<distance)
		  clear = distance;

	  //absolute Position
	  double disgoal;
	  disgoal = max( fabs(xposBall+2100), fabs(yposBall-0) );
	  disgoal = 300*300/(disgoal*disgoal);
	//INFO(sendOptionRatings, idText, text, "disgoal: "<< disgoal);
	  if (clear<disgoal)
		  clear = disgoal;

//      INFO(sendOptionRatings, idText, text, "clear: "<< clear<<" disgoal: "<<disgoal);
  }else
  {
//      INFO(sendOptionRatings, idText, text, "clear: "<< clear);
  }


  if (clear > 1) clear = 1;
  if (clear < 0) clear = 0;
  

  // Goalie-coaching has to be implemented !

	calcWeights[RateableOptions::gc_Neutral    - RateableOptions::gc_Neutral] = 1.0;
	calcWeights[RateableOptions::gc_ClearBall  - RateableOptions::gc_Neutral] = clear;
	calcWeights[RateableOptions::gc_StayInGoal - RateableOptions::gc_Neutral] = ballFact;

//  INFO(sendOptionRatings, idText, text, "clear: "<< clear<<" disgoal: "<<disgoal);
//  INFO(sendOptionRatings, idText, text, "gc_StayInGoal: "<< ballFact);
/*
 OUTPUT(idText,text,"");
 OUTPUT(idText,text,"");
 OUTPUT(idText,text,"Clear: "<< clear);
 OUTPUT(idText,text,"ballFact: "<< ballFact);
*/
}

double GoalieCoach::getWeight(RateableOptions::TacticEntryTypeID tacticEntryType)
{
  return calcWeights[tacticEntryType - RateableOptions::gc_Neutral];
}


/*
 * Change log :
 * $Log: GoalieCoach.cpp,v $
 * Revision 1.13  2004/05/12 19:33:13  kerdels
 * merged the behavior changes during australian, american and japan open
 *
 * Revision 1.12  2004/04/08 15:33:04  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.12  2004/03/21 04:36:05  pg_joke
 * added slidingAverage to OptionRatings,
 * added ratingBoost (Hysteresis) to OptionRatings
 *
 * Revision 1.11  2004/03/08 01:07:10  roefer
 * Interfaces should be const
 *
 * Revision 1.10  2004/03/01 12:50:05  hamerla
 * no message
 *
 * Revision 1.9  2004/02/26 18:07:28  cesarz
 * first version of evolution behavior
 *
 * Revision 1.8  2004/02/25 23:16:50  hamerla
 * changes RoboPose to GoaliePose for clearKick
 *
 * Revision 1.7  2004/02/24 16:22:33  hamerla
 * changes clear Ball
 *
 * Revision 1.6  2004/02/17 19:04:26  kerdels
 * removed save-bug in tacticDesigner,
 * set all TacticEntrys in default.dtt to GoalieCoach::Neutral,
 * commented out some OUPUT stuff in GoalieCoach.cpp
 *
 * Revision 1.5  2004/02/16 17:09:34  hamerla
 * no message
 *
 * Revision 1.4  2004/02/12 16:20:30  kerdels
 * adjusted some ratings for simple-kick use
 *
 * Revision 1.3  2004/02/11 17:00:11  hamerla
 * Bug
 *
 * Revision 1.2  2004/02/11 16:17:36  hamerla
 * no message
 *
 * Revision 1.1  2004/02/03 23:47:33  kerdels
 * added GoalieCoach and adjusted tactics.dat.
 *
 *
 *
 */
