/**
 * @file GoalieCoach.h
 * 
 * Implementation of class GoalieCoach.
 *
 * @author <A href=mailto:jochen@kerdels.de>Jochen Kerdels</A>
 */

#ifndef __GoalieCoach_h_
#define __GoalieCoach_h_

#include "Tools/DynamicTeamTactic/GlobalAnalyser.h"


/**
* @class GoalieCoach
*
* A simple implementation of the GoalieCoach class.
*
*/
class GoalieCoach : public GlobalAnalyser
{
private:
  
  double calcWeights[RateableOptions::gc_Max - RateableOptions::gc_Neutral];
  unsigned long lastTimeBallOponentsite;
public:

  /** 
   * Constructor.
   * @param interfaces The parameters of the GoalieCoach class.
   */
  GoalieCoach(const BehaviorControlInterfaces& interfaces);

	virtual void update();

	virtual double getWeight(RateableOptions::TacticEntryTypeID tacticEntryType);

};

#endif // __GoalieCoach_h_

/*
 * Change log :
 * $Log: GoalieCoach.h,v $
 * Revision 1.3  2004/03/08 01:07:10  roefer
 * Interfaces should be const
 *
 * Revision 1.2  2004/02/11 16:17:34  hamerla
 * no message
 *
 * Revision 1.1  2004/02/03 23:47:33  kerdels
 * added GoalieCoach and adjusted tactics.dat.
 *
 *
 *
 */
