/**
* @file OffDefAnalyser.cpp
* 
* Implementation of class OffDefAnalyser
*
*/

#include <math.h>
#include "OffDefAnalyser.h"
#include "Tools/DynamicTeamTactic/RateableOptions.h"

OffDefAnalyser::OffDefAnalyser(const BehaviorControlInterfaces& interfaces)
: GlobalAnalyser(interfaces)
{
}

void OffDefAnalyser::update()
{
  // fill in here calcWeights[] Array...
  double xpos = ballPosition.getKnownPosition(1500).x;
  if (xpos > 500)
    xpos = 500;
  if (xpos < -250)
    xpos = -250;
  double val = (xpos + 250) / 750;

  /*
  int playersInOwnHalf = 0;
  int i;
	for (i=0; i < playerPoseCollection.numberOfOwnPlayers; ++i)
    if (playerPoseCollection.getOwnPlayerPose(i).getPose().translation.x < 0)
      playersInOwnHalf++;
  if (robotPose.translation.x < 0)  
    playersInOwnHalf++;

  for (i=0; i < playerPoseCollection.numberOfOpponentPlayers; ++i) {
	  if (playerPoseCollection.getOpponentPlayerPose(i).getPose().translation.x < 0)
      playersInOwnHalf--;
	}

  if (playersInOwnHalf < 0)
    playersInOwnHalf = 0;
  */

  int playersInOpponentHalf = 0;
  int i;
	for (i=0; i < playerPoseCollection.numberOfOwnPlayers; ++i)
    if (playerPoseCollection.getOwnPlayerPose(i).getPose().translation.x > 0)
      playersInOpponentHalf++;
  if (robotPose.translation.x > 0)  
    playersInOpponentHalf++;
  
	calcWeights[RateableOptions::offDef_Neutral - RateableOptions::offDef_Neutral]   = 1.0;
	calcWeights[RateableOptions::offDef_Offensive - RateableOptions::offDef_Neutral] = val * 1.5; // + (playersInOwnHalf / 2); // to give the game a forward direction
	calcWeights[RateableOptions::offDef_Defensive - RateableOptions::offDef_Neutral] = (1-val) * (1.5 + playersInOpponentHalf);
}

double OffDefAnalyser::getWeight(RateableOptions::TacticEntryTypeID tacticEntryType)
{
  return calcWeights[tacticEntryType - RateableOptions::offDef_Neutral];
}


/*
 * Change log :
 * $Log: OffDefAnalyser.cpp,v $
 * Revision 1.13  2004/05/12 19:33:13  kerdels
 * merged the behavior changes during australian, american and japan open
 *
 * Revision 1.12  2004/04/08 15:33:04  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.12  2004/03/25 14:13:41  pg_joke
 * strengthend defensiv tacticEntrys
 *
 * Revision 1.11  2004/03/08 01:07:11  roefer
 * Interfaces should be const
 *
 * Revision 1.10  2004/02/09 09:12:25  kerdels
 * adjusted weights
 *
 * Revision 1.9  2004/02/06 09:39:52  kerdels
 * modified some ratings, adjusted weights in tactics/tbase.dat
 *
 * Revision 1.8  2004/01/09 10:10:40  kerdels
 * some fine tuning
 *
 * Revision 1.7  2004/01/08 22:00:27  kerdels
 * warning entfernt
 *
 * Revision 1.6  2004/01/08 21:55:31  kerdels
 * OffDefAnalyser verbessert
 *
 * Revision 1.5  2004/01/04 15:02:12  kerdels
 * OffDefAnalyser erweitert
 *
 * Revision 1.4  2004/01/04 01:00:46  kerdels
 * TacticDesigner hinzugefgt
 *
 * Revision 1.3  2004/01/01 00:03:25  kerdels
 * tacticEntryArray Streaming berarbeitet
 *
 * Revision 1.2  2003/12/29 21:35:12  kerdels
 * tactics beispiel hinzugefgt,
 * laden aus datei im tacticchooser
 *
 * Revision 1.1  2003/12/29 12:26:27  kerdels
 * global analysis hinzugefgt
 *
 *
 *
 */
