/**
* @file MSH2004KickEngineKick.h
* 
* Implementation of class MSH2004KickEngineKick.h
*
* @author Carsten Schumann (schumann@tempus-vivit.net)
*/

#ifndef __MSH2004KickEngineKick_h_
#define __MSH2004KickEngineKick_h_
 
#include "Representations/Motion/MotionRequest.h"
#include "Tools/List.h"
#include "Tools/Streams/InStreams.h"
#include "Tools/Streams/OutStreams.h"




struct MSH2004KickEngineKickResult{
public:
  short unsigned int distance;
  short unsigned int sector;
  short unsigned int count;
} ;

class MSH2004KickEngineKick
{
public:
  MSH2004KickEngineKick(MotionRequest::SpecialActionID);
  MSH2004KickEngineKick(MotionRequest::SpecialActionID, unsigned short int trainingTries);
  ~MSH2004KickEngineKick();
  void addKick(unsigned short int sector, unsigned short int distance);
  MotionRequest::SpecialActionID getKickID();

  double getSuccessRate(unsigned short int kickSector,unsigned short int kickDistance);
  double getSuccessRate(unsigned short int kickSector,unsigned short int kickDistance, double maxKickTolerance,double distanceForKickSector, double distanceForKickDistance);
  //  MotionRequest::SpecialActionID getPreferredKick();

  bool kickKnown();
  bool goodResultKnown();
  void registerTry();
  void save(Out& stream);
  void loadTries(In& stream, char* buffer);
  void loadResults(In& stream, char* buffer);


private:
  MotionRequest::SpecialActionID kickID;
  unsigned short int kickCount;
  unsigned short int trainingTries;
  List<MSH2004KickEngineKickResult>* kickResults;
  double getTolerance(int alter_ks, int alter_kd, double distanceForKickSector, double distanceForKickDistance);


  friend Out& operator<<(Out& stream,const MSH2004KickEngineKick& entry);
  friend In& operator>>(In& stream,MSH2004KickEngineKick& entry);

};


/**
* Streaming operator that reads a KickEngineKick from a stream.
* @param stream The stream from which is read.
* @param kickEngineKick The object.
* @return The stream.
*/ 
In& operator>>(In& stream,MSH2004KickEngineKick& entry);

/**
* Streaming operator that writes a KickEngineKick to a stream.
* @param stream The stream to write on.
* @param kickEngineKick The object.
* @return The stream.
*/ 
Out& operator<<(Out& stream, const MSH2004KickEngineKick& entry);


#endif

/*
 * Change log :
 * 
 * $Log: MSH2004KickEngineKick.h,v $
 * Revision 1.5  2004/04/08 15:33:04  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.7  2004/03/26 15:31:34  pg_cars
 * Improved data file format, improved debugging
 *
 * Revision 1.6  2004/03/26 09:21:49  pg_cars
 * datafile changed, aggressive kick engine
 *
 * Revision 1.5  2004/03/25 21:05:24  pg_cars
 * change of datafile, before backup
 *
 * Revision 1.4  2004/03/15 15:59:46  schumann
 * splitted symbols for kick engine from other symbols
 *
 * Revision 1.3  2004/03/09 14:13:32  schumann
 * changed training for kickengine
 *
 * Revision 1.2  2004/03/04 08:37:41  schumann
 * added neighbourhood search
 *
 * Revision 1.1  2004/02/24 13:51:05  schumann
 * Changed structure of kick engine
 *
 * Revision 1.1  2004/02/23 12:51:37  schumann
 * Added MSH2004KickEngine
 *
*/

