/** 
* @file MSH2004DTTSymbols.cpp
*
* Implementation of class MSH2004DTTSymbols.
*
* @author Jochen Kerdels
*/

#include "MSH2004DTTSymbols.h"
#include "Tools/DynamicTeamTactic/RateableOptions.h"
#include "Modules/BehaviorControl/MSH2004BehaviorControl/OpenChallengeDefines.h"

MSH2004DTTSymbols::MSH2004DTTSymbols(const BehaviorControlInterfaces& interfaces,
																		 TacticChooser** tacticChooser,
                                     bool& kickInProgress)
: BehaviorControlInterfaces(interfaces), kickInProgress(kickInProgress)
{
	actualTacticChooser = tacticChooser;
	actualOption = RateableOptions::noOption;
  actualOptionType = RateableOptions::special;

  intercept1.x = 0;
  intercept1.y = 0;
  intercept2.x = 0;
  intercept2.y = 0;
  intercept3.x = 0;
  intercept3.y = 0;
  intercept4.x = 0;
  intercept4.y = 0;

}


void MSH2004DTTSymbols::registerSymbols(Xabsl2Engine& engine)
{
  // "default-dtt"
	engine.registerEnumeratedInputSymbol("default-dtt",(int *)&actualOption);
	// add here new Options
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","doStand"                       ,(int)RateableOptions::stand);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","doNothing"                 ,(int)RateableOptions::doNothing);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","noOption"                  ,(int)RateableOptions::noOption);
#ifndef OPENCHALLENGE_DEFINES
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToFrontLeft"             ,(int)RateableOptions::goToFrontLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToFrontPenLeft"          ,(int)RateableOptions::goToFrontPenLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToFrontMiddle"           ,(int)RateableOptions::goToFrontMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToFrontPenRight"         ,(int)RateableOptions::goToFrontPenRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToFrontRight"            ,(int)RateableOptions::goToFrontRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToMiddleLeft"            ,(int)RateableOptions::goToMiddleLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToMiddle"                ,(int)RateableOptions::goToMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToMiddleRight"           ,(int)RateableOptions::goToMiddleRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToBehindLeft"            ,(int)RateableOptions::goToBehindLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToBehindMiddle"          ,(int)RateableOptions::goToBehindMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToBehindRight"           ,(int)RateableOptions::goToBehindRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToCatenaccioLeft"        ,(int)RateableOptions::goToCatenaccioLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToCatenaccioMiddle"      ,(int)RateableOptions::goToCatenaccioMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToCatenaccioRight"       ,(int)RateableOptions::goToCatenaccioRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","approachCloseBall"         ,(int)RateableOptions::approachCloseBall);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToBall"                  ,(int)RateableOptions::goToBall);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToBallFrontLeft"         ,(int)RateableOptions::goToBallFrontLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToBallFrontMiddle"       ,(int)RateableOptions::goToBallFrontMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToBallFrontRight"        ,(int)RateableOptions::goToBallFrontRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToBallMiddleLeft"        ,(int)RateableOptions::goToBallMiddleLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToBallMiddle"            ,(int)RateableOptions::goToBallMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToBallMiddleRight"       ,(int)RateableOptions::goToBallMiddleRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToBallBehindLeft"        ,(int)RateableOptions::goToBallBehindLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToBallBehindMiddle"      ,(int)RateableOptions::goToBallBehindMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToBallBehindRight"       ,(int)RateableOptions::goToBallBehindRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToBallGoalie"                ,(int)RateableOptions::goToBallGoalie);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goIntoOwnGoal"             ,(int)RateableOptions::goIntoOwnGoal);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","doJumpDefend"              ,(int)RateableOptions::doJumpDefend);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","doJumpLeft"                ,(int)RateableOptions::doJumpLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","doJumpRight"               ,(int)RateableOptions::doJumpRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToGoal"                ,(int)RateableOptions::kickToGoal);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToGoalFromFrontLeft"       ,(int)RateableOptions::kickToGoalFromFrontLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToGoalFromFrontMiddle"     ,(int)RateableOptions::kickToGoalFromFrontMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToGoalFromFrontRight"      ,(int)RateableOptions::kickToGoalFromFrontRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToGoalFromMiddleLeft"      ,(int)RateableOptions::kickToGoalFromMiddleLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToGoalFromMiddle"          ,(int)RateableOptions::kickToGoalFromMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToGoalFromMiddleRight"     ,(int)RateableOptions::kickToGoalFromMiddleRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToGoalFromBehindLeft"      ,(int)RateableOptions::kickToGoalFromBehindLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToGoalFromBehindMiddle"    ,(int)RateableOptions::kickToGoalFromBehindMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToGoalFromBehindRight"     ,(int)RateableOptions::kickToGoalFromBehindRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToTeammate1"           ,(int)RateableOptions::kickToTeammate1);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToTeammate2"           ,(int)RateableOptions::kickToTeammate2);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToTeammate3"           ,(int)RateableOptions::kickToTeammate3);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToClear"               ,(int)RateableOptions::kickToClear);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToClearFromFrontLeft"      ,(int)RateableOptions::kickToClearFromFrontLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToClearFromFrontMiddle"    ,(int)RateableOptions::kickToClearFromFrontMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToClearFromFrontRight"     ,(int)RateableOptions::kickToClearFromFrontRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToClearFromMiddleLeft"     ,(int)RateableOptions::kickToClearFromMiddleLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToClearFromMiddle"         ,(int)RateableOptions::kickToClearFromMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToClearFromMiddleRight"    ,(int)RateableOptions::kickToClearFromMiddleRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToClearFromBehindLeft"     ,(int)RateableOptions::kickToClearFromBehindLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToClearFromBehindMiddle"   ,(int)RateableOptions::kickToClearFromBehindMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToClearFromBehindRight"    ,(int)RateableOptions::kickToClearFromBehindRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","kickToClearGoalie"             ,(int)RateableOptions::kickToClearGoalie);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","intercept1"                ,(int)RateableOptions::intercept1);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","intercept2"                ,(int)RateableOptions::intercept2);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","intercept3"                ,(int)RateableOptions::intercept3);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","intercept4"                ,(int)RateableOptions::intercept4);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","handleBallLeftBorder"      ,(int)RateableOptions::handleBallLeftBorder);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","handleBallRightBorder"     ,(int)RateableOptions::handleBallRightBorder);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","dribbleToFront"            ,(int)RateableOptions::dribbleToFront);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","bananaCrossFromLeft"       ,(int)RateableOptions::bananaCrossFromLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","bananaCrossFromRight"      ,(int)RateableOptions::bananaCrossFromRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","doRollLeft"                ,(int)RateableOptions::doRollLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","doRollRight"               ,(int)RateableOptions::doRollRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","turnForBall"               ,(int)RateableOptions::turnForBall);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToGoaliePos"             ,(int)RateableOptions::goToGoaliePos);

  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","backUp"                    ,(int)RateableOptions::backUp);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","waveLeft"                  ,(int)RateableOptions::waveLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","waveRight"                 ,(int)RateableOptions::waveRight);
  
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToGoal"             ,(int)RateableOptions::newKickToGoal);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToGoalFromFrontLeft"    ,(int)RateableOptions::newKickToGoalFromFrontLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToGoalFromFrontMiddle"  ,(int)RateableOptions::newKickToGoalFromFrontMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToGoalFromFrontRight"   ,(int)RateableOptions::newKickToGoalFromFrontRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToGoalFromMiddleLeft"   ,(int)RateableOptions::newKickToGoalFromMiddleLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToGoalFromMiddle"       ,(int)RateableOptions::newKickToGoalFromMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToGoalFromMiddleRight"  ,(int)RateableOptions::newKickToGoalFromMiddleRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToGoalFromBehindLeft"   ,(int)RateableOptions::newKickToGoalFromBehindLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToGoalFromBehindMiddle" ,(int)RateableOptions::newKickToGoalFromBehindMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToGoalFromBehindRight"  ,(int)RateableOptions::newKickToGoalFromBehindRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToTeammate1"        ,(int)RateableOptions::newKickToTeammate1);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToTeammate2"        ,(int)RateableOptions::newKickToTeammate2);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToTeammate3"        ,(int)RateableOptions::newKickToTeammate3);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToClear"            ,(int)RateableOptions::newKickToClear);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToClearFromFrontLeft"   ,(int)RateableOptions::newKickToClearFromFrontLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToClearFromFrontMiddle" ,(int)RateableOptions::newKickToClearFromFrontMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToClearFromFrontRight"  ,(int)RateableOptions::newKickToClearFromFrontRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToClearFromMiddleLeft"  ,(int)RateableOptions::newKickToClearFromMiddleLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToClearFromMiddle"      ,(int)RateableOptions::newKickToClearFromMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToClearFromMiddleRight" ,(int)RateableOptions::newKickToClearFromMiddleRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToClearFromBehindLeft"  ,(int)RateableOptions::newKickToClearFromBehindLeft);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToClearFromBehindMiddle",(int)RateableOptions::newKickToClearFromBehindMiddle);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToClearFromBehindRight" ,(int)RateableOptions::newKickToClearFromBehindRight);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","newKickToClearGoalie"          ,(int)RateableOptions::newKickToClearGoalie);

  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToMiddleAtBall"          ,(int)RateableOptions::goToMiddleAtBall);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToFrontAtBall"               ,(int)RateableOptions::goToFrontAtBall);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToBehindAtBall"              ,(int)RateableOptions::goToBehindAtBall);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToRightAtBall"               ,(int)RateableOptions::goToRightAtBall);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","goToLeftAtBall"                ,(int)RateableOptions::goToLeftAtBall);
#else
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCintro"                ,(int)RateableOptions::intro);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCextro"                ,(int)RateableOptions::extro);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCfinished"             ,(int)RateableOptions::finished);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCgotoBitePos1"         ,(int)RateableOptions::gotoBitePos1);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCgotoBitePos2"         ,(int)RateableOptions::gotoBitePos2);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCgotoBitePos3"         ,(int)RateableOptions::gotoBitePos3);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCgotoBitePos4"         ,(int)RateableOptions::gotoBitePos4);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCbitePos1"             ,(int)RateableOptions::bitePos1);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCbitePos2"             ,(int)RateableOptions::bitePos2);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCbitePos3"             ,(int)RateableOptions::bitePos3);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCbitePos4"             ,(int)RateableOptions::bitePos4);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCmovePos1"             ,(int)RateableOptions::movePos1);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCmovePos2"             ,(int)RateableOptions::movePos2);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCmovePos3"             ,(int)RateableOptions::movePos3);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCmovePos4"             ,(int)RateableOptions::movePos4);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCgotoBridge"           ,(int)RateableOptions::gotoBridge);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCclimbBridge"          ,(int)RateableOptions::climbBridge);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCmoveBridge"           ,(int)RateableOptions::moveBridge);
  engine.registerEnumeratedInputSymbolEnumElement("default-dtt","OCWaitForBiteDogs"      ,(int)RateableOptions::waitForBiteDogs);

#endif

  engine.registerDecimalInputSymbol("intercept1.x",&(intercept1.x));
  engine.registerDecimalInputSymbol("intercept1.y",&(intercept1.y));
  engine.registerDecimalInputSymbol("intercept2.x",&(intercept2.x));
  engine.registerDecimalInputSymbol("intercept2.y",&(intercept2.y));
  engine.registerDecimalInputSymbol("intercept3.x",&(intercept3.x));
  engine.registerDecimalInputSymbol("intercept3.y",&(intercept3.y));
  engine.registerDecimalInputSymbol("intercept4.x",&(intercept4.x));
  engine.registerDecimalInputSymbol("intercept4.y",&(intercept4.y));
  engine.registerDecimalInputSymbol("goaliePos.x",&(goaliePos.x));
  engine.registerDecimalInputSymbol("goaliePos.y",&(goaliePos.y));
  engine.registerDecimalInputSymbol("backUpPos.x",&(backUpPos.x));
  engine.registerDecimalInputSymbol("backUpPos.y",&(backUpPos.y));

  // "dtt-option-type"
	engine.registerEnumeratedInputSymbol("dtt-option-type",(int *)&actualOptionType);
	// add here new Options
  engine.registerEnumeratedInputSymbolEnumElement("dtt-option-type","special"        ,(int)RateableOptions::special);
  engine.registerEnumeratedInputSymbolEnumElement("dtt-option-type","gotoPos"        ,(int)RateableOptions::gotoPos);
  engine.registerEnumeratedInputSymbolEnumElement("dtt-option-type","gotoBallPos"    ,(int)RateableOptions::gotoBallPos);
  engine.registerEnumeratedInputSymbolEnumElement("dtt-option-type","kickAction"     ,(int)RateableOptions::kickAction);
  engine.registerEnumeratedInputSymbolEnumElement("dtt-option-type","goalieAction"   ,(int)RateableOptions::goalieAction);

  // "kick.status"
  engine.registerEnumeratedOutputSymbol("dtt.kick.status", this, (void (Xabsl2FunctionProvider::*)(int))&MSH2004DTTSymbols::setKickStatus );
  engine.registerEnumeratedOutputSymbolEnumElement("dtt.kick.status","dtt.kick.status.started", 0);
  engine.registerEnumeratedOutputSymbolEnumElement("dtt.kick.status","dtt.kick.status.stopped", 1);

}

void MSH2004DTTSymbols::update()
{
	actualOption = (*actualTacticChooser)->chooseOption();
  
  if (playerPoseCollection.numberOfOpponentPlayers >= 1)
  {
    intercept1.x = (-2100 + playerPoseCollection.getOpponentPlayerPose(0).getPose().translation.x) / 2;
    intercept1.y = ( 0 + playerPoseCollection.getOpponentPlayerPose(0).getPose().translation.y) / 2;
  } else {
    intercept1.x = robotPose.translation.x;
    intercept1.y = robotPose.translation.y;
  }

  if (playerPoseCollection.numberOfOpponentPlayers >= 2)
  {
    intercept2.x = (-2100 + playerPoseCollection.getOpponentPlayerPose(1).getPose().translation.x) / 2;
    intercept2.y = ( 0 + playerPoseCollection.getOpponentPlayerPose(1).getPose().translation.y) / 2;
  } else {
    intercept2.x = robotPose.translation.x;
    intercept2.y = robotPose.translation.y;
  }

  if (playerPoseCollection.numberOfOpponentPlayers >= 3)
  {
    intercept3.x = (-2100 + playerPoseCollection.getOpponentPlayerPose(2).getPose().translation.x) / 2;
    intercept3.y = ( 0 + playerPoseCollection.getOpponentPlayerPose(2).getPose().translation.y) / 2;
  } else {
    intercept3.x = robotPose.translation.x;
    intercept3.y = robotPose.translation.y;
  }

  if (playerPoseCollection.numberOfOpponentPlayers >= 4)
  {
    intercept4.x = (-2100 + playerPoseCollection.getOpponentPlayerPose(3).getPose().translation.x) / 2;
    intercept4.y = ( 0 + playerPoseCollection.getOpponentPlayerPose(3).getPose().translation.y) / 2;
  } else {
    intercept4.x = robotPose.translation.x;
    intercept4.y = robotPose.translation.y;
  }

  goaliePos.x = (ballPosition.getKnownPosition(100).x - (-2300) );
  goaliePos.y = (ballPosition.getKnownPosition(100).y - 0);  
  goaliePos = goaliePos.normalize() * 500;
  goaliePos.x += -2300;
  if (goaliePos.x < -2000)
    goaliePos.x = -2000;

  Vector2<double> robotOrient;
  robotOrient.x = cos(robotPose.rotation);
	robotOrient.y = sin(robotPose.rotation);
  robotOrient *= -300;

  backUpPos.x = robotPose.translation.x + robotOrient.x;
  backUpPos.y = robotPose.translation.y + robotOrient.y;

  actualOptionType = RateableOptions::getOptionType(actualOption);
}

void MSH2004DTTSymbols::setKickStatus(int number)
{
  if (number == 0)
    kickInProgress = true;
  else 
    kickInProgress = false;
}

  

/*
* Change Log
* 
* $Log: MSH2004DTTSymbols.cpp,v $
* Revision 1.54  2004/06/21 11:52:53  hamerla
* OpenChallenge
*
* Revision 1.53  2004/06/07 22:43:26  kerdels
* added a dtt-switch for open-challenge,
* merged a bugfix for optionratingdlgbar from local-cvs to tamara,
* created tactic-entries for openchallenge
*
* Revision 1.52  2004/06/07 16:00:57  hamerla
* OptionRation fr OpenChallenge
*
* Revision 1.51  2004/05/12 19:33:13  kerdels
* merged the behavior changes during australian, american and japan open
*
* Revision 1.50  2004/04/14 06:37:16  loetzsch
* removed the hack "kickInProgress" from the BehaviorControlInterfaces
*
* Revision 1.49  2004/04/08 15:33:04  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.53  2004/03/29 12:24:56  pg_tilo
* dtt-symbols:
* kick.status added
* stand renamed in doStand
*
* simple-kick:
* kick.status added
*
* Revision 1.52  2004/03/29 11:34:12  pg_joke
* added output symbols kick.status.started and kick.status.stopped
*
* Revision 1.51  2004/03/24 15:32:10  pg_joke
* added a kickToClearGoalie and a newKickToClearGoalie Option
*
* Revision 1.50  2004/03/24 15:11:35  pg_joke
* added location dependend kickratings to improve team-behavior
*
* Revision 1.49  2004/03/24 12:54:24  pg_joke
* added GoToBallGoalie
*
* Revision 1.48  2004/03/10 21:44:30  kerdels
* added goToMiddleAtBall Option
*
* Revision 1.47  2004/03/09 19:53:29  kerdels
* removed a myterious error ...
*
* Revision 1.46  2004/03/08 01:07:12  roefer
* Interfaces should be const
*
* Revision 1.45  2004/03/01 17:14:05  kerdels
* added robot-pose.distance-to-opponent-goal,
* moved robot-pose.angle-to-teammate1-3 to MSH2004StrategySymbols as fieldpos.angle-to-teammate1-3,
* added fieldpos.distance-to-teammate1-3,
* added DTT-Options newKickToGoal, newKickToClear, newKickToTeammate1-3,
* added DTT-OptionClass newKickToTeammate,
* added kickToPosRating function in DefaultOptionRating
*
* Revision 1.44  2004/02/28 11:20:16  kerdels
* removed single kicks from behavior...
*
* Revision 1.43  2004/02/19 17:01:10  kerdels
* added goalie-switch with two demo-options waveLeft and waveRight
*
* Revision 1.42  2004/02/19 16:27:05  kerdels
* rated backUp option,
* made modifications discussed with michael,
* added backUp option to default.dtt
*
* Revision 1.41  2004/02/18 23:32:58  kerdels
* added goToFrontPenLeft, goToFrontPenRight
* added backUp, not rated yet
* splittet goto-switch.xml in goto-switch.xml and gotoBall-switch.xml
*
* Revision 1.40  2004/02/04 23:26:41  kerdels
* added kicksToClear, clearkick-switch and option-type, specialKickToClear optionClass and apropriate ratings,
* modified GoToBallPos ratings
*
* Revision 1.39  2004/02/04 17:48:06  kerdels
* heelKicks removed
*
* Revision 1.38  2004/02/03 12:51:53  lohmann
* BananaCross splitted into Left and Right.
*
* Revision 1.37  2004/02/02 16:33:58  kerdels
* added DTT-options goToCatenaccioLeft, goToCatenaccioMiddle and goToCatenaccioRight.
* Also added catfun.dat to test this new options
*
* Revision 1.36  2004/02/02 12:23:45  lohmann
* unsw-bash-optimized-kick added
*
* Revision 1.35  2004/01/29 23:56:35  kerdels
* added special goalie position to DTT
*
* Revision 1.34  2004/01/29 23:23:54  kerdels
* added symbol to dtt-symbols and put the radiobuttons in WLAN-Dialog to work... ok... with a hack
*
* Revision 1.33  2004/01/29 21:33:28  kerdels
* added turn-for-ball Option to DTT,
* added link between TacticChooser and OptionRating
*
* Revision 1.32  2004/01/28 23:27:32  kerdels
* added rollLeft and rollRight Option to DTT,
* rating has to be adjusted
*
* Revision 1.31  2004/01/28 00:01:46  kerdels
* added legKick, leftKick, rightKick, chestKick, leftHeadKick, rightHeadKick and fastDiveKick to DTT
*
* Revision 1.30  2004/01/27 22:26:55  kerdels
* added fastHeadKicks to DTT
*
* Revision 1.29  2004/01/27 14:25:43  lohmann
* Banana Cross added.
*
* Revision 1.28  2004/01/27 02:32:19  kerdels
* restructuring the restructuring of our xabsl-stuff... +
* found and removed a bad bug in collectedBeliefs.cpp
*
* Revision 1.27  2004/01/26 21:33:31  kerdels
* added swimKicks
*
* Revision 1.26  2004/01/26 20:40:49  kerdels
* added pawKickRight
*
* Revision 1.25  2004/01/26 18:45:05  kerdels
* added pawKickLeft
*
* Revision 1.24  2004/01/26 18:02:17  kerdels
* added heel-kicks to dtt
*
* Revision 1.23  2004/01/25 21:22:56  kerdels
* added mantisKickToTeammates
*
* Revision 1.22  2004/01/25 12:17:23  kerdels
* added first single-kick-option "mantisKick" and modified aging of ratedOptions
*
* Revision 1.21  2004/01/22 23:16:38  kerdels
* dribbel-option hinzugefgt
*
* Revision 1.20  2004/01/22 22:28:46  kerdels
* Optionen fr Bandenverhalten hinzugefuegt
*
* Revision 1.19  2004/01/22 17:18:26  kerdels
* intercept-options hinzugefgt
*
* Revision 1.18  2004/01/08 00:27:16  kerdels
* added dtt-options:
* kickToTeammate1-3
* rating davon noch verbesserungswrdig
*
* Revision 1.17  2004/01/07 17:15:07  kerdels
* added DTT-Option kickToGoal
*
* Revision 1.16  2004/01/06 21:09:38  kerdels
* added some Reflex Options,
* not rated yet
*
* Revision 1.15  2004/01/06 18:43:25  kerdels
* added some DTT-Options,
* modified tactics.dat
*
* Revision 1.14  2004/01/04 13:59:52  kerdels
* DTT-Options erstellt
*
* Revision 1.13  2003/12/25 22:02:49  kerdels
* option goToBall added to dTT
*
* Revision 1.12  2003/12/25 21:26:19  kerdels
* some options modified
*
* Revision 1.11  2003/12/25 19:13:00  kerdels
* added approachCloseBall to DTT
*
* Revision 1.10  2003/12/23 19:22:48  kerdels
* FieldPosOptions und Ratings hinzugefgt
*
* Revision 1.9  2003/12/22 20:06:57  kerdels
* goToFrontLeft mini-demo gebastelt
*
* Revision 1.8  2003/12/22 18:50:27  kerdels
* goToFrontLeft hinzugefgt
*
* Revision 1.7  2003/12/21 14:35:50  kerdels
* option doNothing zum dtt hinzugefgt
*
* Revision 1.6  2003/12/21 14:14:21  kerdels
* option doNothing hinzugefgt
*
* Revision 1.5  2003/12/18 00:12:59  kerdels
* inserted dtt in msh2004 behavior
*
* Revision 1.4  2003/12/17 20:51:29  kerdels
* Updated dtt-symbols
*
* Revision 1.3  2003/12/11 19:36:59  kerdels
* Debugged.
*
* Revision 1.2  2003/12/11 18:28:21  kerdels
* DTT Framework fertiggestellt.
*
* Revision 1.1  2003/12/11 17:07:25  kerdels
* Symbols fr DTT erstellt.
*
*
*/

