/** 
* @file MSH2004EvoSymbols.h
*
* Declaration of class MSH2004EvoSymbols.
*
* @author Arthur Cesarz
*/

#ifndef __MSH2004EvoSymbols_h_
#define __MSH2004EvoSymbols_h_

#include "../../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

/**
* The Xabsl2 symbols that are defined in "evo-symbols.xml"
*
* @author Arthur Cesarz
*/ 
class MSH2004EvoSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
  /*
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  MSH2004EvoSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
  /** reads the file evo-walk.cfg */
  void ReadConfigFile();
  
  /** parameters "evo-point-0.x", "evo-point-0.y", "evo-point-1.x"and "evo-point-1.y" */
  Vector2<double> evoPoint0, evoPoint1;
  
  /** the robots orientation during walk "evo-walk-angle"*/
  double evoWalkAngle;

  /** the duration to walk "evo-walk-duration"*/
  double evoWalkDuration;
};


#endif // __MSH2004EvoSymbols_h_

/*
* Change Log
* 
* $Log: MSH2004EvoSymbols.h,v $
* Revision 1.3  2004/03/12 21:26:20  cesarz
* Evolution of walks in any walking direction is possible now.
*
* Revision 1.2  2004/03/08 01:07:13  roefer
* Interfaces should be const
*
* Revision 1.1  2004/02/26 18:07:28  cesarz
* first version of evolution behavior
*
*
*/

