/**
* @file MSH2004KickEngine.cpp
* 
* Implementation of class MSH2004KickEngine.
*
* @author Carsten Schumann (schumann@tempus-vivit.net)
*/
 
#include "MSH2004KickEngineSymbols.h"
//----------------------------------------------------------------------------
 
//----------------------------------------------------------------------------
MSH2004KickEngineSymbols::MSH2004KickEngineSymbols(const BehaviorControlInterfaces& interfaces, MSH2004KickEngine** kickEngine)
: BehaviorControlInterfaces(interfaces),
kickEngine(kickEngine)
{
  choosenKick.kick = MotionRequest::sit;
  choosenKick.foundBallX=10;
  choosenKick.foundBallY=3;
  beforeAndAfterCounter=0;
  currentTraining=MotionRequest::armKickLeft;
}

//----------------------------------------------------------------------------
void MSH2004KickEngineSymbols::registerSymbols(Xabsl2Engine& engine)
{
  engine.registerBooleanInputSymbol("kickengine.save",this,
    (bool (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineSave);
  engine.registerBooleanInputSymbol("kickengine.setBeforeState",this,
    (bool (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineSetBeforeState);
  engine.registerBooleanInputSymbol("kickengine.setAfterStateAndCommit",this,
    (bool (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineSetAfterStateAndCommit);

//  engine.registerDecimalInputFunction("kickengine.setTraining", this,
//    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::getSearchBallX);
  engine.registerDecimalInputFunction("kickengine.setTraining",this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::setCurrentTraining);
  engine.registerDecimalInputFunctionParameter("kickengine.setTraining","kickengine.setTraining.kick",kick);
  engine.registerDecimalInputSymbol("kickengine.trainingKick", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::getTrainingKick);


  engine.registerBooleanInputSymbol("kickengine.findTrainingPos",this,
    (bool (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineFindTrainingPos);
  engine.registerDecimalInputSymbol("kickengine.numberOfRemainingTrainingPos",this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineNumberOfRemainingTrainingPos);
  engine.registerBooleanInputSymbol("kickengine.setTry",this,
    (bool (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineSetTry);
  engine.registerDecimalInputSymbol("kickengine.findTrainingPos.x", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineFindTrainingPosX);
  engine.registerDecimalInputSymbol("kickengine.findTrainingPos.y", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineFindTrainingPosY);
  engine.registerDecimalInputSymbol("kickengine.findTrainingPos.xRelative", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineFindTrainingPosXRelative);
  engine.registerDecimalInputSymbol("kickengine.findTrainingPos.yRelative", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineFindTrainingPosYRelative);
  engine.registerDecimalInputSymbol("kickengine.findTrainingPos.xSector", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineFindTrainingPosXSector);
  engine.registerDecimalInputSymbol("kickengine.findTrainingPos.ySector", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineFindTrainingPosYSector);
  engine.registerDecimalInputSymbol("kickengine.ballRelative.x", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::getRobotRelativeBallPosX);
  engine.registerDecimalInputSymbol("kickengine.ballRelative.y", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::getRobotRelativeBallPosY);

// step 1: set target
  engine.registerDecimalInputFunction("kickengine.setTarget",this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::setTarget);
  engine.registerDecimalInputFunctionParameter("kickengine.setTarget","kickengine.setTarget.absoluteX",targetAbsoluteX);
  engine.registerDecimalInputFunctionParameter("kickengine.setTarget","kickengine.setTarget.absoluteY",targetAbsoluteY);
// step 2: find kick from current position
  engine.registerBooleanInputSymbol("kickengine.kickForTargetFromCurrentPositionKnown",this,
    (bool (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickForTargetFromCurrentPositionKnown);
// step 3: set search tolerances
// step 4: find nearby kick
  engine.registerBooleanInputSymbol("kickengine.kickForTargetFromNearbyPositionKnown",this,
    (bool (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickForTargetFromNearbyPositionKnown);
// step 5: get results
  engine.registerDecimalInputSymbol("kickengine.foundRobotPosition.x", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineFindTrainingPosX);
  engine.registerDecimalInputSymbol("kickengine.foundRobotPosition.y", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineFindTrainingPosY);
  engine.registerDecimalInputSymbol("kickengine.foundRobotPosition.xw", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineFindTrainingPosXWalking);
  engine.registerDecimalInputSymbol("kickengine.foundRobotPosition.yw", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::kickEngineFindTrainingPosYWalking);
  engine.registerDecimalInputSymbol("kickengine.foundSuccessRate", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::getFoundSuccessRate);
  engine.registerDecimalInputSymbol("kickengine.foundKick", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::getFoundKick);
  engine.registerDecimalInputSymbol("kickengine.foundSearchDistance", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::getFoundSearchDistance);
  engine.registerDecimalInputSymbol("kickengine.targetAngle", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::getTargetAngle);
  engine.registerDecimalInputSymbol("kickengine.targetDistance", this,
    (double (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::getTargetDistance);
  engine.registerBooleanInputSymbol("kickengine.setKickExecuted", this,
    (bool (Xabsl2FunctionProvider::*)())&MSH2004KickEngineSymbols::setKickExecuted);

}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::kickEngineNumberOfRemainingTrainingPos()
{
  return this->choosenKick.count;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::getTrainingKick()
{
  return (double) this->currentTraining;
};
//----------------------------------------------------------------------------
bool MSH2004KickEngineSymbols::kickEngineFindKick(double ballAngle, double ballDistance, double kickAngle, double kickDistance){
// depreciated
  return true;

}
//----------------------------------------------------------------------------
int MSH2004KickEngineSymbols::kickEngineGetPreferredKick()
{
  OUTPUT(idText,text,"MSH2004KickEngineSymbols::kickEngineGetPreferredKick");
  return 0;
};
//----------------------------------------------------------------------------
bool MSH2004KickEngineSymbols::kickEngineSave(){
  OUTPUT(idText,text,"MSH2004KickEngineSymbols::kickEngineSave");

  (**kickEngine).save();
  return true;
}
//----------------------------------------------------------------------------
bool MSH2004KickEngineSymbols::kickEngineSetBeforeState(){
//  OUTPUT(idText,text,"MSH2004KickEngineSymbols::kickEngineSetBeforeState");
  Vector2<double> a=this->ballPosition.seen-this->robotPose.translation;
  this->beforeX[beforeAndAfterCounter]=getRobotRelativeBallPosX();
  this->beforeY[beforeAndAfterCounter]=getRobotRelativeBallPosY();

  OUTPUT (idText,text,"Before: X="<<(**kickEngine).getBallXSector(beforeX[beforeAndAfterCounter])<<"("<<this->beforeX[beforeAndAfterCounter]<<") Y="<<(**kickEngine).getBallYSector(beforeY[beforeAndAfterCounter])<<"("<<this->beforeY[beforeAndAfterCounter]<<")");
//  OUTPUT (idText,text,"- A="<<a.angle()<<" D="<<a.abs());
  if (beforeAndAfterCounter==4){
    beforeAndAfterCounter=0;
    return true;
  } else {
    beforeAndAfterCounter++;
    return false;
  }
}
//----------------------------------------------------------------------------
void MSH2004KickEngineSymbols::quicksort(double data[], const int& start, const int& end) {
  if (start == end) {
    return;
  }
  double pivot = data[(start+end)/2];
  int left = start;
  int right = end;
  do {
    while (data[left] < pivot) {
      left++;
    }
    while (data[right] > pivot) {
      right--;
    }
    if (left < right) {
      double tmp = data[left];
      data[left] = data[right];
      data[right] = tmp;
    }
    if (left <= right) {
      left++;
      right--;
    }
  } while (left <= right);
  if (start < right) {
    quicksort(data, start, right);
  }
  if (end > left) {
    quicksort(data, left, end);
  }
}



bool MSH2004KickEngineSymbols::kickEngineSetAfterStateAndCommit(){
  if (ballPosition.seen.angle()>pi)
  {
    this->afterAngle[beforeAndAfterCounter]=this->ballPosition.seen.angle()-pi*2;
  } else {
    this->afterAngle[beforeAndAfterCounter]=this->ballPosition.seen.angle();
  }
  this->afterDistance[beforeAndAfterCounter]=this->ballPosition.seen.abs();

  OUTPUT (idText,text,"After: S"<<(**kickEngine).getKickSector(afterAngle[beforeAndAfterCounter])<<" D"<<(**kickEngine).getKickDistance(afterDistance[beforeAndAfterCounter]));
//  OUTPUT (idText,text,"- A="<<this->ballPosition.seen.angle()<<" D="<<this->ballPosition.seen.abs());
  if (beforeAndAfterCounter==4)
  {
    beforeAndAfterCounter=0;
    this->quicksort(this->beforeX,0,4);
    this->quicksort(this->beforeY,0,4);
    this->quicksort(this->afterAngle,0,4);
    this->quicksort(this->afterDistance,0,4);
    double bx=this->beforeX[2];
    double by=this->beforeY[2];
    double ka=afterAngle[2];
    double kd=afterDistance[2];


    (**kickEngine).addKick(bx,by,ka,kd,currentTraining);

    OUTPUT (idText,text,"X"<<(**kickEngine).getBallXSector(bx)<<"("<<bx<<")"<<
                        " Y"<<(**kickEngine).getBallYSector(by)<<"("<<by<<")"<<
                        " -> S"<<(**kickEngine).getKickSector(ka)<<
                        " D"<<(**kickEngine).getKickDistance(kd)<<
                        " ["<<currentTraining<<"]");


    return true;
  } else {
    beforeAndAfterCounter++;
    return false;
  }
}
//----------------------------------------------------------------------------
bool MSH2004KickEngineSymbols::kickEngineSetTry()
{
  (**kickEngine).registerTry(choosenKick.foundBallX,choosenKick.foundBallY,currentTraining);
  return true;
}
//----------------------------------------------------------------------------
void MSH2004KickEngineSymbols::setCurrentTraining()
{
  int k=(int) kick;
  
  this->currentTraining=(MotionRequest::SpecialActionID) k;
}
//----------------------------------------------------------------------------
bool MSH2004KickEngineSymbols::setKickExecuted()
{
  OUTPUT(idText,text,"Executing kick. Target[XY]=("<<targetAbsoluteX<<","<<targetAbsoluteY<<") Target[SD]=("<<choosenKick.foundKickSector<<","<<choosenKick.foundKickDistance<<") Found[XYK]=("<<choosenKick.foundBallX<<","<<choosenKick.foundBallY<<","<<choosenKick.kick<<")");
  return true;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::setTarget()
{
  Vector2<double> target;
  target.x=targetAbsoluteX;
  target.y=targetAbsoluteY;

  Vector2<double> v;
  v=target-robotPose.translation;
  this->targetDistance=v.abs();
  this->targetAngle=v.angle()-robotPose.rotation;
  return 1;
}
//----------------------------------------------------------------------------
bool MSH2004KickEngineSymbols::kickForTargetFromCurrentPositionKnown()
{
  setTarget(); // react to a changed robot pose
//  choosenKick=(**kickEngine).getPreferredKick(getRobotRelativeBallPosX(),getRobotRelativeBallPosY(),targetAngle,targetDistance,6);
  choosenKick=(**kickEngine).getNeighbourhoodKick(getRobotRelativeBallPosX(),getRobotRelativeBallPosY(),targetAngle,targetDistance,0,6);

  bool xValueSwapped=(sgn(choosenKick.ballXwhenCreated)-sgn(getRobotRelativeBallPosX()))!=0;
  bool yValueSwapped=(sgn(choosenKick.ballYwhenCreated)-sgn(getRobotRelativeBallPosY()))!=0;

  int deltaX=abs((int)(choosenKick.ballXwhenCreated-getRobotRelativeBallPosX()));
  int deltaY=abs((int)(choosenKick.ballYwhenCreated-getRobotRelativeBallPosY()));

  return (xValueSwapped && deltaY<40) || (yValueSwapped && deltaX<40) || (xValueSwapped && yValueSwapped) || (deltaX<20 && deltaY<20);
}
//----------------------------------------------------------------------------
bool MSH2004KickEngineSymbols::kickForTargetFromNearbyPositionKnown()
{
 

  setTarget(); // react to a changed robot pose
  (**kickEngine).setSearchToleranceMetrics(1,0);
  MSH2004KickEngineSearchResult found=(**kickEngine).getNeighbourhoodKick(getRobotRelativeBallPosX(),getRobotRelativeBallPosY(),targetAngle,targetDistance,30,3);

  if (found.foundBallX==choosenKick.foundBallX && found.foundBallY==choosenKick.foundBallY){
    found.ballXwhenCreated=choosenKick.ballXwhenCreated;
    found.ballYwhenCreated=choosenKick.ballYwhenCreated;
    choosenKick=found;
  } else {
    choosenKick=found;
    choosenKick.ballXwhenCreated=getRobotRelativeBallPosX();
    choosenKick.ballYwhenCreated=getRobotRelativeBallPosY();
  }
 /*if ((choosenKick.successRate) > 0.5){
    cout << "KESearch +: X="<<getRobotRelativeBallPosX()<<" Y="<<getRobotRelativeBallPosY()<<" ta="<<targetAngle<<" td="<<targetDistance;
  } else {
    cout << "KESearch -: X="<<getRobotRelativeBallPosX()<<" Y="<<getRobotRelativeBallPosY()<<" ta="<<targetAngle<<" td="<<targetDistance;
  }
  cout << flush;*/
  

  return (choosenKick.successRate) > 0.5;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::getFoundSuccessRate()
{
  return this->choosenKick.successRate;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::getFoundSearchDistance()
{
  return this->choosenKick.foundSearchDistance;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::getTargetDistance()
{
  return this->targetDistance;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::getTargetAngle()
{
  return this->targetAngle;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::getFoundKick()
{
  return this->choosenKick.kick;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::getRobotRelativeBallPosX()
{
  MSH2004KickEngineSearchResult dummy;
  Vector2<double> relative=dummy.getRelativeBall(ballPosition.seen,robotPose.getPose());
  return relative.x;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::getRobotRelativeBallPosY()
{
  MSH2004KickEngineSearchResult dummy;
  Vector2<double> relative=dummy.getRelativeBall(ballPosition.seen,robotPose.getPose());
  return relative.y;
}
//----------------------------------------------------------------------------

bool MSH2004KickEngineSymbols::kickEngineFindTrainingPos()
{
//  OUTPUT(idText,text,"Call 2");
  choosenKick=((**kickEngine).getUnknownPosition(currentTraining));
//  choosenKick.foundBallX=15;
//  choosenKick.foundBallY=0;
  if (choosenKick.successRate==1.0){
    return true;
  } else {
    return false;
  }
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::kickEngineFindTrainingPosX()
{ 
  Vector2<double> position;

  position=choosenKick.getAbsolutePosition(ballPosition.seen,robotPose.getPose());

  return position.x;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::kickEngineFindTrainingPosY()
{
  Vector2<double> position;
//                                              unk                (55,849)  
  position=choosenKick.getAbsolutePosition(ballPosition.seen,robotPose.getPose());

  return position.y;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::kickEngineFindTrainingPosXWalking()
{ 
  Vector2<double> position;

  position=choosenKick.getAbsolutePositionForWalking(ballPosition.seen,robotPose.getPose());

  return position.x;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::kickEngineFindTrainingPosYWalking()
{
  Vector2<double> position;
//                                              unk                (55,849)  
  position=choosenKick.getAbsolutePositionForWalking(ballPosition.seen,robotPose.getPose());

  return position.y;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::kickEngineFindTrainingPosXSector()
{ 
  return choosenKick.foundBallX;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::kickEngineFindTrainingPosYSector()
{
  return choosenKick.foundBallY;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::kickEngineFindTrainingPosXRelative()
{ 
  Vector2<double> movement=choosenKick.getNeededMovement(ballPosition.seen,robotPose.getPose());
  return movement.x;
}
//----------------------------------------------------------------------------
double MSH2004KickEngineSymbols::kickEngineFindTrainingPosYRelative()
{
  Vector2<double> movement=choosenKick.getNeededMovement(ballPosition.seen,robotPose.getPose());
  return movement.y;
}
//----------------------------------------------------------------------------
/*
 * Change log :
 * 
 * $Log: MSH2004KickEngineSymbols.cpp,v $
 * Revision 1.2  2004/04/08 15:33:04  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.8  2004/03/30 16:23:18  pg_miwa
 * Bugfix
 *
 * Revision 1.7  2004/03/30 14:12:30  pg_cars
 * Added improved ball grabbing
 *
 * Revision 1.6  2004/03/29 14:44:21  pg_cars
 * Kick engine works now ;-)
 * Use PID Ball Locator and MSH2004-test behavior for testing
 *
 * Revision 1.5  2004/03/26 11:24:49  pg_cars
 * StickOMat
 *
 * Revision 1.4  2004/03/26 09:21:49  pg_cars
 * datafile changed, aggressive kick engine
 *
 * Revision 1.3  2004/03/25 21:05:25  pg_cars
 * change of datafile, before backup
 *
 * Revision 1.2  2004/03/22 17:53:08  pg_cars
 * improved training for kick engine
 *
 * Revision 1.1  2004/03/15 15:59:45  schumann
 * splitted symbols for kick engine from other symbols
 *
*/
