/** 
* @file MSH2004TestSymbols.h
*
* Declaration of class MSH2004TestSymbols.
*
* @author Michael Wachter
*/

#ifndef __MSH2004TestSymbols_h_
#define __MSH2004TestSymbols_h_

#include "../../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"
#include "Tools/DynamicTeamTactic/TacticChooser.h"

/**
* The Xabsl2 symbols that are defined in "dtt-symbols.xml"
*
* @author Jochen Kerdels
*/ 
class MSH2004TestSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
private:
  
 public:

  /*
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  MSH2004TestSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
  /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  enum MovingOrder {forward,backward,left,right,rotateLeft,rotateRight,none};

  MovingOrder movingOrder;
  double lastBallYPosition;
  long lastBallYPositionTime;
  //!@}

};


#endif // __MSH2004TestSymbols_h_

/*
* Change Log
* 
* $Log: MSH2004TestSymbols.h,v $
* Revision 1.5  2004/03/15 14:28:44  wachter
* Warning fixed
*
* Revision 1.4  2004/03/14 18:19:24  wachter
* rewrote glassbox-goalie
*
* Revision 1.3  2004/03/08 01:07:14  roefer
* Interfaces should be const
*
* Revision 1.2  2004/02/25 05:43:20  wachter
* Doxygen bugs and changelog fixed
*
* Revision 1.1  2004/02/24 21:11:09  wachter
* Added some xabsl-symbols for testing.
*
*
*/

