/**
* @file MotionRatingBehaviorMessage.h
* 
* Definition of class MotionRatingBehaviorMessage
*
* @author Sebastian Petters
* @author Dirk Thomas
*/

#ifndef __MotionRatingBehaviorMessage_h_
#define __MotionRatingBehaviorMessage_h_

// forward declaration
class MotionRatingBehaviorMessage;

#include "Tools/Streams/InOut.h"
#include <string.h>

/**
* @class MotionRatingBehaviorMessage
*
* @author Sebastian Petters
* @author Dirk Thomas
*/
class MotionRatingBehaviorMessage
{
public:
  
  enum MessageType {
    none = 0,
    test,
    // messages to robot
    ping, report,
    // messages to controler
    init, request, abort, pause, proceed, stop, sleep,
    numOfMessageTypes
  };

  enum States { unknown, sleeping, preparing, waiting, testing };
  
  MessageType type;
  States state;
  int paramSetId;
  int data;
  double currentSpeed;
  double averageSpeed;
  int currentWalk;
  int walkCount;
  bool finished;
  char remainingPower;
  double distance;
  unsigned long time;
  
  /** Constructor */
  MotionRatingBehaviorMessage();
 
  static char* getStateName ( States state )
  {
    switch ( state )
    {
      case unknown: return "unknown";
      case sleeping: return "sleeping";
      case preparing: return "preparing";
      case waiting: return "waiting";
      case testing: return "testing";
      default: return "undefined state";
    }
  };

};

In& operator>>(In& stream, MotionRatingBehaviorMessage& message);

Out& operator<<(Out& stream, const MotionRatingBehaviorMessage& message);


#endif// __MotionRatingBehaviorMessage_h_

/*
* Change log :
* 
* $Log: MotionRatingBehaviorMessage.h,v $
* Revision 1.1  2004/03/17 16:18:49  thomas
* added preversion of motion optimisation with behaviour, selflocator, headcontrol and robotcontrol dialog
*
*
*/
