/**
* @file DefaultCollisionDetector.h
* 
* This file contains a class for Collision Detection.
*/

#ifndef __DefaultCollisionDetector_h_
#define __DefaultCollisionDetector_h_

#include "CollisionDetector.h"
#include "Representations/Perception/SensorData.h"

/**
* @class DefaultCollisionDetector
* 
* The default CollisionDetector in the GT2003 project.
*/
class DefaultCollisionDetector : public CollisionDetector
{
private:
  int ringBuffer[SensorData::numOfSensor_ERS210][128][2];
  int floatingAvg[SensorData::numOfSensor_ERS210][SensorDataBuffer::maxNumOfFrames][16];
  int minAvg[SensorData::numOfSensor_ERS210][SensorDataBuffer::maxNumOfFrames]; //best matching phase delay
  int threshold[SensorData::numOfSensor_ERS210][3]; //min, max and current threshold value
  int oldVal;           // the old Difference between Sensor and actor
  int newVal;           // the new Difference between Sensor and actor
  int index;            // number of the sensor data number rounded to quadruples
  int min;              // minimum delay value for sensor to actor delay in 125ths seconds
  int max;              // maximum delay value for sensor to actor delay in 125ths seconds
  int infin;            // very large integer
  int walkingMode;      // 0 = out of range, 1 = just straight, 2 = just side, 3 = left, 4 = right, 5 = rotation
  int q;                // Queue length
  
  double lastMotionChange; // frame number of last motion change
  double currentMotionX;      // current motion.x value
  double currentMotionY;      // current motion.y value
  double currentRotation;     // current rotation value
  double lastMotionX;      // previous motion.x value
  double lastMotionY;      // previous motion.y value
  double lastRotation;     // previous rotation value
  double motionChangeThresholdX; // threshold which is allowed from one to another x motion speed
  double motionChangeThresholdY; // threshold which is allowed from one to another y motion speed
  double motionChangeThresholdR; // threshold which is allowed from one to another rot. motion speed
  
  double frontMin; //minimum front walking speed value which is allowed for recognition
  double frontMax; //maximum front walking speed value which is allowed for recognition
  double backMin; //minimum front walking speed value which is allowed for recognition
  double backMax; //maximum front walking speed value which is allowed for recognition
  double sideMin; //minimum side walking speed value which is allowed for recognition
  double sideMax; //maximum side walking speed value which is allowed for recognition
  double rotMin; //minimum rotating speed value which is allowed for recognition
  double rotMax; //maximum rotating speed value which is allowed for recognition
  double calmDown; // the number of frames it takes the robot to wait after motion change in 125th secs.
  double scaleThresholdFore; // a scale factor for foreward move thresholds
  double scaleThresholdBack; // a scale factor for backward move thresholds
  double scaleThresholdSide; // a scale factor for side move thresholds
  double scaleThresholdRot;  // a scale factor for rotation move thresholds
  double motionChangeThresholdFactor; // a scale factor to compensate motion changes
  double lastTooBigMotionChange;      //last motion change that has too be considered in col.det.
  double xRatio; // Difference between two straight movements
  double yRatio; // Difference between two side movements
  double rRatio; // Difference between two rotation movements


  /* DEBUG /

  double maxfl1;
  double maxfl2;
  double maxfr1;
  double maxfr2;
  double maxhl1;
  double maxhl2;
  double maxhr1;
  double maxhr2;
  */

public:
  /**
  * Constructor
  *
  */
  DefaultCollisionDetector(const CollisionDetectorInterfaces& interfaces);
  
  /** Executes the module */
  virtual void execute();

private:
  /** Calculated the angle thresholds */
  void calculateThresholds();
};

#endif// __DefaultCollisionDetector_h_

/*
 * Change log : 
 *
 *  $Log: DefaultCollisionDetector.h,v $
 *  Revision 1.3  2004/03/08 01:38:49  roefer
 *  Interfaces should be const
 *
 *  Revision 1.2  2003/12/31 20:16:13  roefer
 *  SensorData for ERS-7
 *
 *  Revision 1.1  2003/10/06 14:10:14  cvsadm
 *  Created GT2004 (M.J.)
 *
 *  Revision 1.7  2003/09/26 15:27:49  juengel
 *  Renamed DataTypes to representations.
 *
 *  Revision 1.6  2003/07/15 12:49:14  goehring
 *  Speed optimized
 *
 */
