/**
* @file ColorTable64Mod.h
* Declaration of class ColorTable64Mod.
*
* @author <A href=mailto:walter.nistico@uni-dortmund.de>Walter Nistico</A>
*/

#ifndef _ColorTable64Mod_h_
#define _ColorTable64Mod_h_

#include "ColorTableMod.h"
#include "Representations/Perception/ColorTable64.h"
#include "Tools/Streams/InOut.h"

/**
* @class ColorTable64Mod
*
* This class is a wrapper used by ColorTableModSelector to load and instantiate
* a colormap of type ColorTable64.
*
* @author <A href=mailto:walter.nistico@uni-dortmund.de>Walter Nistico</A>
*/
class ColorTable64Mod : public ColorTableMod
{
public:
  /** Constructor */
  ColorTable64Mod(const ColorTableModInterfaces& interfaces)
    : ColorTableMod(interfaces)
  {}
  
  /**
  * Loads and instantiates this kind of colormap by copying it back to the
  *  main colorTable buffer */
  void setup();
  
  /** this method does nothing here, it's just required by the Module interface */
  void execute() {};
  
};

#endif

/*
* Change log :
*
* $Log: ColorTable64Mod.h,v $
* Revision 1.3  2004/03/08 01:38:50  roefer
* Interfaces should be const
*
* Revision 1.2  2004/02/29 13:37:15  dueffert
* doxygen bugs fixed and beautified
*
* Revision 1.1  2004/01/30 15:44:34  nistico
* Created a Color Table Selector, which permits to switch color tables at run time using the same image processor.
* If your image processor was designed to use only ColorTable64, leave it as the default choice and you should
* (hopefully) have no problems.
* In case of trouble, i put a conditional compilation switch in SolutionRequest.h, simply uncomment the definition of NO_COLOR_TABLE_SELECTOR; in that case, the code should get back to the original solution, but the coltable which will be looked upon first for loading will be ColorTable64 (as it's the default solution), so there's no reason anymore to remove the other color tables from the CVS.
*
*
*/
